/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.util;

import com.clustercontrol.ClusterControlPlugin;
import com.clustercontrol.accesscontrol.dialog.LoginDialog;
import com.clustercontrol.accesscontrol.ejb.session.AccessCheck;
import com.clustercontrol.accesscontrol.ejb.session.AccessCheckHome;
import com.clustercontrol.util.Messages;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WWinActionBars;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.util.StatusLineContributionItem;
import org.jboss.naming.NamingContextFactory;
import org.jboss.security.auth.callback.UsernamePasswordHandler;
import org.jnp.interfaces.NamingContext;

public class LoginManager {
    public static final String KEY_EJB_URL = "ejbUrl";
    public static final String VALUE_EJB_URL = "jnp://localhost:1099";
    public static final String KEY_EJB_UID = "ejbUid";
    public static final String VALUE_EJB_UID = "hinemos";
    public static final String USER_OBJECT_ID = "com.clustercontrol.accesscontrol.user";
    public static final String URL_OBJECT_ID = "com.clustercontrol.accesscontrol.url";
    public static final String ACTION_SET_ID = "com.clustercontrol.accesscontrol.ActionSet";
    public static final String ACTION_ID_LOGIN = "com.clustercontrol.accesscontrol.etc.action.LoginAction";
    public static final String ACTION_ID_LOGOUT = "com.clustercontrol.accesscontrol.etc.action.LogoutAction";
    private static LoginManager m_instance = null;
    private NamingContext m_namingcontext = null;
    private LoginContext m_loginContext = null;
    private String m_url = null;
    private String m_uid = null;
    private String m_password = null;

    public static LoginManager getContextManager() {
        if (m_instance == null) {
            m_instance = new LoginManager();
        }
        return m_instance;
    }

    private LoginManager() {
        try {
            Configuration.setConfiguration(new HinemosClientConfig());
        }
        catch (Exception exception) {}
    }

    public synchronized void login(String uid, String password, String url) throws Exception {
        this.logout();
        this.m_uid = uid;
        this.m_password = password;
        this.m_namingcontext = this.getContext(url);
        try {
            AccessCheckHome home = (AccessCheckHome)this.m_namingcontext.lookup("AccessCheck");
            AccessCheck accessCheck = home.create();
            accessCheck.checkLogin();
            IWorkbench workbench = PlatformUI.getWorkbench();
            WorkbenchWindow workbenchWindow = (WorkbenchWindow)workbench.getActiveWorkbenchWindow();
            WWinActionBars bars = workbenchWindow.getActionBars();
            IStatusLineManager lineManager = bars.getStatusLineManager();
            StatusLineContributionItem statusLine = new StatusLineContributionItem(USER_OBJECT_ID, 100);
            statusLine.setText(String.valueOf(Messages.getString("hinemos.user")) + " : " + this.m_uid + "     " + Messages.getString("connection.url") + " : " + this.m_url);
            lineManager.add((IContributionItem)statusLine);
            lineManager.update(true);
            IPreferenceStore store = ClusterControlPlugin.getDefault().getPreferenceStore();
            store.setValue(KEY_EJB_URL, url);
            store.setValue(KEY_EJB_UID, uid);
        }
        catch (Exception e) {
            this.logout();
            throw e;
        }
    }

    public synchronized void logout() throws NamingException {
        if (this.m_loginContext instanceof LoginContext) {
            try {
                this.m_loginContext.logout();
                this.m_uid = null;
                IWorkbench workbench = PlatformUI.getWorkbench();
                WorkbenchWindow workbenchWindow = (WorkbenchWindow)workbench.getActiveWorkbenchWindow();
                WWinActionBars bars = workbenchWindow.getActionBars();
                IStatusLineManager lineManager = bars.getStatusLineManager();
                IContributionItem item = lineManager.find(USER_OBJECT_ID);
                lineManager.remove(item);
                lineManager.update(true);
            }
            catch (LoginException loginException) {}
        }
        this.m_loginContext = null;
        this.m_namingcontext = null;
    }

    public boolean isLogin() {
        return this.m_loginContext instanceof LoginContext;
    }

    public synchronized NamingContext getNamingContext() throws NamingException {
        Shell shell;
        LoginDialog dialog;
        if (!this.isLogin() && (dialog = new LoginDialog(shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell())).open() == 0) {
            try {
                this.login(dialog.getUserid(), dialog.getPassword(), dialog.getUrl());
                MessageDialog.openInformation(null, (String)Messages.getString("successful"), (String)Messages.getString("message.accesscontrol.5"));
            }
            catch (Exception exception) {
                MessageDialog.openError(null, (String)Messages.getString("failed"), (String)Messages.getString("message.accesscontrol.6"));
            }
        }
        return this.m_namingcontext;
    }

    private NamingContext getContext() throws NamingException, LoginException {
        String url = this.getUrl();
        return this.getContext(url);
    }

    private NamingContext getContext(String url) throws NamingException, LoginException {
        this.m_url = url;
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("java.naming.provider.url", this.m_url);
        UsernamePasswordHandler handler = new UsernamePasswordHandler(this.m_uid, this.m_password.toCharArray());
        this.m_loginContext = new LoginContext("hinemosClient", (CallbackHandler)handler);
        this.m_loginContext.login();
        NamingContextFactory ncf = new NamingContextFactory();
        NamingContext namingContext = (NamingContext)ncf.getInitialContext(props);
        return namingContext;
    }

    private String getUrl() {
        IPreferenceStore store = ClusterControlPlugin.getDefault().getPreferenceStore();
        String url = store.getString(KEY_EJB_URL);
        if (url.compareTo("") == 0) {
            url = VALUE_EJB_URL;
        }
        return url;
    }

    class HinemosClientConfig
    extends Configuration {
        HinemosClientConfig() {
        }

        public void refresh() {
        }

        public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
            AppConfigurationEntry[] entry = null;
            try {
                Class[] parameterTypes = new Class[]{};
                Method m = this.getClass().getDeclaredMethod(name, parameterTypes);
                Object[] args = new Object[]{};
                entry = (AppConfigurationEntry[])m.invoke((Object)this, args);
            }
            catch (Exception exception) {}
            return entry;
        }

        AppConfigurationEntry[] hinemosClient() {
            String name = "org.jboss.security.ClientLoginModule";
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("multi-threaded", "true");
            options.put("restore-login-identity", "true");
            AppConfigurationEntry ace = new AppConfigurationEntry(name, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
            AppConfigurationEntry[] entry = new AppConfigurationEntry[]{ace};
            return entry;
        }
    }
}

