/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.maintenance.composite;

import com.clustercontrol.bean.Schedule;
import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.maintenance.action.GetMaintenance;
import com.clustercontrol.maintenance.action.GetMaintenanceListTableDefine;
import com.clustercontrol.maintenance.action.GetSchedule;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaintenanceListComposite
extends Composite {
    private CommonTableViewer tableViewer = null;

    public MaintenanceListComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Table table = new Table((Composite)this, 66306);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        table.setLayoutData((Object)gridData);
        this.tableViewer = new CommonTableViewer(table);
        this.tableViewer.createTableColumn(GetMaintenanceListTableDefine.get(), 0, 1);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.update();
    }

    public CommonTableViewer getTableViewer() {
        return this.tableViewer;
    }

    public void update() {
        ArrayList maintenanceList = new GetMaintenance().getMaintenanceList();
        ArrayList scheduleList = new GetSchedule().getScheduleList();
        int i = 0;
        while (i < maintenanceList.size()) {
            ArrayList maintenanceInfo = (ArrayList)maintenanceList.get(i);
            String maintenaneId = (String)maintenanceInfo.get(0);
            int j = 0;
            while (j < scheduleList.size()) {
                ArrayList schedule = (ArrayList)scheduleList.get(j);
                if (maintenaneId.equals(schedule.get(2))) {
                    maintenanceInfo.set(5, (Schedule)schedule.get(5));
                }
                ++j;
            }
            ++i;
        }
        this.tableViewer.setInput(maintenanceList);
    }

    public ArrayList<String> getSelectionData() {
        ArrayList<String> data = new ArrayList<String>();
        StructuredSelection selection = (StructuredSelection)this.tableViewer.getSelection();
        List list = selection.toList();
        if (list != null) {
            int index = 0;
            while (index < list.size()) {
                ArrayList info = (ArrayList)list.get(index);
                if (info != null && info.size() > 0) {
                    String maintenanceId = (String)info.get(0);
                    data.add(maintenanceId);
                }
                ++index;
            }
        }
        return data;
    }
}

