/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.text;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.text.BreakIterator;
import org.jfree.text.TextBlock;
import org.jfree.text.TextMeasurer;
import org.jfree.util.Log;
import org.jfree.util.LogContext;

public abstract class TextUtilities {
    protected static final LogContext logger = Log.createContext(class$org$jfree$text$TextUtilities == null ? (class$org$jfree$text$TextUtilities = TextUtilities.class$("org.jfree.text.TextUtilities")) : class$org$jfree$text$TextUtilities);
    private static boolean useFontMetricsGetStringBounds = false;
    static /* synthetic */ Class class$org$jfree$text$TextUtilities;

    public static TextBlock createTextBlock(String string, Font font, Paint paint, float f, TextMeasurer textMeasurer) {
        return TextUtilities.createTextBlock(string, font, paint, f, Integer.MAX_VALUE, textMeasurer);
    }

    public static TextBlock createTextBlock(String string, Font font, Paint paint, float f, int n, TextMeasurer textMeasurer) {
        TextBlock textBlock = new TextBlock();
        BreakIterator breakIterator = BreakIterator.getLineInstance();
        breakIterator.setText(string);
        int n2 = 0;
        int n3 = string.length();
        for (int i = 0; n2 < n3 && i < n; ++i) {
            int n4 = TextUtilities.nextLineBreak(string, n2, f, breakIterator, textMeasurer);
            if (n4 == -1) {
                textBlock.addLine(string.substring(n2), font, paint);
                return textBlock;
            }
            textBlock.addLine(string.substring(n2, n4), font, paint);
            n2 = n4;
        }
        return textBlock;
    }

    private static int nextLineBreak(String string, int n, float f, BreakIterator breakIterator, TextMeasurer textMeasurer) {
        int n2;
        int n3 = n;
        float f2 = 0.0f;
        boolean bl = true;
        while ((n2 = breakIterator.next()) != -1) {
            if ((f2 += textMeasurer.getStringWidth(string, n3, n2)) > f) {
                if (bl) {
                    while (textMeasurer.getStringWidth(string, n, n2) > f) {
                        --n2;
                    }
                    return n2;
                }
                n2 = breakIterator.previous();
                return n2;
            }
            bl = false;
            n3 = n2;
        }
        return -1;
    }

    public static Rectangle2D getTextBounds(String string, Graphics2D graphics2D, FontMetrics fontMetrics) {
        Rectangle2D rectangle2D = null;
        if (useFontMetricsGetStringBounds) {
            rectangle2D = fontMetrics.getStringBounds(string, graphics2D);
        } else {
            double d = fontMetrics.stringWidth(string);
            double d2 = fontMetrics.getHeight();
            if (logger.isDebugEnabled()) {
                logger.debug("Height = " + d2);
            }
            rectangle2D = new Rectangle2D.Double(0.0, -fontMetrics.getAscent(), d, d2);
        }
        return rectangle2D;
    }

    public static boolean getUseFontMetricsGetStringBounds() {
        return useFontMetricsGetStringBounds;
    }

    public static void setUseFontMetricsGetStringBounds(boolean bl) {
        useFontMetricsGetStringBounds = bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

