/*
 * Decompiled with CFR 0.152.
 */
package javax.enterprise.deploy.shared.factories;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import org.jboss.logging.Logger;

public final class DeploymentFactoryManager {
    private static final Logger log = Logger.getLogger((Class)(class$javax$enterprise$deploy$shared$factories$DeploymentFactoryManager == null ? (class$javax$enterprise$deploy$shared$factories$DeploymentFactoryManager = DeploymentFactoryManager.class$("javax.enterprise.deploy.shared.factories.DeploymentFactoryManager")) : class$javax$enterprise$deploy$shared$factories$DeploymentFactoryManager));
    private static final DeploymentFactoryManager instance = new DeploymentFactoryManager();
    private Set deploymentFactories = Collections.synchronizedSet(new HashSet());
    static /* synthetic */ Class class$javax$enterprise$deploy$shared$factories$DeploymentFactoryManager;

    private DeploymentFactoryManager() {
    }

    public static DeploymentFactoryManager getInstance() {
        return instance;
    }

    public DeploymentFactory[] getDeploymentFactories() {
        DeploymentFactory[] arr = new DeploymentFactory[this.deploymentFactories.size()];
        return this.deploymentFactories.toArray(arr);
    }

    public DeploymentManager getDeploymentManager(String uri, String userName, String password) throws DeploymentManagerCreationException {
        Iterator i = this.deploymentFactories.iterator();
        while (i.hasNext()) {
            DeploymentFactory factory = (DeploymentFactory)i.next();
            if (!factory.handlesURI(uri)) continue;
            return factory.getDeploymentManager(uri, userName, password);
        }
        throw new DeploymentManagerCreationException("No deployment manager for uri=" + uri);
    }

    public void registerDeploymentFactory(DeploymentFactory factory) {
        this.deploymentFactories.add(factory);
    }

    public DeploymentManager getDisconnectedDeploymentManager(String uri) throws DeploymentManagerCreationException {
        Iterator i = this.deploymentFactories.iterator();
        while (i.hasNext()) {
            DeploymentFactory factory = (DeploymentFactory)i.next();
            if (!factory.handlesURI(uri)) continue;
            return factory.getDisconnectedDeploymentManager(uri);
        }
        throw new DeploymentManagerCreationException("No deployment manager for uri=" + uri);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> factoryClass = cl.loadClass("org.jboss.deployment.spi.factories.DeploymentFactoryImpl");
            DeploymentFactory factory = (DeploymentFactory)factoryClass.newInstance();
            DeploymentFactoryManager dfManager = DeploymentFactoryManager.getInstance();
            dfManager.registerDeploymentFactory(factory);
        }
        catch (Exception e) {
            log.error((Object)("Cannot register DeploymentFactory: " + e.toString()));
        }
    }
}

