/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.factory;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.PropertyTreeItem;
import com.clustercontrol.jobmanagement.bean.OperationConstant;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionJobUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodeLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodePK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionNodeUtil;
import com.clustercontrol.jobmanagement.factory.JobOperationJudgment;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;

public class JobOperationProperty {
    public static final String SESSION = "session";
    public static final String JOB = "job";
    public static final String FACILITY = "facility";
    public static final String CONTROL = "control";
    public static final String END_VALUE = "endValue";

    public Property getStartProperty(String sessionId, String jobId, String facilityId, Locale locale) {
        Property session = new Property(SESSION, Messages.getString((String)"session.id", (Locale)locale), "com.clustercontrol.composite.TextPropertyDefine");
        Property job = new Property(JOB, Messages.getString((String)"job.id", (Locale)locale), "com.clustercontrol.composite.TextPropertyDefine");
        Property facility = new Property(FACILITY, Messages.getString((String)"facility.id", (Locale)locale), "com.clustercontrol.composite.TextPropertyDefine");
        Property control = new Property(CONTROL, Messages.getString((String)CONTROL, (Locale)locale), "com.clustercontrol.composite.ComboPropertyDefine");
        int status = 0;
        int jobType = 0;
        try {
            JobSessionJobLocal sessionJob;
            if (facilityId != null && facilityId.length() > 0) {
                sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
                if (sessionJob.getJobInfo().getJob_type() == 3) {
                    jobId = jobId + "_" + facilityId;
                    facilityId = null;
                    JobSessionJobLocal childSessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
                    status = childSessionJob.getStatus();
                    jobType = 0;
                } else {
                    JobSessionNodeLocal sessionNode = JobSessionNodeUtil.getLocalHome().findByPrimaryKey(new JobSessionNodePK(sessionId, jobId, facilityId));
                    status = sessionNode.getStatus();
                    jobType = 2;
                }
            } else {
                sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
                status = sessionJob.getStatus();
                jobType = sessionJob.getJobInfo().getJob_type() == 2 ? 1 : 0;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        ArrayList<String> values = new ArrayList<String>();
        if (JobOperationJudgment.judgment(1, jobType, status)) {
            values.add(OperationConstant.STRING_START_AT_ONCE);
        }
        if (JobOperationJudgment.judgment(3, jobType, status)) {
            values.add(OperationConstant.STRING_START_SUSPEND);
        }
        if (JobOperationJudgment.judgment(7, jobType, status)) {
            values.add(OperationConstant.STRING_START_WAIT);
        }
        if (JobOperationJudgment.judgment(5, jobType, status)) {
            values.add(OperationConstant.STRING_START_SKIP);
        }
        Object[][] controlValues = new Object[][]{values.toArray(), values.toArray()};
        control.setSelectValues(controlValues);
        if (values.size() >= 1) {
            control.setValue(values.get(0));
        } else {
            control.setValue((Object)"");
        }
        session.setValue((Object)sessionId);
        job.setValue((Object)jobId);
        if (facilityId != null && facilityId.length() > 0) {
            facility.setValue((Object)facilityId);
        } else {
            facility.setValue((Object)"");
        }
        session.setModify(0);
        job.setModify(0);
        facility.setModify(0);
        control.setModify(1);
        Property property = new Property(null, null, "");
        property.removeChildren();
        property.addChildren((PropertyTreeItem)session);
        property.addChildren((PropertyTreeItem)job);
        if (facilityId != null && facilityId.length() > 0) {
            property.addChildren((PropertyTreeItem)facility);
        }
        property.addChildren((PropertyTreeItem)control);
        return property;
    }

    public Property getStopProperty(String sessionId, String jobId, String facilityId, Locale locale) {
        Property session = new Property(SESSION, Messages.getString((String)"session.id", (Locale)locale), "com.clustercontrol.composite.TextPropertyDefine");
        Property job = new Property(JOB, Messages.getString((String)"job.id", (Locale)locale), "com.clustercontrol.composite.TextPropertyDefine");
        Property facility = new Property(FACILITY, Messages.getString((String)"facility.id", (Locale)locale), "com.clustercontrol.composite.TextPropertyDefine");
        Property control = new Property(CONTROL, Messages.getString((String)CONTROL, (Locale)locale), "com.clustercontrol.composite.ComboPropertyDefine");
        Property endValue = new Property(END_VALUE, Messages.getString((String)"end.value", (Locale)locale), "com.clustercontrol.composite.IntegerPropertyDefine", Short.MAX_VALUE, Short.MIN_VALUE);
        ArrayList<Property> endList = new ArrayList<Property>();
        endList.add(endValue);
        HashMap<String, Object> skipEndMap = new HashMap<String, Object>();
        skipEndMap.put("value", OperationConstant.STRING_STOP_SKIP);
        skipEndMap.put("property", endList);
        HashMap<String, Object> mainteEndMap = new HashMap<String, Object>();
        mainteEndMap.put("value", OperationConstant.STRING_STOP_MAINTENANCE);
        mainteEndMap.put("property", endList);
        int status = 0;
        int jobType = 0;
        try {
            JobSessionJobLocal sessionJob;
            if (facilityId != null && facilityId.length() > 0) {
                sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
                if (sessionJob.getJobInfo().getJob_type() == 3) {
                    jobId = jobId + "_" + facilityId;
                    facilityId = null;
                    JobSessionJobLocal childSessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
                    status = childSessionJob.getStatus();
                    jobType = 0;
                } else {
                    JobSessionNodeLocal sessionNode = JobSessionNodeUtil.getLocalHome().findByPrimaryKey(new JobSessionNodePK(sessionId, jobId, facilityId));
                    status = sessionNode.getStatus();
                    jobType = 2;
                }
            } else {
                sessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(sessionId, jobId));
                status = sessionJob.getStatus();
                jobType = sessionJob.getJobInfo().getJob_type() == 2 ? 1 : 0;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        ArrayList<String> values1 = new ArrayList<String>();
        ArrayList<Object> values2 = new ArrayList<Object>();
        if (JobOperationJudgment.judgment(0, jobType, status)) {
            values1.add(OperationConstant.STRING_STOP_AT_ONCE);
            values2.add(OperationConstant.STRING_STOP_AT_ONCE);
        }
        if (JobOperationJudgment.judgment(2, jobType, status)) {
            values1.add(OperationConstant.STRING_STOP_SUSPEND);
            values2.add(OperationConstant.STRING_STOP_SUSPEND);
        }
        if (JobOperationJudgment.judgment(6, jobType, status)) {
            values1.add(OperationConstant.STRING_STOP_WAIT);
            values2.add(OperationConstant.STRING_STOP_WAIT);
        }
        if (JobOperationJudgment.judgment(4, jobType, status)) {
            values1.add(OperationConstant.STRING_STOP_SKIP);
            values2.add(skipEndMap);
        }
        if (JobOperationJudgment.judgment(8, jobType, status)) {
            values1.add(OperationConstant.STRING_STOP_MAINTENANCE);
            values2.add(mainteEndMap);
        }
        Object[][] controlValues = new Object[][]{values1.toArray(), values2.toArray()};
        control.setSelectValues(controlValues);
        if (values1.size() >= 1) {
            control.setValue(values1.get(0));
        } else {
            control.setValue((Object)"");
        }
        endValue.setValue((Object)"");
        session.setValue((Object)sessionId);
        job.setValue((Object)jobId);
        if (facilityId != null && facilityId.length() > 0) {
            facility.setValue((Object)facilityId);
        } else {
            facility.setValue((Object)"");
        }
        session.setModify(0);
        job.setModify(0);
        facility.setModify(0);
        control.setModify(1);
        endValue.setModify(1);
        Property property = new Property(null, null, "");
        property.removeChildren();
        property.addChildren((PropertyTreeItem)session);
        property.addChildren((PropertyTreeItem)job);
        if (facilityId != null && facilityId.length() > 0) {
            property.addChildren((PropertyTreeItem)facility);
        }
        property.addChildren((PropertyTreeItem)control);
        if (OperationConstant.STRING_STOP_SKIP.compareTo((String)control.getValue()) == 0 || OperationConstant.STRING_STOP_MAINTENANCE.compareTo((String)control.getValue()) == 0) {
            control.addChildren((PropertyTreeItem)endValue);
        }
        return property;
    }
}

