/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.monitor.services;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedLong;
import java.util.LinkedList;
import java.util.List;
import javax.management.Notification;
import javax.management.ObjectName;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.jboss.monitor.alarm.AlarmManager;
import org.jboss.monitor.services.ScriptingListenerMBean;
import org.jboss.system.ListenerServiceMBeanSupport;
import org.jboss.system.ServiceMBeanSupport;

public class ScriptingListener
extends ListenerServiceMBeanSupport
implements ScriptingListenerMBean {
    private String script;
    private String language;
    private boolean dynamicSubscriptions;
    private ObjectName targetListener;
    private SynchronizedLong notificationsReceived;
    private SynchronizedLong notificationsProcessed;
    private SynchronizedLong totalProcessingTime;
    private BSFManager manager;
    private List queue;
    private boolean stopRequested;
    private Thread processorThread;
    private AlarmManager alm = new AlarmManager((ServiceMBeanSupport)this);
    static /* synthetic */ Class class$org$jboss$logging$Logger;
    static /* synthetic */ Class class$javax$management$MBeanServer;
    static /* synthetic */ Class class$org$jboss$monitor$alarm$AlarmManager;
    static /* synthetic */ Class class$javax$management$Notification;
    static /* synthetic */ Class class$java$lang$Object;

    public ScriptingListener() {
        this.queue = new LinkedList();
        this.notificationsReceived = new SynchronizedLong(0L);
        this.notificationsProcessed = new SynchronizedLong(0L);
        this.totalProcessingTime = new SynchronizedLong(0L);
    }

    public void setScript(String script) {
        this.script = script;
    }

    public String getScript() {
        return this.script;
    }

    public void setScriptLanguage(String language) {
        this.language = language;
    }

    public String getScriptLanguage() {
        return this.language;
    }

    public void setDynamicSubscriptions(boolean dynamicSubscriptions) {
        this.dynamicSubscriptions = dynamicSubscriptions;
    }

    public boolean getDynamicSubscriptions() {
        return this.dynamicSubscriptions;
    }

    public long getNotificationsReceived() {
        return this.notificationsReceived.get();
    }

    public long getNotificationsProcessed() {
        return this.notificationsProcessed.get();
    }

    public long getTotalProcessingTime() {
        return this.totalProcessingTime.get();
    }

    public long getAverageProcessingTime() {
        long processed = this.notificationsProcessed.get();
        return processed == 0L ? 0L : this.totalProcessingTime.get() / processed;
    }

    public void startService() throws Exception {
        this.log.debug((Object)("Initializing BSFManager for language '" + this.language + "'"));
        BSFManager.registerScriptingEngine((String)"groovy", (String)"org.codehaus.groovy.bsf.GroovyEngine", (String[])new String[]{"groovy", "gy"});
        this.manager = new BSFManager();
        this.manager.setClassLoader(Thread.currentThread().getContextClassLoader());
        this.manager.loadScriptingEngine(this.language);
        this.manager.declareBean("log", (Object)this.log, class$org$jboss$logging$Logger == null ? (class$org$jboss$logging$Logger = ScriptingListener.class$("org.jboss.logging.Logger")) : class$org$jboss$logging$Logger);
        this.manager.declareBean("server", (Object)this.server, class$javax$management$MBeanServer == null ? (class$javax$management$MBeanServer = ScriptingListener.class$("javax.management.MBeanServer")) : class$javax$management$MBeanServer);
        this.manager.declareBean("manager", (Object)this.alm, class$org$jboss$monitor$alarm$AlarmManager == null ? (class$org$jboss$monitor$alarm$AlarmManager = ScriptingListener.class$("org.jboss.monitor.alarm.AlarmManager")) : class$org$jboss$monitor$alarm$AlarmManager);
        Notification testNotification = new Notification("jboss.script.test", this.serviceName, 0L);
        this.manager.declareBean("notification", (Object)testNotification, class$javax$management$Notification == null ? (class$javax$management$Notification = ScriptingListener.class$("javax.management.Notification")) : class$javax$management$Notification);
        this.manager.declareBean("handback", (Object)"", class$java$lang$Object == null ? (class$java$lang$Object = ScriptingListener.class$("java.lang.Object")) : class$java$lang$Object);
        this.manager.exec(this.language, "in-memory-script", 0, 0, (Object)this.script);
        this.processorThread = new Thread((Runnable)new ScriptProcessor(), "ScriptProcessor[" + this.serviceName + "]");
        this.processorThread.start();
        super.subscribe(this.dynamicSubscriptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopService() throws Exception {
        super.unsubscribe();
        this.log.debug((Object)("Stopping " + this.processorThread.getName()));
        this.stopRequested = true;
        List list = this.queue;
        synchronized (list) {
            this.queue.notify();
        }
        try {
            this.processorThread.join(5000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.queue.clear();
        this.manager.terminate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification2(Notification notification, Object handback) {
        this.notificationsReceived.increment();
        List list = this.queue;
        synchronized (list) {
            this.queue.add(new QueueEntry(notification, handback));
            this.queue.notify();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ScriptProcessor
    implements Runnable {
        private ScriptProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            String name = Thread.currentThread().getName();
            ScriptingListener.this.log.debug((Object)("Started thread: " + name));
            while (!ScriptingListener.this.stopRequested) {
                QueueEntry entry;
                List list = ScriptingListener.this.queue;
                synchronized (list) {
                    while (ScriptingListener.this.queue.isEmpty() && !ScriptingListener.this.stopRequested) {
                        try {
                            ScriptingListener.this.queue.wait();
                        }
                        catch (InterruptedException e) {}
                    }
                    if (ScriptingListener.this.stopRequested) {
                        break;
                    }
                    entry = (QueueEntry)ScriptingListener.this.queue.remove(0);
                }
                long start = System.currentTimeMillis();
                try {
                    ScriptingListener.this.manager.declareBean("notification", (Object)entry.notification, class$javax$management$Notification == null ? ScriptingListener.class$("javax.management.Notification") : class$javax$management$Notification);
                    ScriptingListener.this.manager.declareBean("handback", entry.handback == null ? "" : entry.handback, class$java$lang$Object == null ? ScriptingListener.class$("java.lang.Object") : class$java$lang$Object);
                    ScriptingListener.this.manager.exec(ScriptingListener.this.language, "in-memory-script", 0, 0, (Object)ScriptingListener.this.script);
                }
                catch (BSFException e) {
                    ScriptingListener.this.log.warn((Object)"Caught exception", (Throwable)e);
                }
                long stop = System.currentTimeMillis();
                ScriptingListener.this.totalProcessingTime.add(stop - start);
                ScriptingListener.this.notificationsProcessed.increment();
            }
            ScriptingListener.this.log.debug((Object)("Stopped thread: " + name));
        }
    }

    private static class QueueEntry {
        public Notification notification;
        public Object handback;

        public QueueEntry(Notification notification, Object handback) {
            this.notification = notification;
            this.handback = handback;
        }
    }
}

