/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.attachments;

import org.jboss.axis.AxisEngine;
import org.jboss.axis.MessageContext;
import org.jboss.axis.utils.ClassUtils;
import org.jboss.axis.utils.Messages;
import org.jboss.logging.Logger;

public final class AttachmentSupport {
    private static Logger log = Logger.getLogger((String)AttachmentSupport.class.getName());
    public static final String DEFAULT_ATTACHMNET_IMPL = "org.jboss.axis.attachments.AttachmentsImpl";
    private static String attachImplClassName = "org.jboss.axis.attachments.AttachmentsImpl";
    private static boolean checkForAttachmentSupport = true;
    private static boolean attachmentSupportEnabled = false;
    private static Class attachImplClass;

    public static synchronized boolean isAttachmentSupportEnabled() {
        return AttachmentSupport.isAttachmentSupportEnabled(null);
    }

    public static synchronized boolean isAttachmentSupportEnabled(MessageContext msgCtx) {
        if (checkForAttachmentSupport) {
            checkForAttachmentSupport = false;
            try {
                AxisEngine engine;
                if (msgCtx != null && (engine = msgCtx.getAxisEngine()) != null) {
                    attachImplClassName = (String)engine.getOption("attachments.implementation");
                }
                if (attachImplClassName == null) {
                    attachImplClassName = DEFAULT_ATTACHMNET_IMPL;
                }
                ClassUtils.forName("javax.activation.DataHandler");
                ClassUtils.forName("javax.mail.internet.MimeMultipart");
                attachImplClass = ClassUtils.forName(attachImplClassName);
                attachmentSupportEnabled = true;
            }
            catch (ClassNotFoundException ex) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            log.debug((Object)(Messages.getMessage("attachEnabled") + "  " + attachmentSupportEnabled));
        }
        return attachmentSupportEnabled;
    }

    public static Class getImplementationClass() {
        return attachImplClass;
    }
}

