/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.message;

import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.jboss.axis.AxisFault;
import org.jboss.axis.Constants;
import org.jboss.axis.encoding.DeserializationContext;
import org.jboss.axis.message.SOAPEnvelopeAxisImpl;
import org.jboss.axis.message.SOAPHandler;
import org.jboss.axis.message.SOAPHeaderAxisImpl;
import org.jboss.axis.message.SOAPHeaderElementAxisImpl;
import org.jboss.axis.soap.SOAPConstants;
import org.jboss.axis.utils.Messages;
import org.jboss.logging.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class HeaderBuilder
extends SOAPHandler {
    private static Logger log = Logger.getLogger((String)HeaderBuilder.class.getName());
    private SOAPHeaderElementAxisImpl headerElement;
    private SOAPEnvelopeAxisImpl envelope;

    HeaderBuilder(SOAPEnvelopeAxisImpl envelope) {
        this.envelope = envelope;
    }

    public void startElement(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        SOAPConstants soapConstants = Constants.DEFAULT_SOAP_VERSION;
        if (context.getMessageContext() != null) {
            soapConstants = context.getMessageContext().getSOAPConstants();
        }
        if (soapConstants == SOAPConstants.SOAP12_CONSTANTS && attributes.getValue("http://www.w3.org/2002/12/soap-envelope", "encodingStyle") != null) {
            AxisFault fault = new AxisFault(Constants.FAULT_SOAP12_SENDER, null, Messages.getMessage("noEncodingStyleAttrAppear", "Header"), null, null, null);
            throw new SAXException(fault);
        }
        if (!context.isDoneParsing()) {
            if (this.myElement == null) {
                try {
                    this.myElement = new SOAPHeaderAxisImpl(namespace, localName, prefix, attributes, context, this.envelope.getSOAPConstants());
                }
                catch (AxisFault axisFault) {
                    throw new SAXException(axisFault);
                }
                this.envelope.setHeader((SOAPHeaderAxisImpl)this.myElement);
            }
            context.pushNewElement(this.myElement);
        }
    }

    public SOAPHandler onStartChild(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        try {
            this.headerElement = new SOAPHeaderElementAxisImpl(namespace, localName, prefix, attributes, context);
            this.headerElement.setParentElement((SOAPElement)this.envelope.getHeader());
        }
        catch (AxisFault axisFault) {
            throw new SAXException(axisFault);
        }
        catch (SOAPException e) {
            throw new SAXException((Exception)((Object)e));
        }
        SOAPHandler handler = new SOAPHandler();
        handler.myElement = this.headerElement;
        return handler;
    }

    public void onEndChild(String namespace, String localName, DeserializationContext context) {
    }
}

