/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.message;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.jboss.axis.description.ParameterDesc;
import org.jboss.axis.encoding.SerializationContext;
import org.jboss.axis.message.RPCElement;
import org.jboss.axis.utils.JavaUtils;
import org.jboss.axis.utils.Messages;
import org.jboss.logging.Logger;

public class RPCParam {
    private static Logger log = Logger.getLogger((String)RPCParam.class.getName());
    RPCElement myCall;
    private transient QName qname;
    private Object value;
    private int countSetCalls;
    private ParameterDesc paramDesc;
    private Boolean wantXSIType = null;
    private static Method valueSetMethod;

    public RPCParam(String name, Object value) {
        this.qname = new QName("", name);
        this.value = value;
    }

    public RPCParam(QName qname, Object value) {
        this.qname = qname;
        this.value = value;
    }

    public RPCParam(String namespace, String name, Object value) {
        this.qname = new QName(namespace, name);
        this.value = value;
    }

    public void setRPCCall(RPCElement call) {
        this.myCall = call;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object newValue) {
        this.value = newValue;
    }

    public void set(Object newValue) {
        ++this.countSetCalls;
        if (this.countSetCalls == 1) {
            this.value = newValue;
            return;
        }
        if (this.countSetCalls == 2) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(this.value);
            this.value = list;
        }
        ((ArrayList)this.value).add(newValue);
    }

    public String getName() {
        return this.qname.getLocalPart();
    }

    public QName getQName() {
        return this.qname;
    }

    public static Method getValueSetMethod() {
        return valueSetMethod;
    }

    public ParameterDesc getParamDesc() {
        return this.paramDesc;
    }

    public void setParamDesc(ParameterDesc paramDesc) {
        this.paramDesc = paramDesc;
    }

    public void setXSITypeGeneration(Boolean value) {
        this.wantXSIType = value;
    }

    public Boolean getXSITypeGeneration() {
        return this.wantXSIType;
    }

    public void serialize(SerializationContext context) throws IOException {
        Object serValue = this.value;
        QName xmlType = null;
        if (this.paramDesc != null) {
            Class<?> javaType = null;
            xmlType = this.paramDesc.getTypeQName();
            if (xmlType != null) {
                javaType = context.getTypeMapping().getClassForQName(xmlType);
                if (serValue != null && javaType != null && !javaType.isAssignableFrom(serValue.getClass()) && JavaUtils.isConvertable(serValue, javaType)) {
                    serValue = JavaUtils.convert(serValue, javaType);
                }
            }
            if (javaType == null) {
                javaType = this.paramDesc.getJavaType();
            }
            if (javaType == null && this.value != null) {
                javaType = this.value.getClass();
            }
            if (javaType != null && !javaType.equals(this.paramDesc.getJavaType()) && !javaType.equals(JavaUtils.getHolderValueType(this.paramDesc.getJavaType()))) {
                this.wantXSIType = Boolean.TRUE;
            }
        }
        context.serialize(this.qname, null, serValue, xmlType, true, this.wantXSIType);
    }

    static {
        Class cls = RPCParam.class;
        try {
            valueSetMethod = cls.getMethod("set", Object.class);
        }
        catch (NoSuchMethodException e) {
            log.error((Object)Messages.getMessage("noValue00", "" + e));
            System.exit(-1);
        }
    }
}

