/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.description;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.holders.Holder;
import org.jboss.axis.utils.Messages;
import org.jboss.axis.wsdl.symbolTable.TypeEntry;

public class ParameterDesc {
    public static final byte IN = 1;
    public static final byte OUT = 2;
    public static final byte INOUT = 3;
    private transient QName name;
    public TypeEntry typeEntry;
    private byte mode = 1;
    private QName typeQName;
    private Class javaType = null;
    private int order = -1;
    private boolean isReturn = false;
    private String mimeType = null;
    private boolean inHeader = false;
    private boolean outHeader = false;
    private List wrappedVariables;

    public ParameterDesc() {
    }

    public ParameterDesc(ParameterDesc copy) {
        this.name = copy.name;
        this.typeEntry = copy.typeEntry;
        this.mode = copy.mode;
        this.typeQName = copy.typeQName;
        this.javaType = copy.javaType;
        this.order = copy.order;
        this.isReturn = copy.isReturn;
        this.mimeType = copy.mimeType;
        this.inHeader = copy.inHeader;
        this.outHeader = copy.outHeader;
        if (copy.wrappedVariables != null) {
            this.wrappedVariables = new ArrayList(copy.wrappedVariables);
        }
    }

    public ParameterDesc(QName name, byte mode, QName typeQName, Class javaType, boolean inHeader, boolean outHeader) {
        this.name = name;
        this.mode = mode;
        this.typeQName = typeQName;
        this.javaType = javaType;
        this.inHeader = inHeader;
        this.outHeader = outHeader;
    }

    public static byte modeFromString(String modeStr) {
        int ret = 1;
        if (modeStr == null) {
            return 1;
        }
        if (modeStr.equalsIgnoreCase("out")) {
            ret = 2;
        } else if (modeStr.equalsIgnoreCase("inout")) {
            ret = 3;
        }
        return (byte)ret;
    }

    public static String getModeAsString(byte mode) {
        if (mode == 3) {
            return "inout";
        }
        if (mode == 2) {
            return "out";
        }
        if (mode == 1) {
            return "in";
        }
        throw new IllegalArgumentException(Messages.getMessage("badParameterMode", Byte.toString(mode)));
    }

    public QName getQName() {
        return this.name;
    }

    public String getName() {
        if (this.name == null) {
            return null;
        }
        return this.name.getLocalPart();
    }

    public void setName(String name) {
        this.name = new QName("", name);
    }

    public void setQName(QName name) {
        this.name = name;
    }

    public QName getTypeQName() {
        return this.typeQName;
    }

    public void setTypeQName(QName typeQName) {
        this.typeQName = typeQName;
    }

    public Class getJavaType() {
        return this.javaType;
    }

    public void setJavaType(Class javaType) {
        if (javaType != null && !this.isReturn && this.mode != 1 && !Holder.class.isAssignableFrom(javaType)) {
            throw new IllegalArgumentException(Messages.getMessage("setJavaTypeErr00", javaType.getName(), ParameterDesc.getModeAsString(this.mode)));
        }
        this.javaType = javaType;
    }

    public byte getMode() {
        return this.mode;
    }

    public void setMode(byte mode) {
        this.mode = mode;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setInHeader(boolean value) {
        this.inHeader = value;
    }

    public boolean isInHeader() {
        return this.inHeader;
    }

    public void setOutHeader(boolean value) {
        this.outHeader = value;
    }

    public boolean isOutHeader() {
        return this.outHeader;
    }

    public boolean getIsReturn() {
        return this.isReturn;
    }

    public void setIsReturn(boolean value) {
        this.isReturn = value;
    }

    public List getWrappedVariables() {
        return this.wrappedVariables;
    }

    public void setWrappedVariables(List wrappedVariables) {
        this.wrappedVariables = wrappedVariables;
    }

    public String toString() {
        String text = "\nParameterDesc\n";
        text = text + "  name:       " + this.name + "\n";
        text = text + "  typeEntry:  " + this.typeEntry + "\n";
        text = text + "  mode:       " + (this.mode == 1 ? "IN" : (this.mode == 3 ? "INOUT" : "OUT:  position:" + this.order)) + "\n";
        text = text + "  isReturn:   " + this.isReturn + "\n";
        text = text + "  typeQName:  " + this.typeQName + "\n";
        text = text + "  javaType:   " + this.javaType + "\n";
        text = text + "  inHeader:   " + this.inHeader + "\n";
        text = text + "  outHeader:  " + this.outHeader + "\n";
        if (this.wrappedVariables != null) {
            text = text + "  wrappedVariables=" + this.wrappedVariables + "\n";
        }
        return text;
    }
}

