/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.transport.jms;

import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import javax.jms.Destination;
import org.jboss.axis.AxisFault;
import org.jboss.axis.Message;
import org.jboss.axis.MessageContext;
import org.jboss.axis.handlers.BasicHandler;
import org.jboss.axis.transport.jms.JMSConnector;
import org.jboss.axis.transport.jms.JMSEndpoint;

public class JMSSender
extends BasicHandler {
    public void invoke(MessageContext msgContext) throws AxisFault {
        try {
            Object destination = msgContext.getProperty("transport.jms.Destination");
            if (destination == null) {
                throw new AxisFault("noDestination");
            }
            JMSConnector connector = (JMSConnector)msgContext.getProperty("transport.jms.Connector");
            JMSEndpoint endpoint = null;
            endpoint = destination instanceof String ? connector.createEndpoint((String)destination) : connector.createEndpoint((Destination)destination);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            msgContext.getRequestMessage().writeTo(out);
            HashMap props = this.createSendProperties(msgContext);
            boolean waitForResponse = true;
            if (msgContext.containsProperty("transport.jms.WaitForResponse")) {
                waitForResponse = (Boolean)msgContext.getProperty("transport.jms.WaitForResponse");
            }
            if (waitForResponse) {
                long timeout = msgContext.getTimeout();
                byte[] response = endpoint.call(out.toByteArray(), timeout, props);
                Message msg = new Message(response);
                msgContext.setResponseMessage(msg);
            } else {
                endpoint.send(out.toByteArray(), props);
            }
        }
        catch (Exception e) {
            throw new AxisFault("failedSend", e);
        }
    }

    private HashMap createSendProperties(MessageContext context) {
        if (!(context.containsProperty("transport.jms.Priority") || context.containsProperty("transport.jms.DeliveryMode") || context.containsProperty("transport.jms.TimeToLive"))) {
            return null;
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (context.containsProperty("transport.jms.Priority")) {
            props.put("transport.jms.Priority", context.getProperty("transport.jms.Priority"));
        }
        if (context.containsProperty("transport.jms.DeliveryMode")) {
            props.put("transport.jms.DeliveryMode", context.getProperty("transport.jms.DeliveryMode"));
        }
        if (context.containsProperty("transport.jms.TimeToLive")) {
            props.put("transport.jms.TimeToLive", context.getProperty("transport.jms.TimeToLive"));
        }
        return props;
    }
}

