/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice.server;

import java.io.IOException;
import java.io.PrintWriter;
import javax.management.MBeanServer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.webservice.AxisServiceMBean;
import org.jboss.webservice.PortComponentInfo;

public class PortComponentLinkServlet
extends HttpServlet {
    private static final Logger log = Logger.getLogger((Class)PortComponentLinkServlet.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String serviceID = req.getParameter("serviceID");
        if (serviceID == null) {
            throw new IllegalArgumentException("Cannot obtain request parameter 'serviceID'");
        }
        PortComponentInfo pcInfo = null;
        try {
            MBeanServer server = MBeanServerLocator.locateJBoss();
            pcInfo = (PortComponentInfo)server.invoke(AxisServiceMBean.OBJECT_NAME, "getPortComponentInfo", new Object[]{serviceID}, new String[]{String.class.getName()});
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        if (pcInfo == null) {
            throw new IllegalStateException("Cannot resolve port-component-link: " + serviceID);
        }
        res.setContentType("text/plain");
        PrintWriter out = res.getWriter();
        String serviceEndpointURL = pcInfo.getServiceEndpointURL();
        out.println(serviceEndpointURL);
        log.debug((Object)("Resolved " + serviceID + " to: " + serviceEndpointURL));
        out.close();
    }
}

