/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.net.axis.server;

import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import org.jboss.axis.AxisFault;
import org.jboss.axis.MessageContext;
import org.jboss.axis.handlers.BasicHandler;
import org.jboss.security.AnybodyPrincipal;
import org.jboss.security.NobodyPrincipal;
import org.jboss.security.RealmMapping;
import org.jboss.security.SimplePrincipal;

public class JBossAuthorizationHandler
extends BasicHandler {
    protected RealmMapping realmMapping;
    protected final Set rolesAllowed = new HashSet();
    protected final Set rolesDenied = new HashSet();
    protected boolean isInitialised;

    protected void initialise() throws AxisFault {
        String allowedRoles;
        this.isInitialised = true;
        this.realmMapping = null;
        String securityDomain = (String)this.getOption("securityDomain");
        if (securityDomain != null) {
            try {
                this.realmMapping = (RealmMapping)new InitialContext().lookup(securityDomain);
            }
            catch (NamingException e) {
                throw new AxisFault("Could not lookup security domain " + securityDomain, (Throwable)e);
            }
        }
        if ((allowedRoles = (String)this.getOption("allowedRoles")) == null) {
            allowedRoles = "*";
        }
        StringTokenizer tokenizer = new StringTokenizer(allowedRoles, ",");
        while (tokenizer.hasMoreTokens()) {
            this.rolesAllowed.add(this.getPrincipal(tokenizer.nextToken()));
        }
        String deniedRoles = (String)this.getOption("deniedRoles");
        if (deniedRoles != null) {
            tokenizer = new StringTokenizer(deniedRoles, ",");
            while (tokenizer.hasMoreTokens()) {
                this.rolesDenied.add(this.getPrincipal(tokenizer.nextToken()));
            }
        }
    }

    protected Principal getPrincipal(String userName) {
        if (userName.equals("*")) {
            return AnybodyPrincipal.ANYBODY_PRINCIPAL;
        }
        return new SimplePrincipal(userName);
    }

    protected Collection getAssociatedPrincipals(MessageContext msgContext) {
        Subject activeSubject = (Subject)msgContext.getProperty("authenticatedUser");
        if (activeSubject == null) {
            return Collections.singleton(NobodyPrincipal.NOBODY_PRINCIPAL);
        }
        return activeSubject.getPrincipals();
    }

    protected boolean doesUserHaveRole(Principal principal, Set roles) {
        return this.realmMapping.doesUserHaveRole(principal, roles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(MessageContext msgContext) throws AxisFault {
        if (!this.isInitialised) {
            JBossAuthorizationHandler jBossAuthorizationHandler = this;
            synchronized (jBossAuthorizationHandler) {
                if (!this.isInitialised) {
                    this.initialise();
                }
            }
        }
        if (this.realmMapping == null) {
            throw new AxisFault("No security domain associated.");
        }
        Iterator allPrincipals = this.getAssociatedPrincipals(msgContext).iterator();
        boolean accessAllowed = false;
        while (allPrincipals.hasNext()) {
            Principal nextPrincipal = (Principal)allPrincipals.next();
            if (this.doesUserHaveRole(nextPrincipal, this.rolesDenied)) {
                accessAllowed = false;
                break;
            }
            if (accessAllowed || !this.doesUserHaveRole(nextPrincipal, this.rolesAllowed)) continue;
            accessAllowed = true;
        }
        if (!accessAllowed) {
            throw new AxisFault("Access denied.");
        }
    }
}

