/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.maintenance.factory;

import com.clustercontrol.maintenance.ejb.entity.MaintenanceInfoLocal;
import com.clustercontrol.maintenance.ejb.entity.MaintenanceInfoUtil;
import com.clustercontrol.maintenance.util.SendEvent;
import com.clustercontrol.monitor.message.LogOutputNotifyInfo;
import com.clustercontrol.util.Messages;
import java.util.Date;
import javax.ejb.FinderException;
import javax.jms.JMSException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Notice {
    protected static Log m_log = LogFactory.getLog(Notice.class);

    public void notify(String maintenanceId, Integer type, int result) throws FinderException, NamingException {
        m_log.debug((Object)("notify() : maintenanceId=" + maintenanceId + ", type=" + type));
        MaintenanceInfoLocal info = MaintenanceInfoUtil.getLocalHome().findByPrimaryKey(maintenanceId);
        if (info.getNotify_id() != null && info.getNotify_id().length() > 0) {
            LogOutputNotifyInfo notice = new LogOutputNotifyInfo();
            notice.setPluginId("MAINTENANCE");
            notice.setApplication(info.getApplication());
            notice.setMonitorId(maintenanceId);
            notice.setFacilityId("INTERNAL");
            notice.setScopeText("Hinemos_Internal");
            if (type == 3) {
                notice.setMessageId("001");
                Object[] args1 = new String[]{maintenanceId};
                notice.setMessage(Messages.getString((String)"message.maintenance.12", (Object[])args1));
            } else if (type == 0) {
                notice.setMessageId("002");
                Object[] args1 = new String[]{maintenanceId};
                notice.setMessage(Messages.getString((String)"message.maintenance.13", (Object[])args1));
            }
            notice.setMessageOrg(info.getType_id() + " : " + result + " records");
            notice.setPriority(type.intValue());
            notice.setGenerationDate(new Date());
            notice.setNotifyId(info.getNotify_id());
            try {
                new SendEvent().put(notice);
            }
            catch (JMSException e) {
            }
            catch (NamingException e) {
                // empty catch block
            }
        }
    }
}

