/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performanceMGR.bean;

import com.clustercontrol.performanceMGR.bean.CollectorItemPK;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;

public abstract class Facility
implements Serializable,
Comparable {
    public static final int COMPOSITE = 0;
    public static final int SCOPE = 1;
    public static final int NODE = 2;
    protected String m_facilityID;
    private String m_facilityName;
    private int m_type;
    private HashSet m_parents = null;
    private HashMap m_calcValues;
    private HashMap m_calcTempValues;

    public Facility(String facilityID, String faclityName, int type) {
        this.m_facilityID = facilityID;
        this.m_facilityName = faclityName;
        this.m_type = type;
        this.m_parents = new HashSet();
        this.m_calcValues = new HashMap();
        this.m_calcTempValues = new HashMap();
    }

    public Facility(String facilityID, String faclityName, String type) {
        this.m_facilityID = facilityID;
        this.m_facilityName = faclityName;
        this.setTypeString(type);
        this.m_parents = new HashSet();
    }

    public void addParents(Facility paretnt) {
        this.getParents().add(paretnt);
    }

    protected int getNodeCount() {
        return 0;
    }

    public abstract double calcValue(String var1, int var2, String var3);

    public String getFacilityID() {
        return this.m_facilityID;
    }

    public String getFacilityName() {
        return this.m_facilityName;
    }

    public HashSet getParents() {
        return this.m_parents;
    }

    public int getType() {
        return this.m_type;
    }

    public String getTypeString() {
        String returnValue = null;
        if (this.m_type == 1) {
            returnValue = "scope";
        } else if (this.m_type == 2) {
            returnValue = "node";
        }
        return returnValue;
    }

    public void setFacilityID(String facilityid) {
        this.m_facilityID = facilityid;
    }

    public void setTypeString(String type) {
        if (type.equals("scope")) {
            this.m_type = 1;
        } else if (type.equals("node")) {
            this.m_type = 2;
        }
    }

    public int compareTo(Object o) {
        return this.m_facilityID.compareTo(((Facility)o).getFacilityID());
    }

    public double getCalcValueBuffer(CollectorItemPK item) {
        Double value = (Double)this.m_calcTempValues.get(item);
        if (value == null) {
            return Double.NaN;
        }
        return value;
    }

    public void setCalcValueBuffer(CollectorItemPK item, double data) {
        this.m_calcTempValues.put(item, new Double(data));
    }
}

