/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.instrument;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.Arrays;
import net.sf.cglib.core.ClassGenerator;
import net.sf.cglib.core.ClassNameReader;
import net.sf.cglib.core.DebuggingClassWriter;
import net.sf.cglib.transform.ClassReaderGenerator;
import net.sf.cglib.transform.ClassTransformer;
import net.sf.cglib.transform.TransformingClassGenerator;
import net.sf.cglib.transform.impl.InterceptFieldEnabled;
import net.sf.cglib.transform.impl.InterceptFieldFilter;
import net.sf.cglib.transform.impl.InterceptFieldTransformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.attrs.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptFieldClassFileTransformer
implements ClassFileTransformer {
    Log log = LogFactory.getLog((String)InterceptFieldClassFileTransformer.class.getName());

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        ClassReader reader;
        try {
            reader = new ClassReader((InputStream)new ByteArrayInputStream(classfileBuffer));
        }
        catch (IOException e) {
            this.log.error((Object)"Unable to read class", (Throwable)e);
            throw new IllegalClassFormatException("Unable to read class: " + e.getMessage());
        }
        String[] name = ClassNameReader.getClassInfo((ClassReader)reader);
        DebuggingClassWriter w = new DebuggingClassWriter(true);
        ClassTransformer t = this.getClassTransformer(name);
        if (t != null) {
            byte[] result;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Enhancing " + className));
            }
            try {
                reader = new ClassReader((InputStream)new ByteArrayInputStream(classfileBuffer));
                new TransformingClassGenerator((ClassGenerator)new ClassReaderGenerator(reader, this.attributes(), this.skipDebug()), t).generateClass((ClassVisitor)w);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                out.write(w.toByteArray());
                result = out.toByteArray();
                out.close();
            }
            catch (Exception e) {
                this.log.error((Object)"Unable to transform class", (Throwable)e);
                throw new IllegalClassFormatException("Unable to transform class: " + e.getMessage());
            }
            return result;
        }
        return classfileBuffer;
    }

    private Attribute[] attributes() {
        return Attributes.getDefaultAttributes();
    }

    private boolean skipDebug() {
        return false;
    }

    private ClassTransformer getClassTransformer(String[] classInfo) {
        if (Arrays.asList(classInfo).contains(InterceptFieldEnabled.class.getName())) {
            return null;
        }
        return new InterceptFieldTransformer(new InterceptFieldFilter(){

            public boolean acceptRead(Type owner, String name) {
                return true;
            }

            public boolean acceptWrite(Type owner, String name) {
                return true;
            }
        });
    }
}

