/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.message;

import org.jboss.axis.AxisFault;
import org.jboss.axis.Constants;
import org.jboss.axis.encoding.DeserializationContext;
import org.jboss.axis.encoding.TypeMappingRegistry;
import org.jboss.axis.message.SOAPElementAxisImpl;
import org.jboss.axis.soap.SOAPConstants;
import org.jboss.axis.utils.Messages;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SOAPHandler
extends DefaultHandler {
    public SOAPElementAxisImpl myElement = null;
    private SOAPElementAxisImpl[] myElements;
    private int myIndex = 0;

    public SOAPHandler() {
    }

    public SOAPHandler(SOAPElementAxisImpl[] elements, int index) {
        this.myElements = elements;
        this.myIndex = index;
    }

    public void startElement(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        TypeMappingRegistry tmr;
        String encodingStyle;
        SOAPConstants soapConstants = Constants.DEFAULT_SOAP_VERSION;
        if (context.getMessageContext() != null) {
            soapConstants = context.getMessageContext().getSOAPConstants();
        }
        if (!(soapConstants != SOAPConstants.SOAP12_CONSTANTS || (encodingStyle = attributes.getValue("http://www.w3.org/2002/12/soap-envelope", "encodingStyle")) == null || encodingStyle.equals("") || encodingStyle.equals("http://www.w3.org/2002/12/soap-envelope/encoding/none") || Constants.isSOAP_ENC(encodingStyle) || (tmr = context.getTypeMappingRegistry()).getTypeMapping(encodingStyle) != tmr.getDefaultTypeMapping())) {
            AxisFault fault = new AxisFault(Constants.FAULT_SOAP12_DATAENCODINGUNKNOWN, null, Messages.getMessage("invalidEncodingStyle"), null, null, null);
            throw new SAXException(fault);
        }
        if (!context.isDoneParsing() && !context.isProcessingRef()) {
            if (this.myElement == null) {
                try {
                    this.myElement = this.makeNewElement(namespace, localName, prefix, attributes, context);
                }
                catch (AxisFault axisFault) {
                    throw new SAXException(axisFault);
                }
            }
            context.pushNewElement(this.myElement);
        }
    }

    public SOAPElementAxisImpl makeNewElement(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws AxisFault {
        return new SOAPElementAxisImpl(namespace, localName, prefix, attributes, context);
    }

    public void endElement(String namespace, String localName, DeserializationContext context) throws SAXException {
        if (this.myElement != null) {
            if (this.myElements != null) {
                this.myElements[this.myIndex] = this.myElement;
            }
            this.myElement.setEndIndex(context.getCurrentRecordPos());
        }
    }

    public SOAPHandler onStartChild(String namespace, String localName, String prefix, Attributes attributes, DeserializationContext context) throws SAXException {
        SOAPHandler handler = new SOAPHandler();
        return handler;
    }

    public void onEndChild(String namespace, String localName, DeserializationContext context) throws SAXException {
    }
}

