/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Log4JLogger;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.jacorb.config.LoggerFactory;
import org.jboss.logging.Log4jLoggerPlugin;
import org.jboss.logging.LoggerPlugin;

public class Log4jLoggerFactory
implements LoggerFactory {
    private static final String name = "log4j";
    private int defaultPriority = 0;
    private final Map namedLoggers = new HashMap();
    private Configuration configuration = null;

    private static Logger getLog4jLogger(String name) {
        org.jboss.logging.Logger l = org.jboss.logging.Logger.getLogger((String)name);
        LoggerPlugin lp = l.getLoggerPlugin();
        if (lp instanceof Log4jLoggerPlugin) {
            return ((Log4jLoggerPlugin)lp).getLogger();
        }
        return null;
    }

    private static Level intToLevel(int priority) {
        switch (priority) {
            case 4: {
                return Level.DEBUG;
            }
            case 3: {
                return Level.INFO;
            }
            case 2: {
                return Level.WARN;
            }
            case 1: {
                return Level.ERROR;
            }
        }
        return Level.FATAL;
    }

    private int getPriorityForNamedLogger(String name) {
        String prefix = name;
        while (!prefix.equals("")) {
            Object priorityString = null;
            try {
                int priorityForLogger = this.configuration.getAttributeAsInteger(prefix + ".log.verbosity");
                if (priorityForLogger > 4) {
                    priorityForLogger = 4;
                } else if (priorityForLogger < 0) {
                    priorityForLogger = 0;
                }
                return priorityForLogger;
            }
            catch (ConfigurationException ce) {
                if (prefix.lastIndexOf(".") >= 0) {
                    prefix = prefix.substring(0, prefix.lastIndexOf("."));
                    continue;
                }
                prefix = "";
            }
        }
        return this.defaultPriority;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = configuration;
        this.defaultPriority = configuration.getAttributeAsInteger("jacorb.log.default.verbosity", 0);
        switch (this.defaultPriority) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new ConfigurationException("'" + this.defaultPriority + "' is an illegal" + " value for the property jacorb.log.default.verbosity. Valid values are [0-4]");
            }
        }
    }

    public final String getLoggingBackendName() {
        return name;
    }

    public org.apache.avalon.framework.logger.Logger getNamedLogger(String name) {
        Object o = this.namedLoggers.get(name);
        if (o != null) {
            return (org.apache.avalon.framework.logger.Logger)o;
        }
        Logger log4jLogger = Log4jLoggerFactory.getLog4jLogger(name);
        int priority = this.getPriorityForNamedLogger(name);
        log4jLogger.setLevel(Log4jLoggerFactory.intToLevel(priority));
        Log4JLogger logger = new Log4JLogger(log4jLogger);
        this.namedLoggers.put(name, logger);
        return logger;
    }

    public org.apache.avalon.framework.logger.Logger getNamedRootLogger(String name) {
        return this.getNamedLogger(name);
    }

    public org.apache.avalon.framework.logger.Logger getNamedLogger(String name, String logFileName, long maxLogSize) throws IOException {
        return null;
    }

    public void setDefaultLogFile(String fileName, long maxLogSize) throws IOException {
    }
}

