/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.security.acl.Group;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.sql.DataSource;
import javax.transaction.Transaction;
import org.jboss.security.auth.spi.UsernamePasswordLoginModule;
import org.jboss.security.auth.spi.Util;
import org.jboss.tm.TransactionDemarcationSupport;

public class DatabaseServerLoginModule
extends UsernamePasswordLoginModule {
    protected String dsJndiName;
    protected String principalsQuery = "select Password from Principals where PrincipalID=?";
    protected String rolesQuery = "select Role, RoleGroup from Roles where PrincipalID=?";
    protected boolean suspendResume = true;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        Object tmp;
        super.initialize(subject, callbackHandler, sharedState, options);
        this.dsJndiName = (String)options.get("dsJndiName");
        if (this.dsJndiName == null) {
            this.dsJndiName = "java:/DefaultDS";
        }
        if ((tmp = options.get("principalsQuery")) != null) {
            this.principalsQuery = tmp.toString();
        }
        if ((tmp = options.get("rolesQuery")) != null) {
            this.rolesQuery = tmp.toString();
        }
        if ((tmp = options.get("suspendResume")) != null) {
            this.suspendResume = Boolean.valueOf(tmp.toString());
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("DatabaseServerLoginModule, dsJndiName=" + this.dsJndiName));
            this.log.trace((Object)("principalsQuery=" + this.principalsQuery));
            this.log.trace((Object)("rolesQuery=" + this.rolesQuery));
            this.log.trace((Object)("suspendResume=" + this.suspendResume));
        }
    }

    /*
     * Loose catch block
     */
    protected String getUsersPassword() throws LoginException {
        String password;
        block26: {
            SQLException e22;
            Transaction tx;
            ResultSet rs;
            Statement ps;
            Connection conn;
            block23: {
                String username = this.getUsername();
                password = null;
                conn = null;
                ps = null;
                rs = null;
                tx = null;
                if (this.suspendResume) {
                    tx = TransactionDemarcationSupport.suspendAnyTransaction();
                }
                InitialContext ctx = new InitialContext();
                DataSource ds = (DataSource)ctx.lookup(this.dsJndiName);
                conn = ds.getConnection();
                ps = conn.prepareStatement(this.principalsQuery);
                ps.setString(1, username);
                rs = ps.executeQuery();
                if (!rs.next()) {
                    throw new FailedLoginException("No matching username found in Principals");
                }
                password = rs.getString(1);
                password = this.convertRawPassword(password);
                Object var10_11 = null;
                if (rs == null) break block23;
                try {
                    rs.close();
                }
                catch (SQLException e22) {
                    // empty catch block
                }
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e22) {
                    // empty catch block
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException ex) {
                    // empty catch block
                }
            }
            if (this.suspendResume) {
                TransactionDemarcationSupport.resumeAnyTransaction((Transaction)tx);
            }
            break block26;
            {
                catch (NamingException ex) {
                    throw new LoginException(ex.toString(true));
                }
                catch (SQLException ex) {
                    this.log.error((Object)"Query failed", (Throwable)ex);
                    throw new LoginException(ex.toString());
                }
            }
            catch (Throwable throwable) {
                SQLException e22;
                Object var10_12 = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e22) {
                        // empty catch block
                    }
                }
                if (ps != null) {
                    try {
                        ps.close();
                    }
                    catch (SQLException e22) {
                        // empty catch block
                    }
                }
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException ex) {
                        // empty catch block
                    }
                }
                if (this.suspendResume) {
                    TransactionDemarcationSupport.resumeAnyTransaction((Transaction)tx);
                }
                throw throwable;
            }
        }
        return password;
    }

    protected Group[] getRoleSets() throws LoginException {
        String username = this.getUsername();
        Group[] roleSets = Util.getRoleSets(username, this.dsJndiName, this.rolesQuery, this, this.suspendResume);
        return roleSets;
    }

    protected String convertRawPassword(String rawPassword) {
        return rawPassword;
    }
}

