/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.advice;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import org.jboss.aop.Advisor;
import org.jboss.aop.advice.AspectFactory;
import org.jboss.aop.advice.Scope;

public class AspectDefinition {
    protected String name;
    protected Scope scope = Scope.PER_VM;
    protected ArrayList advisors = new ArrayList();
    protected AspectFactory factory;
    protected boolean deployed = true;

    public AspectDefinition(String name, Scope scope, AspectFactory factory) {
        this.name = name;
        this.scope = scope;
        this.factory = factory;
        if (this.scope == null) {
            this.scope = Scope.PER_VM;
        }
        if (this.name == null) {
            this.name = this.factory.getName();
        }
    }

    public AspectDefinition() {
    }

    public void undeploy() {
        this.deployed = false;
    }

    public boolean isDeployed() {
        return this.deployed;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public void setFactory(AspectFactory factory) {
        this.factory = factory;
    }

    public AspectFactory getFactory() {
        return this.factory;
    }

    public String getName() {
        return this.name;
    }

    public Scope getScope() {
        return this.scope;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AspectDefinition)) {
            return false;
        }
        return this.name.equals(((AspectDefinition)obj).name);
    }

    public void addAdvisor(Advisor advisor) {
        this.advisors.add(new WeakReference<Advisor>(advisor));
        if (this.scope == Scope.PER_CLASS) {
            advisor.addPerClassAspect(this);
        } else if (this.scope == Scope.PER_INSTANCE) {
            advisor.addPerInstanceAspect(this);
        }
    }

    public void clearAdvisors() {
        Iterator it = this.advisors.iterator();
        while (it.hasNext()) {
            WeakReference ref = (WeakReference)it.next();
            Advisor advisor = (Advisor)ref.get();
            if (advisor == null) continue;
            if (this.scope == Scope.PER_CLASS) {
                advisor.removePerClassAspect(this);
                continue;
            }
            if (this.scope != Scope.PER_INSTANCE) continue;
            advisor.removePerInstanceAspect(this);
        }
        this.advisors.clear();
    }
}

