/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.statistics;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class InvocationStatistics
implements Serializable {
    private static final long serialVersionUID = 9153807780893455734L;
    private Map ctxStats;
    public volatile int concurrentCalls = 0;
    public volatile int maxConcurrentCalls = 0;
    public long lastResetTime = System.currentTimeMillis();

    public InvocationStatistics() {
        this.ctxStats = Collections.synchronizedMap(new HashMap());
    }

    public void updateStats(String ctx, long elapsed) {
        TimeStatistic stat = (TimeStatistic)this.ctxStats.get(ctx);
        if (stat == null) {
            stat = new TimeStatistic();
            this.ctxStats.put(ctx, stat);
        }
        ++stat.count;
        stat.totalTime += elapsed;
        if (stat.minTime > elapsed) {
            stat.minTime = elapsed;
        }
        if (stat.maxTime < elapsed) {
            stat.maxTime = elapsed;
        }
    }

    public void callIn() {
        ++this.concurrentCalls;
        if (this.concurrentCalls > this.maxConcurrentCalls) {
            this.maxConcurrentCalls = this.concurrentCalls;
        }
    }

    public void callOut() {
        --this.concurrentCalls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetStats() {
        Map map = this.ctxStats;
        synchronized (map) {
            Iterator iter = this.ctxStats.values().iterator();
            while (iter.hasNext()) {
                TimeStatistic stat = (TimeStatistic)iter.next();
                stat.reset();
            }
        }
        this.maxConcurrentCalls = 0;
        this.lastResetTime = System.currentTimeMillis();
    }

    public Map getStats() {
        return this.ctxStats;
    }

    public String toString() {
        StringBuffer tmp = new StringBuffer("(concurrentCalls: ");
        tmp.append(this.concurrentCalls);
        tmp.append(", maxConcurrentCalls: ");
        tmp.append(this.maxConcurrentCalls);
        HashMap copy = new HashMap(this.ctxStats);
        Iterator iter = copy.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            TimeStatistic stat = (TimeStatistic)entry.getValue();
            tmp.append("[webCtx: ");
            tmp.append(entry.getKey());
            tmp.append(", count=");
            tmp.append(stat.count);
            tmp.append(", minTime=");
            tmp.append(stat.minTime);
            tmp.append(", maxTime=");
            tmp.append(stat.maxTime);
            tmp.append(", totalTime=");
            tmp.append(stat.totalTime);
            tmp.append("];");
        }
        tmp.append(")");
        return tmp.toString();
    }

    public String toXML() {
        StringBuffer tmp = new StringBuffer("<InvocationStatistics concurrentCalls='");
        tmp.append(this.concurrentCalls);
        tmp.append("' maxConcurrentCalls='");
        tmp.append(this.maxConcurrentCalls);
        tmp.append("' >\n");
        HashMap copy = new HashMap(this.ctxStats);
        Iterator iter = copy.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            TimeStatistic stat = (TimeStatistic)entry.getValue();
            tmp.append("<webCtx name='");
            tmp.append(entry.getKey());
            tmp.append("' count='");
            tmp.append(stat.count);
            tmp.append("' minTime='");
            tmp.append(stat.minTime);
            tmp.append("' maxTime='");
            tmp.append(stat.maxTime);
            tmp.append("' totalTime='");
            tmp.append(stat.totalTime);
            tmp.append("' />\n");
        }
        tmp.append("</InvocationStatistics>");
        return tmp.toString();
    }

    public static class TimeStatistic {
        public long count;
        public long minTime = Long.MAX_VALUE;
        public long maxTime;
        public long totalTime;

        public void reset() {
            this.count = 0L;
            this.minTime = Long.MAX_VALUE;
            this.maxTime = 0L;
            this.totalTime = 0L;
        }
    }
}

