/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.snmptrap.factory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoLocal;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoPK;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoUtil;
import com.clustercontrol.monitor.run.ejb.entity.MonitorNumericValueInfoLocal;
import com.clustercontrol.monitor.run.ejb.entity.MonitorNumericValueInfoUtil;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapInfoLocal;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapInfoPK;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapInfoUtil;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapOidInfoLocal;
import com.clustercontrol.snmptrap.message.UpdateSnmpTrapInfo;
import com.clustercontrol.snmptrap.util.SendTopic;
import com.clustercontrol.util.apllog.AplLogger;
import java.util.Collection;
import java.util.Iterator;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.jms.JMSException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeleteMonitorInfo {
    protected static Log m_log = LogFactory.getLog(DeleteMonitorInfo.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean delete(String monitorId) throws NotSupportedException, RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException, InvalidTransactionException, NamingException, FinderException, RemoveException {
        AccessLock.lock((String)"MONITOR_SNMPTRAP");
        TransactionManager tm = null;
        Transaction tx = null;
        Transaction oldTx = null;
        boolean result = false;
        try {
            InitialContext context = new InitialContext();
            tm = (TransactionManager)context.lookup("java:/TransactionManager");
            if (tm.getTransaction() != null) {
                oldTx = tm.suspend();
            }
            try {
                if (tm.getTransaction() == null) {
                    tm.begin();
                    tx = tm.getTransaction();
                }
                if (result = this.deleteMonitorInfo(monitorId)) {
                    tx.commit();
                }
                try {
                    UpdateSnmpTrapInfo updateInfo = new UpdateSnmpTrapInfo(2, monitorId);
                    SendTopic sendTopic = new SendTopic("topic/clustercontrol/SnmpTrap/update");
                    sendTopic.put(updateInfo);
                }
                catch (NamingException e) {
                    m_log.error((Object)("delete() : \u9001\u4fe1\u30a8\u30e9\u30fc\u3002" + e.getMessage()));
                }
                catch (JMSException e) {
                    m_log.error((Object)("delete() : \u9001\u4fe1\u30a8\u30e9\u30fc\u3002" + e.getMessage()));
                }
            }
            catch (NotSupportedException e) {
                this.outputLog((Exception)((Object)e), "delete()", monitorId);
                throw e;
            }
            catch (RollbackException e) {
                this.outputLog((Exception)((Object)e), "delete()", monitorId);
                throw e;
            }
            catch (HeuristicMixedException e) {
                this.outputLog((Exception)((Object)e), "delete()", monitorId);
                throw e;
            }
            catch (HeuristicRollbackException e) {
                this.outputLog((Exception)((Object)e), "delete()", monitorId);
                throw e;
            }
            catch (SystemException e) {
                this.outputLog((Exception)((Object)e), "delete()", monitorId);
                throw e;
            }
            finally {
                if (tx != null) {
                    if (!result) {
                        tx.rollback();
                    }
                    tx = null;
                }
            }
            if (oldTx == null) return result;
        }
        catch (Throwable throwable) {
            if (oldTx == null) throw throwable;
            try {
                tm.resume(oldTx);
                throw throwable;
            }
            catch (InvalidTransactionException e) {
                this.outputLog((Exception)((Object)e), "delete()", monitorId);
                throw e;
            }
            catch (IllegalStateException e) {
                this.outputLog(e, "delete()", monitorId);
                throw e;
            }
            catch (SystemException e) {
                this.outputLog((Exception)((Object)e), "delete()", monitorId);
                throw e;
            }
        }
        try {
            tm.resume(oldTx);
            return result;
        }
        catch (InvalidTransactionException e) {
            this.outputLog((Exception)((Object)e), "delete()", monitorId);
            throw e;
        }
        catch (IllegalStateException e) {
            this.outputLog(e, "delete()", monitorId);
            throw e;
        }
        catch (SystemException e) {
            this.outputLog((Exception)((Object)e), "delete()", monitorId);
            throw e;
        }
    }

    public boolean deleteMonitorInfo(String monitorId) throws NamingException, FinderException, RemoveException {
        boolean result = false;
        try {
            SnmpTrapInfoLocal info = SnmpTrapInfoUtil.getLocalHome().findByPrimaryKey(new SnmpTrapInfoPK(monitorId));
            Collection ct = info.getSnmpTrapOidInfo();
            if (ct != null && ct.size() > 0) {
                Object[] infoArray = ct.toArray();
                for (int j = 0; j < infoArray.length; ++j) {
                    SnmpTrapOidInfoLocal oidInfo = (SnmpTrapOidInfoLocal)infoArray[j];
                    if (oidInfo == null) continue;
                    oidInfo.remove();
                }
            }
            try {
                Collection mnvis = MonitorNumericValueInfoUtil.getLocalHome().findByMonitorTypeIdAndMonitorId("SNMPTRAP", info.getMonitorId());
                Iterator itr = mnvis.iterator();
                MonitorNumericValueInfoLocal local = null;
                while (itr.hasNext()) {
                    local = (MonitorNumericValueInfoLocal)itr.next();
                    local.remove();
                }
            }
            catch (FinderException e) {
                m_log.warn((Object)("deleteMonitorInfo(): MonitorNumericValueInfo not found '" + monitorId + "', " + e.getMessage()));
            }
            try {
                MonitorInfoPK mipk = new MonitorInfoPK(info.getMonitorId(), "SNMPTRAP");
                MonitorInfoLocal infoLocal = MonitorInfoUtil.getLocalHome().findByPrimaryKey(mipk);
                infoLocal.remove();
            }
            catch (FinderException e) {
                m_log.warn((Object)("deleteMonitorInfo(): MonitorInfo not found '" + monitorId + "', " + e.getMessage()));
            }
            info.remove();
            result = true;
        }
        catch (NamingException e) {
            this.outputLog(e, "deleteMonitorInfo()", monitorId);
            throw e;
        }
        catch (FinderException e) {
            this.outputLog((Exception)((Object)e), "deleteMonitorInfo()", monitorId);
            throw e;
        }
        catch (EJBException e) {
            this.outputLog((Exception)((Object)e), "deleteMonitorInfo()", monitorId);
            throw e;
        }
        catch (RemoveException e) {
            this.outputLog((Exception)((Object)e), "deleteMonitorInfo()", monitorId);
            throw e;
        }
        return result;
    }

    private void outputLog(Exception e, String method, String monitorId) {
        AplLogger apllog = new AplLogger("TRAP", "trap");
        Object[] args = new String[]{monitorId};
        apllog.put("SYS", "003", args);
        m_log.debug((Object)(method + ":" + e.getMessage()));
    }
}

