/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.snmptrap.factory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMibMasterData;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMibMasterLocal;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMibMasterPK;
import com.clustercontrol.snmptrap.ejb.entity.SnmpTrapMibMasterUtil;
import com.clustercontrol.util.apllog.AplLogger;
import java.sql.Timestamp;
import java.util.Date;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ModifyMibMaster {
    protected static Log m_log = LogFactory.getLog(ModifyMibMaster.class);
    protected SnmpTrapMibMasterData m_MibData;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean modify(SnmpTrapMibMasterData mibData, String user) throws CreateException, NotSupportedException, RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException, InvalidTransactionException, NamingException, FinderException {
        AccessLock.lock((String)"MONITOR_SNMPTRAP");
        this.m_MibData = mibData;
        TransactionManager tm = null;
        Transaction tx = null;
        Transaction oldTx = null;
        boolean result = false;
        try {
            InitialContext context = new InitialContext();
            tm = (TransactionManager)context.lookup("java:/TransactionManager");
            if (tm.getTransaction() != null) {
                oldTx = tm.suspend();
            }
            try {
                if (tm.getTransaction() == null) {
                    tm.begin();
                    tx = tm.getTransaction();
                }
                if (result = this.modifyMibMaster(user)) {
                    tx.commit();
                }
            }
            catch (NotSupportedException e) {
                this.outputLog((Exception)((Object)e), "add()");
                throw e;
            }
            catch (RollbackException e) {
                this.outputLog((Exception)((Object)e), "add()");
                throw e;
            }
            catch (HeuristicMixedException e) {
                this.outputLog((Exception)((Object)e), "add()");
                throw e;
            }
            catch (HeuristicRollbackException e) {
                this.outputLog((Exception)((Object)e), "add()");
                throw e;
            }
            catch (SystemException e) {
                this.outputLog((Exception)((Object)e), "add()");
                throw e;
            }
            finally {
                if (tx != null) {
                    if (!result) {
                        tx.rollback();
                    }
                    tx = null;
                }
            }
            if (oldTx == null) return result;
        }
        catch (Throwable throwable) {
            if (oldTx == null) throw throwable;
            try {
                tm.resume(oldTx);
                throw throwable;
            }
            catch (InvalidTransactionException e) {
                this.outputLog((Exception)((Object)e), "add()");
                throw e;
            }
            catch (IllegalStateException e) {
                this.outputLog(e, "add()");
                throw e;
            }
            catch (SystemException e) {
                this.outputLog((Exception)((Object)e), "add()");
                throw e;
            }
        }
        try {
            tm.resume(oldTx);
            return result;
        }
        catch (InvalidTransactionException e) {
            this.outputLog((Exception)((Object)e), "add()");
            throw e;
        }
        catch (IllegalStateException e) {
            this.outputLog(e, "add()");
            throw e;
        }
        catch (SystemException e) {
            this.outputLog((Exception)((Object)e), "add()");
            throw e;
        }
    }

    public boolean modifyMibMaster(String user) throws NamingException, FinderException {
        boolean result = false;
        try {
            Timestamp now = new Timestamp(new Date().getTime());
            SnmpTrapMibMasterLocal mibMaster = SnmpTrapMibMasterUtil.getLocalHome().findByPrimaryKey(new SnmpTrapMibMasterPK(this.m_MibData.getMib()));
            mibMaster.setDescription(this.m_MibData.getDescription());
            mibMaster.setOrderNo(this.m_MibData.getOrderNo());
            mibMaster.setUpdateDate(now);
            mibMaster.setUpdateUser(user);
            result = true;
        }
        catch (NamingException e) {
            this.outputLog(e, "addMibMaster()");
            throw e;
        }
        return result;
    }

    private void outputLog(Exception e, String method) {
        AplLogger apllog = new AplLogger("TRAP", "trap");
        Object[] args = new String[]{this.m_MibData.getMib()};
        apllog.put("SYS", "001", args);
        m_log.debug((Object)(method + ":" + e.getMessage()));
    }
}

