/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.console.plugins.monitor;

import java.io.IOException;
import java.net.URLEncoder;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.logging.Logger;
import org.jboss.monitor.SnapshotRecordingMonitor;
import org.jboss.mx.util.MBeanServerLocator;

public class CreateSnapshotServlet
extends HttpServlet {
    static final long serialVersionUID = -6005190747212975396L;
    private static final Logger log = Logger.getLogger(class$org$jboss$console$plugins$monitor$CreateSnapshotServlet == null ? (class$org$jboss$console$plugins$monitor$CreateSnapshotServlet = CreateSnapshotServlet.class$("org.jboss.console.plugins.monitor.CreateSnapshotServlet")) : class$org$jboss$console$plugins$monitor$CreateSnapshotServlet);
    static /* synthetic */ Class class$org$jboss$console$plugins$monitor$CreateSnapshotServlet;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doit(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doit(req, resp);
    }

    protected void error(String msg, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        req.setAttribute("error", (Object)("Error: " + msg));
        req.getRequestDispatcher("/createSnapshot.jsp").forward((ServletRequest)req, (ServletResponse)resp);
    }

    protected void doit(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String monitorName = req.getParameter("monitorName").trim();
        log.debug(monitorName);
        String objectName = req.getParameter("objectName").trim();
        log.debug(objectName);
        MBeanServer mbeanServer = MBeanServerLocator.locateJBoss();
        ObjectName oname = null;
        try {
            oname = new ObjectName(objectName);
        }
        catch (MalformedObjectNameException e) {
            this.error("Malformed ObjectName ", req, resp);
            return;
        }
        String attribute = req.getParameter("attribute").trim();
        log.debug(attribute);
        Object val = null;
        try {
            val = mbeanServer.getAttribute(oname, attribute);
        }
        catch (Exception e) {
            this.error("Unable to pull attribute value from MBean, does the attribute exist? ", req, resp);
            return;
        }
        String period = req.getParameter("period").trim();
        log.debug(period);
        long timePeriod = 0L;
        try {
            timePeriod = Long.parseLong(period);
        }
        catch (NumberFormatException e) {
            this.error("Illegal format for watch period.", req, resp);
            return;
        }
        try {
            SnapshotRecordingMonitor monitor = new SnapshotRecordingMonitor();
            monitor.setMonitorName(monitorName);
            monitor.setObservedObject(oname);
            monitor.setObservedAttribute(attribute);
            monitor.setPeriod(timePeriod);
            ObjectName sname = new ObjectName("jboss.snapshot:name=" + monitorName);
            mbeanServer.registerMBean(monitor, sname);
            resp.sendRedirect("/web-console/manageSnapshot.jsp?monitorObjectName=" + URLEncoder.encode(sname.toString()));
        }
        catch (Exception ex) {
            this.error("Failed to create non-persisted monitor: " + ex.toString(), req, resp);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

