/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.tx;

import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aspects.tx.TxPolicy;

public class TxInterceptor {

    public static class Mandatory
    implements Interceptor {
        protected TransactionManager tm;
        protected TxPolicy policy;

        public Mandatory(TransactionManager tm, TxPolicy policy) {
            this.tm = tm;
            this.policy = policy;
        }

        public String getName() {
            return this.getClass().getName();
        }

        public Object invoke(Invocation invocation) throws Throwable {
            Transaction tx = this.tm.getTransaction();
            if (tx == null) {
                this.policy.throwMandatory(invocation);
            }
            return this.policy.invokeInCallerTx(invocation, tx);
        }
    }

    public static class RequiresNew
    implements Interceptor {
        protected TransactionManager tm;
        protected TxPolicy policy;

        public RequiresNew(TransactionManager tm, TxPolicy policy) {
            this.tm = tm;
            this.policy = policy;
        }

        public String getName() {
            return this.getClass().getName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Invocation invocation) throws Throwable {
            Transaction tx = this.tm.getTransaction();
            if (tx != null) {
                this.tm.suspend();
                try {
                    Object object = this.policy.invokeInOurTx(invocation, this.tm);
                    return object;
                }
                finally {
                    this.tm.resume(tx);
                }
            }
            return this.policy.invokeInOurTx(invocation, this.tm);
        }
    }

    public static class Required
    implements Interceptor {
        protected TransactionManager tm;
        protected TxPolicy policy;

        public Required(TransactionManager tm, TxPolicy policy) {
            this.tm = tm;
            this.policy = policy;
        }

        public Object invoke(Invocation invocation) throws Throwable {
            Transaction tx = this.tm.getTransaction();
            if (tx == null) {
                return this.policy.invokeInOurTx(invocation, this.tm);
            }
            return this.policy.invokeInCallerTx(invocation, tx);
        }

        public String getName() {
            return this.getClass().getName();
        }
    }

    public static class Supports
    implements Interceptor {
        protected TransactionManager tm;
        protected TxPolicy policy;

        public Supports(TransactionManager tm, TxPolicy policy) {
            this.tm = tm;
            this.policy = policy;
        }

        public Object invoke(Invocation invocation) throws Throwable {
            if (this.tm.getTransaction() == null) {
                return this.policy.invokeInNoTx(invocation);
            }
            return this.policy.invokeInCallerTx(invocation, this.tm.getTransaction());
        }

        public String getName() {
            return this.getClass().getName();
        }
    }

    public static class NotSupported
    implements Interceptor {
        protected TransactionManager tm;
        protected TxPolicy policy;

        public NotSupported(TransactionManager tm, TxPolicy policy) {
            this.tm = tm;
            this.policy = policy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Invocation invocation) throws Throwable {
            Transaction tx = this.tm.getTransaction();
            if (tx != null) {
                this.tm.suspend();
                try {
                    Object object = this.policy.invokeInNoTx(invocation);
                    return object;
                }
                finally {
                    this.tm.resume(tx);
                }
            }
            return this.policy.invokeInNoTx(invocation);
        }

        public String getName() {
            return this.getClass().getName();
        }
    }

    public static class Never
    implements Interceptor {
        protected TransactionManager tm;
        protected TxPolicy policy;

        public Never(TransactionManager tm, TxPolicy policy) {
            this.tm = tm;
            this.policy = policy;
        }

        public Object invoke(Invocation invocation) throws Throwable {
            if (this.tm.getTransaction() != null) {
                throw new IllegalStateException("Transaction present on server in Never call");
            }
            return this.policy.invokeInNoTx(invocation);
        }

        public String getName() {
            return this.getClass().getName();
        }
    }
}

