/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import javax.security.auth.Subject;
import org.jboss.logging.Logger;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityActions;

public final class SecurityAssociation {
    private static Logger log = Logger.getLogger(SecurityAssociation.class);
    private static boolean trace;
    private static boolean server;
    private static Principal principal;
    private static Object credential;
    private static ThreadLocal threadPrincipal;
    private static ThreadLocal threadCredential;
    private static ThreadLocal threadContextMap;
    private static RunAsThreadLocalStack threadRunAsStacks;
    private static SubjectThreadLocalStack threadSubjectStacks;
    private static final RuntimePermission getPrincipalInfoPermission;
    private static final RuntimePermission getSubjectPermission;
    private static final RuntimePermission setPrincipalInfoPermission;
    private static final RuntimePermission setServerPermission;
    private static final RuntimePermission setRunAsIdentity;
    private static final RuntimePermission getContextInfo;
    private static final RuntimePermission setContextInfo;

    public static Principal getPrincipal() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(getPrincipalInfoPermission);
        }
        Principal thePrincipal = principal;
        if (server) {
            thePrincipal = (Principal)threadPrincipal.get();
        }
        if (trace) {
            log.trace("getPrincipal, principal=" + thePrincipal);
        }
        return thePrincipal;
    }

    public static Principal getCallerPrincipal() {
        Principal thePrincipal;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(getPrincipalInfoPermission);
        }
        if ((thePrincipal = SecurityAssociation.peekRunAsIdentity(1)) == null) {
            thePrincipal = server ? (Principal)threadPrincipal.get() : principal;
        }
        if (trace) {
            log.trace("getCallerPrincipal, principal=" + thePrincipal);
        }
        return thePrincipal;
    }

    public static Object getCredential() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(getPrincipalInfoPermission);
        }
        if (server) {
            return threadCredential.get();
        }
        return credential;
    }

    public static Subject getSubject() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(getSubjectPermission);
        }
        SubjectContext sc = threadSubjectStacks.peek();
        if (trace) {
            log.trace("getSubject, sc=" + sc);
        }
        Subject subject = null;
        if (sc != null) {
            subject = sc.getSubject();
        }
        return subject;
    }

    public static void setPrincipal(Principal principal) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(setPrincipalInfoPermission);
        }
        if (trace) {
            log.trace("setPrincipal, p=" + principal + ", server=" + server);
        }
        if (server) {
            threadPrincipal.set(principal);
        } else {
            SecurityAssociation.principal = principal;
        }
        SubjectContext sc = threadSubjectStacks.peek();
        if (sc == null) {
            sc = new SubjectContext();
            threadSubjectStacks.push(sc);
        } else if ((sc.getFlags() & 2) != 0) {
            sc = new SubjectContext();
            threadSubjectStacks.push(sc);
        }
        sc.setPrincipal(principal);
        if (trace) {
            log.trace("setPrincipal, sc=" + sc);
        }
    }

    public static void setCredential(Object credential) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(setPrincipalInfoPermission);
        }
        if (server) {
            threadCredential.set(credential);
        } else {
            SecurityAssociation.credential = credential;
        }
        SubjectContext sc = threadSubjectStacks.peek();
        if (sc == null) {
            sc = new SubjectContext();
            threadSubjectStacks.push(sc);
        } else if ((sc.getFlags() & 4) != 0) {
            sc = new SubjectContext();
            threadSubjectStacks.push(sc);
        }
        sc.setCredential(credential);
        if (trace) {
            log.trace("setCredential, sc=" + sc);
        }
    }

    public static void setSubject(Subject subject) {
        SubjectContext sc;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(setPrincipalInfoPermission);
        }
        if (trace) {
            log.trace("setSubject, s=" + subject + ", server=" + server);
        }
        if ((sc = threadSubjectStacks.peek()) == null) {
            sc = new SubjectContext();
            threadSubjectStacks.push(sc);
        } else if ((sc.getFlags() & 1) != 0) {
            sc = new SubjectContext();
            threadSubjectStacks.push(sc);
        }
        sc.setSubject(subject);
        if (trace) {
            log.trace("setSubject, sc=" + sc);
        }
    }

    public static Object getContextInfo(Object key) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(getContextInfo);
        }
        HashMap contextInfo = (HashMap)threadContextMap.get();
        return contextInfo.get(key);
    }

    public static Object setContextInfo(Object key, Object value) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(setContextInfo);
        }
        HashMap contextInfo = (HashMap)threadContextMap.get();
        return contextInfo.put(key, value);
    }

    public static void pushSubjectContext(Subject subject, Principal principal, Object credential) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(setPrincipalInfoPermission);
        }
        if (server) {
            threadPrincipal.set(principal);
            threadCredential.set(credential);
        } else {
            SecurityAssociation.principal = principal;
            SecurityAssociation.credential = credential;
        }
        SubjectContext sc = new SubjectContext(subject, principal, credential);
        threadSubjectStacks.push(sc);
        if (trace) {
            log.trace("pushSubjectContext, subject=" + subject + ", sc=" + sc);
        }
    }

    public static void dupSubjectContext() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(setPrincipalInfoPermission);
        }
        SubjectContext sc = threadSubjectStacks.dup();
        if (trace) {
            log.trace("dupSubjectContext, sc=" + sc);
        }
    }

    public static SubjectContext popSubjectContext() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(setPrincipalInfoPermission);
        }
        SubjectContext sc = threadSubjectStacks.pop();
        if (trace) {
            log.trace("popSubjectContext, sc=" + sc);
        }
        return sc;
    }

    public static void clear() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(setPrincipalInfoPermission);
        }
        if (trace) {
            log.trace("clear, server=" + server);
        }
        if (server) {
            threadPrincipal.set(null);
            threadCredential.set(null);
        } else {
            principal = null;
            credential = null;
        }
        threadSubjectStacks.clear();
    }

    public static void pushRunAsIdentity(RunAsIdentity runAs) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(setRunAsIdentity);
        }
        if (trace) {
            log.trace("pushRunAsIdentity, runAs=" + runAs);
        }
        threadRunAsStacks.push(runAs);
    }

    public static RunAsIdentity popRunAsIdentity() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(setRunAsIdentity);
        }
        RunAsIdentity runAs = threadRunAsStacks.pop();
        if (trace) {
            log.trace("popRunAsIdentity, runAs=" + runAs);
        }
        return runAs;
    }

    public static RunAsIdentity peekRunAsIdentity() {
        return SecurityAssociation.peekRunAsIdentity(0);
    }

    public static RunAsIdentity peekRunAsIdentity(int depth) {
        RunAsIdentity runAs = threadRunAsStacks.peek(depth);
        return runAs;
    }

    public static void setServer() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(setServerPermission);
        }
        server = true;
    }

    static {
        getPrincipalInfoPermission = new RuntimePermission("org.jboss.security.SecurityAssociation.getPrincipalInfo");
        getSubjectPermission = new RuntimePermission("org.jboss.security.SecurityAssociation.getSubject");
        setPrincipalInfoPermission = new RuntimePermission("org.jboss.security.SecurityAssociation.setPrincipalInfo");
        setServerPermission = new RuntimePermission("org.jboss.security.SecurityAssociation.setServer");
        setRunAsIdentity = new RuntimePermission("org.jboss.security.SecurityAssociation.setRunAsRole");
        getContextInfo = new RuntimePermission("org.jboss.security.SecurityAssociation.accessContextInfo", "get");
        setContextInfo = new RuntimePermission("org.jboss.security.SecurityAssociation.accessContextInfo", "set");
        String flag = SecurityActions.getProperty("org.jboss.security.SecurityAssociation.ThreadLocal", "false");
        boolean useThreadLocal = Boolean.valueOf(flag);
        log.debug("Using ThreadLocal: " + useThreadLocal);
        trace = log.isTraceEnabled();
        if (useThreadLocal) {
            threadPrincipal = new ThreadLocal();
            threadCredential = new ThreadLocal();
            threadContextMap = new ThreadLocal(){

                protected Object initialValue() {
                    return new HashMap();
                }
            };
        } else {
            threadPrincipal = new InheritableThreadLocal();
            threadCredential = new InheritableThreadLocal();
            threadContextMap = new HashMapInheritableLocal();
        }
        threadRunAsStacks = new RunAsThreadLocalStack(useThreadLocal);
        threadSubjectStacks = new SubjectThreadLocalStack(useThreadLocal);
    }

    private static class HashMapInheritableLocal
    extends InheritableThreadLocal {
        private HashMapInheritableLocal() {
        }

        protected Object childValue(Object parentValue) {
            HashMap map = (HashMap)parentValue;
            HashMap copy = null;
            try {
                copy = new HashMap(map);
            }
            catch (Throwable t) {
                log.debug("Failed to copy parent map, using new map");
                copy = new HashMap();
            }
            return copy;
        }

        protected Object initialValue() {
            return new HashMap();
        }
    }

    private static class ArrayListInheritableLocal
    extends InheritableThreadLocal {
        private ArrayListInheritableLocal() {
        }

        protected Object childValue(Object parentValue) {
            ArrayList list = (ArrayList)parentValue;
            ArrayList copy = null;
            try {
                copy = new ArrayList(list);
            }
            catch (Throwable t) {
                log.debug("Failed to copy parent list, using new list");
                copy = new ArrayList();
            }
            return copy;
        }

        protected Object initialValue() {
            return new ArrayList();
        }
    }

    private static class ArrayListLocal
    extends ThreadLocal {
        private ArrayListLocal() {
        }

        protected Object initialValue() {
            return new ArrayList();
        }
    }

    private static class SubjectThreadLocalStack {
        ThreadLocal local;

        SubjectThreadLocalStack(boolean threadLocal) {
            this.local = threadLocal ? new ArrayListLocal() : new ArrayListInheritableLocal();
        }

        void push(SubjectContext context) {
            ArrayList stack = (ArrayList)this.local.get();
            stack.add(context);
        }

        SubjectContext dup() {
            ArrayList stack = (ArrayList)this.local.get();
            SubjectContext context = null;
            int lastIndex = stack.size() - 1;
            if (lastIndex >= 0) {
                context = (SubjectContext)stack.get(lastIndex);
                stack.add(context);
            }
            return context;
        }

        SubjectContext pop() {
            ArrayList stack = (ArrayList)this.local.get();
            SubjectContext context = null;
            int lastIndex = stack.size() - 1;
            if (lastIndex >= 0) {
                context = (SubjectContext)stack.remove(lastIndex);
            }
            return context;
        }

        SubjectContext peek() {
            ArrayList stack = (ArrayList)this.local.get();
            SubjectContext context = null;
            int lastIndex = stack.size() - 1;
            if (lastIndex >= 0) {
                context = (SubjectContext)stack.get(lastIndex);
            }
            return context;
        }

        void clear() {
            ArrayList stack = (ArrayList)this.local.get();
            stack.clear();
        }
    }

    public static class SubjectContext {
        public static final int SUBJECT_WAS_SET = 1;
        public static final int PRINCIPAL_WAS_SET = 2;
        public static final int CREDENTIAL_WAS_SET = 4;
        private Subject subject;
        private Principal principal;
        private Object credential;
        private int flags;

        public SubjectContext() {
            this.flags = 0;
        }

        public SubjectContext(Subject s, Principal p, Object cred) {
            this.subject = s;
            this.principal = p;
            this.credential = cred;
            this.flags = 7;
        }

        public Subject getSubject() {
            return this.subject;
        }

        public void setSubject(Subject subject) {
            this.subject = subject;
            this.flags |= 1;
        }

        public Principal getPrincipal() {
            return this.principal;
        }

        public void setPrincipal(Principal principal) {
            this.principal = principal;
            this.flags |= 2;
        }

        public Object getCredential() {
            return this.credential;
        }

        public void setCredential(Object credential) {
            this.credential = credential;
            this.flags |= 4;
        }

        public int getFlags() {
            return this.flags;
        }

        public String toString() {
            StringBuffer tmp = new StringBuffer(super.toString());
            tmp.append("{principal=");
            tmp.append(this.principal);
            tmp.append(",subject=");
            if (this.subject != null) {
                tmp.append(System.identityHashCode(this.subject));
            } else {
                tmp.append("null");
            }
            tmp.append("}");
            return tmp.toString();
        }
    }

    private static class RunAsThreadLocalStack {
        ThreadLocal local;

        RunAsThreadLocalStack(boolean threadLocal) {
            this.local = threadLocal ? new ArrayListLocal() : new ArrayListInheritableLocal();
        }

        void push(RunAsIdentity runAs) {
            ArrayList stack = (ArrayList)this.local.get();
            stack.add(runAs);
        }

        RunAsIdentity pop() {
            ArrayList stack = (ArrayList)this.local.get();
            RunAsIdentity runAs = null;
            int lastIndex = stack.size() - 1;
            if (lastIndex >= 0) {
                runAs = (RunAsIdentity)stack.remove(lastIndex);
            }
            return runAs;
        }

        RunAsIdentity peek(int depth) {
            ArrayList stack = (ArrayList)this.local.get();
            RunAsIdentity runAs = null;
            int stackSize = stack.size();
            do {
                int index;
                if ((index = stackSize - 1 - depth) < 0) continue;
                runAs = (RunAsIdentity)stack.get(index);
            } while (runAs == null && ++depth <= stackSize - 1);
            return runAs;
        }
    }
}

