/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performanceMGR.monitor.factory;

import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoPK;
import com.clustercontrol.monitor.run.ejb.entity.MonitorInfoUtil;
import com.clustercontrol.monitor.run.factory.ModifyMonitorNumericValueType;
import com.clustercontrol.monitor.run.factory.SelectSchedule;
import com.clustercontrol.performanceMGR.bean.CollectorItemInfo;
import com.clustercontrol.performanceMGR.ejb.bmp.Collector;
import com.clustercontrol.performanceMGR.ejb.bmp.CollectorHome;
import com.clustercontrol.performanceMGR.ejb.bmp.CollectorPK;
import com.clustercontrol.performanceMGR.monitor.bean.MonitorPerfCheckInfo;
import com.clustercontrol.performanceMGR.monitor.ejb.entity.MonitorPerfInfoLocal;
import com.clustercontrol.performanceMGR.monitor.ejb.entity.MonitorPerfInfoPK;
import com.clustercontrol.performanceMGR.monitor.ejb.entity.MonitorPerfInfoUtil;
import com.clustercontrol.performanceMGR.monitor.factory.ModifySchedule;
import com.clustercontrol.performanceMGR.util.JNDIConnectionManager;
import com.clustercontrol.util.apllog.AplLogger;
import java.rmi.RemoteException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.SchedulerException;

public class ModifyMonitorPerformance
extends ModifyMonitorNumericValueType {
    protected static Log m_log = LogFactory.getLog(ModifyMonitorPerformance.class);

    public boolean modify(MonitorInfo info, String user) throws CreateException, FinderException, RemoveException, SchedulerException, ParseException, NamingException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, InvalidTransactionException, IllegalStateException, SystemException {
        String collectorId = ((MonitorPerfCheckInfo)info.getCheckInfo()).getCollectorId();
        super.modify(info, user);
        try {
            CollectorHome home = JNDIConnectionManager.getCollectorHome();
            Collector myBean = home.findByPrimaryKey(new CollectorPK(collectorId));
            myBean.stopCollect();
            if (myBean.getStatus() == 100) {
                m_log.debug((Object)("deleteRecordCollector()  : " + collectorId + " is running."));
                throw new RemoveException(collectorId + " is running.");
            }
            myBean.remove();
        }
        catch (FinderException e) {
        }
        catch (RemoteException e) {
            throw new EJBException((Exception)e);
        }
        if (info.getValid() == 1) {
            MonitorPerfCheckInfo mpInfo = (MonitorPerfCheckInfo)info.getCheckInfo();
            ArrayList<CollectorItemInfo> itemList = new ArrayList<CollectorItemInfo>();
            CollectorItemInfo itemInfo = new CollectorItemInfo(mpInfo.getCollectorId(), 0, mpInfo.getItemCode(), mpInfo.getDeviceIndex().intValue(), mpInfo.getDeviceName());
            itemList.add(itemInfo);
            ModifySchedule scheduler = new ModifySchedule();
            scheduler.addSchedule(info.getMonitorId(), collectorId, info.getFacilityId(), info.getRunInterval(), itemList, info.getValid());
        }
        return true;
    }

    public boolean modifyCheckInfo() throws CreateException, FinderException, NamingException {
        MonitorPerfInfoPK pk = new MonitorPerfInfoPK(this.m_monitorInfo.getMonitorId(), this.m_monitorInfo.getMonitorTypeId());
        MonitorPerfInfoLocal perfLocal = MonitorPerfInfoUtil.getLocalHome().findByPrimaryKey(pk);
        MonitorPerfCheckInfo perfCheck = (MonitorPerfCheckInfo)this.m_monitorInfo.getCheckInfo();
        perfLocal.setCollectorId(perfCheck.getCollectorId());
        perfLocal.setItemCode(perfCheck.getItemCode());
        perfLocal.setDeviceIndex(perfCheck.getDeviceIndex());
        perfLocal.setDeviceName(perfCheck.getDeviceName());
        boolean result = true;
        return result;
    }

    protected boolean modifyMonitorInfo(String user) throws CreateException, FinderException, RemoveException, SchedulerException, ParseException, NamingException {
        try {
            MonitorInfoPK pk = new MonitorInfoPK(this.m_monitorInfo.getMonitorId(), this.m_monitorInfo.getMonitorTypeId());
            this.m_monitor = MonitorInfoUtil.getLocalHome().findByPrimaryKey(pk);
            if (!this.m_monitorInfo.getFacilityId().equals(this.m_monitor.getFacilityId())) {
                this.m_isModifyFacilityId = true;
            }
            if (this.m_monitorInfo.getRunInterval() != this.m_monitor.getRunInterval().intValue()) {
                this.m_isModifyRunInterval = true;
            }
            if (!this.m_isModifyRunInterval) {
                int oldValid = new SelectSchedule().getValid(this.m_monitorInfo.getMonitorTypeId(), this.m_monitorInfo.getMonitorId());
                if (this.m_monitorInfo.getValid() != oldValid) {
                    this.m_isModifyValid = true;
                }
            }
            this.m_monitor.setDescription(this.m_monitorInfo.getDescription());
            if (this.m_isModifyFacilityId) {
                this.m_monitor.setFacilityId(this.m_monitorInfo.getFacilityId());
            }
            if (this.m_isModifyRunInterval) {
                this.m_monitor.setRunInterval(Integer.valueOf(this.m_monitorInfo.getRunInterval()));
            }
            this.m_monitor.setTimeout(Integer.valueOf(this.m_monitorInfo.getTimeout()));
            this.m_monitor.setCalendarId(this.m_monitorInfo.getCalendarId());
            this.m_monitor.setMonitorBlock(Integer.valueOf(this.m_monitorInfo.getMonitorBlock()));
            this.m_monitor.setDeterminationId(this.m_monitorInfo.getDeterminationId());
            this.m_monitor.setFailurePriority(Integer.valueOf(this.m_monitorInfo.getFailurePriority()));
            this.m_monitor.setNotifyId(this.m_monitorInfo.getNotifyId());
            this.m_monitor.setApplication(this.m_monitorInfo.getApplication());
            this.m_monitor.setJobRun(Integer.valueOf(this.m_monitorInfo.getJobRun()));
            this.m_monitorInfo.setFailureMessageId(this.m_monitorInfo.getFailureMessageId());
            this.m_monitorInfo.setFailureMessage(this.m_monitorInfo.getFailureMessage());
            this.m_monitorInfo.setFailureJobRun(this.m_monitorInfo.getFailureJobRun());
            this.m_monitorInfo.setFailureJobId(this.m_monitorInfo.getFailureJobId());
            this.m_monitorInfo.setFailureJobInhibitionFlg(this.m_monitorInfo.getFailureJobInhibitionFlg());
            this.m_monitorInfo.setFailureJobFailurePriority(this.m_monitorInfo.getFailureJobFailurePriority());
            this.m_monitor.setUpdateDate(new Timestamp(new Date().getTime()));
            this.m_monitor.setUpdateUser(user);
            return this.modifyJudgementInfo() && this.modifyCheckInfo();
        }
        catch (CreateException e) {
            this.outputLog((Exception)((Object)e), "modifyMonitorInfo()");
            e.printStackTrace();
            throw e;
        }
        catch (FinderException e) {
            this.outputLog((Exception)((Object)e), "modifyMonitorInfo()");
            e.printStackTrace();
            throw e;
        }
        catch (RemoveException e) {
            this.outputLog((Exception)((Object)e), "modifyMonitorInfo()");
            e.printStackTrace();
            throw e;
        }
        catch (SchedulerException e) {
            this.outputLog((Exception)((Object)e), "modifyMonitorInfo()");
            e.printStackTrace();
            throw e;
        }
        catch (NamingException e) {
            this.outputLog(e, "modifyMonitorInfo()");
            e.printStackTrace();
            throw e;
        }
    }

    private void outputLog(Exception e, String method) {
        AplLogger apllog = new AplLogger("PERF", "perf");
        Object[] args = new String[]{this.m_monitorInfo.getMonitorTypeId(), this.m_monitorInfo.getMonitorId()};
        apllog.put("SYS", "008", args);
        m_log.debug((Object)(method + ":" + e.getMessage()));
    }
}

