#!/bin/sh

#Copyright (C) 2006 - 2008 NTT DATA Corporation
#
#This program is free software; you can redistribute it and/or
#Modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation, version 2.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details

#設定情報読み込み

HINEMOS_HOME=`pwd`
. ${HINEMOS_HOME}/hinemos.cfg

LDAP_DATA=${HINEMOS_HOME}/var/openldap-data

#openldap-dataディレクトリを作成
rm -rf ${LDAP_DATA}
mkdir ${LDAP_DATA}
chmod 755 ${LDAP_DATA}

#ldifからデータを登録する。
#エラーが出力された場合はログファイルを作成する。
if [ $LANG = "C" ] ; then
	${LDAP}/sbin/slapadd -l ${HINEMOS_HOME}/sbin/db_init/hinemos_ldap_en.ldif 2> slapadd.log
else
	${LDAP}/sbin/slapadd -l ${HINEMOS_HOME}/sbin/db_init/hinemos_ldap.ldif 2> slapadd.log
fi
#ログファイルに書き込まれている場合は失敗とみなす。
if [ 0 -ne `cat slapadd.log  | wc -l` ] ; then
	echo "Error occurred. Please check ./slapadd.log ";
	exit 1;
else 
	rm -f ./slapadd.log
	exit 0;

fi

