/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.dao;

import com.clustercontrol.commons.util.ConnectionManager;
import com.clustercontrol.jobmanagement.dao.JobFileMasterDAO;
import com.clustercontrol.jobmanagement.ejb.entity.JobFileMasterBean;
import com.clustercontrol.jobmanagement.ejb.entity.JobFileMasterPK;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JobFileMasterDAOImpl
implements JobFileMasterDAO {
    protected static Log m_log = LogFactory.getLog(JobFileMasterDAOImpl.class);

    public void init() {
    }

    public void load(JobFileMasterPK pk, JobFileMasterBean ejb) throws EJBException {
        block13: {
            m_log.debug((Object)("load() start : " + pk.toString()));
            Connection conn = null;
            Statement stmt = null;
            ResultSet res = null;
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT * FROM cc_job_file_mst WHERE job_id = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, pk.getJob_id());
                res = stmt.executeQuery();
                if (res.next()) {
                    ejb.setCheck_flg(res.getInt("check_flg"));
                    ejb.setCompression_flg(res.getInt("compression_flg"));
                    ejb.setDest_directory(res.getString("dest_directory"));
                    ejb.setDest_facility_id(res.getString("dest_facility_id"));
                    ejb.setDest_work_dir(res.getString("dest_work_dir"));
                    ejb.setEffective_user(res.getString("effective_user"));
                    ejb.setJob_id(res.getString("job_id"));
                    ejb.setProcess_mode(res.getInt("process_mode"));
                    ejb.setSrc_facility_id(res.getString("src_facility_id"));
                    ejb.setSrc_file(res.getString("src_file"));
                    ejb.setSrc_work_dir(res.getString("src_work_dir"));
                    break block13;
                }
                String msg = "JobFileMaster data is not found.";
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + msg));
                throw new EJBException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (res != null) {
                        res.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e1) {
                    m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + e1.getMessage()));
                    throw new EJBException(e1.getMessage());
                }
            }
        }
        m_log.debug((Object)("load() end : " + pk.toString()));
    }

    public void store(JobFileMasterBean ejb) throws EJBException {
        m_log.debug((Object)("store() start : " + ejb.getJob_id()));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            StringBuilder sql = new StringBuilder();
            sql.append("UPDATE cc_job_file_mst SET ");
            sql.append("process_mode = ?, ");
            sql.append("src_facility_id = ?, ");
            sql.append("dest_facility_id = ?, ");
            sql.append("src_file = ?, ");
            sql.append("src_work_dir = ?, ");
            sql.append("dest_directory = ?, ");
            sql.append("dest_work_dir = ?, ");
            sql.append("compression_flg = ?, ");
            sql.append("check_flg = ?, ");
            sql.append("effective_user = ? ");
            sql.append("WHERE job_id = ?");
            stmt = conn.prepareStatement(sql.toString());
            stmt.setInt(1, ejb.getProcess_mode());
            stmt.setString(2, ejb.getSrc_facility_id());
            stmt.setString(3, ejb.getDest_facility_id());
            stmt.setString(4, ejb.getSrc_file());
            stmt.setString(5, ejb.getSrc_work_dir());
            stmt.setString(6, ejb.getDest_directory());
            stmt.setString(7, ejb.getDest_work_dir());
            stmt.setInt(8, ejb.getCompression_flg());
            stmt.setInt(9, ejb.getCheck_flg());
            stmt.setString(10, ejb.getEffective_user());
            stmt.setString(11, ejb.getJob_id());
            int row = stmt.executeUpdate();
            if (row != 1) {
                String msg = "result row is not 1";
                m_log.error((Object)("store() error : " + ejb.getJob_id() + " SQLException" + msg));
                throw new EJBException(msg);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("store() error : " + ejb.getJob_id() + " SQLException"));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("store() error : " + ejb.getJob_id() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("store() end : " + ejb.getJob_id()));
    }

    public void remove(JobFileMasterPK pk) throws RemoveException, EJBException {
        m_log.debug((Object)("remove() start : " + pk.toString()));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "DELETE FROM cc_job_file_mst WHERE job_id = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.getJob_id());
            int row = stmt.executeUpdate();
            if (row != 1) {
                String msg = "result row is not 1";
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException" + msg));
                throw new EJBException(msg);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("remove() end : " + pk.toString()));
    }

    public JobFileMasterPK create(JobFileMasterBean ejb) throws CreateException, EJBException {
        JobFileMasterPK pk;
        m_log.debug((Object)("create() start : " + ejb.getJob_id()));
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            StringBuilder sql = new StringBuilder();
            sql.append("INSERT INTO cc_job_file_mst (");
            sql.append("job_id, ");
            sql.append("process_mode, ");
            sql.append("src_facility_id, ");
            sql.append("dest_facility_id, ");
            sql.append("src_file, ");
            sql.append("src_work_dir, ");
            sql.append("dest_directory, ");
            sql.append("dest_work_dir, ");
            sql.append("compression_flg, ");
            sql.append("check_flg, ");
            sql.append("effective_user) ");
            sql.append("VALUES (?,?,?,?,?,?,?,?,?,?,?)");
            stmt = conn.prepareStatement(sql.toString());
            stmt.setString(1, ejb.getJob_id());
            stmt.setInt(2, ejb.getProcess_mode());
            stmt.setString(3, ejb.getSrc_facility_id());
            stmt.setString(4, ejb.getDest_facility_id());
            stmt.setString(5, ejb.getSrc_file());
            stmt.setString(6, ejb.getSrc_work_dir());
            stmt.setString(7, ejb.getDest_directory());
            stmt.setString(8, ejb.getDest_work_dir());
            stmt.setInt(9, ejb.getCompression_flg());
            stmt.setInt(10, ejb.getCheck_flg());
            stmt.setString(11, ejb.getEffective_user());
            int row = stmt.executeUpdate();
            pk = new JobFileMasterPK(ejb.getJob_id());
            if (row != 1) {
                String msg = "result row is not 1";
                m_log.error((Object)("create() error : " + ejb.getJob_id() + " SQLException"));
                throw new EJBException(msg);
            }
        }
        catch (SQLException e) {
            if (e.getSQLState().equals("23505")) {
                m_log.error((Object)("create() error : " + ejb.getJob_id() + " SQLException" + "DuplicateKeyException "));
                throw new DuplicateKeyException(e.getMessage());
            }
            throw new CreateException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("create() error : " + ejb.getJob_id() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)("create() end : " + ejb.getJob_id()));
        return pk;
    }

    public Collection findAll() throws FinderException {
        m_log.debug((Object)"findAll() start : ");
        ArrayList<JobFileMasterPK> ret = new ArrayList<JobFileMasterPK>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_job_file_mst";
            stmt = conn.prepareStatement(sql);
            res = stmt.executeQuery();
            while (res.next()) {
                JobFileMasterPK pk = new JobFileMasterPK(res.getString("job_id"));
                ret.add(pk);
            }
        }
        catch (SQLException e) {
            m_log.error((Object)"findAll() error :  SQLException");
            throw new EJBException(e.getMessage());
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)"findAll() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        m_log.debug((Object)"findAll() end : ");
        return ret;
    }

    public JobFileMasterPK findByPrimaryKey(JobFileMasterPK pk) throws FinderException {
        ResultSet res;
        PreparedStatement stmt;
        Connection conn;
        block14: {
            m_log.debug((Object)("findByPrimaryKey() start : " + pk.toString()));
            conn = null;
            stmt = null;
            res = null;
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_job_file_mst WHERE job_id = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.getJob_id());
            res = stmt.executeQuery();
            if (!res.next()) break block14;
            JobFileMasterPK jobFileMasterPK = pk;
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            return jobFileMasterPK;
        }
        try {
            try {
                String msg = "id " + pk.toString() + " not found.";
                throw new FinderException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            throw throwable;
        }
    }
}

