/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.agent;

import com.clustercontrol.agent.AgentThread;
import com.clustercontrol.agent.SendQueue;
import com.clustercontrol.agent.util.RunHistoryUtil;
import com.clustercontrol.jobmanagement.message.RunInstructionInfo;
import com.clustercontrol.jobmanagement.message.RunResultInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileListThread
extends AgentThread {
    private static Log log = LogFactory.getLog(FileListThread.class);

    public FileListThread(RunInstructionInfo info, SendQueue sendQueue, Hashtable<String, Date> runHistory, Properties props) {
        super(info, sendQueue, runHistory, props);
    }

    @Override
    public void run() {
        log.debug((Object)"run start");
        Date startDate = new Date();
        RunHistoryUtil.addRunHistory(this.m_info, this.m_runHistory, startDate);
        RunResultInfo info = new RunResultInfo();
        info.setSessionId(this.m_info.getSessionId());
        info.setJobId(this.m_info.getJobId());
        info.setFacilityId(this.m_info.getFacilityId());
        info.setCommand(this.m_info.getCommand());
        info.setCommandType(this.m_info.getCommandType());
        info.setStatus(0);
        info.setTime(startDate);
        log.info((Object)("run SessionID=" + this.m_info.getSessionId() + ", JobID=" + this.m_info.getJobId()));
        this.m_sendQueue.put(info);
        List<String> fileList = this.getFileList(this.m_info.getFilePath());
        if (fileList != null && fileList.size() > 0) {
            info.setStatus(1);
            info.setFileList(fileList);
            info.setTime(new Date());
            info.setErrorMessage("");
            info.setMessage("");
            info.setEndValue(0);
        } else if (fileList != null) {
            info.setStatus(1);
            info.setTime(new Date());
            info.setErrorMessage("");
            info.setMessage("");
            info.setEndValue(1);
        } else {
            info.setStatus(1);
            info.setTime(new Date());
            info.setErrorMessage("");
            info.setMessage("");
            info.setEndValue(-1);
        }
        this.m_sendQueue.put(info);
        this.sendDeleteHistory(info);
        log.debug((Object)"run end");
    }

    public synchronized List<String> getFileList(String path) {
        log.debug((Object)"get file list start");
        ArrayList<String> fileList = new ArrayList<String>();
        try {
            String dir = path.substring(0, path.lastIndexOf("/") + 1);
            String fileName = path.substring(path.lastIndexOf("/") + 1);
            fileName = fileName.replaceAll("[.]", "[.]");
            fileName = fileName.replaceAll("[*]", ".*");
            if (fileName.length() == 0) {
                fileName = ".*";
            }
            File fi = new File(dir);
            File[] files = fi.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isFile() || files[i].isHidden() || !files[i].getName().matches(fileName)) continue;
                fileList.add(files[i].getCanonicalPath());
            }
        }
        catch (Exception e) {
            fileList = null;
        }
        log.debug((Object)"get file list end");
        return fileList;
    }
}

