/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.util;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.monitor.message.LogOutputInfo;
import com.clustercontrol.util.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class SendMail {
    private static final String SUBJECT_DATE_FORMAT = "MM/dd HH:mm";
    private static String FROM_ADDRESS = null;
    private static String FROM_PERSONAL_NAME = null;
    private static String REPLY_TO_ADDRESS = null;
    private static String REPLY_TO_PERSONAL_NAME = null;
    private static String ERRORS_TO_ADDRESS = null;
    private Locale m_local = Locale.getDefault();

    public boolean sendMail(String[] address, LogOutputInfo source, Date timeStamp) throws NamingException, MessagingException, UnsupportedEncodingException {
        if (address == null || address.length <= 0) {
            return false;
        }
        InitialContext initialContext = null;
        try {
            InternetAddress[] toAddress;
            InternetAddress[] reply;
            initialContext = new InitialContext();
            Session session = (Session)initialContext.lookup("java:/Mail");
            MimeMessage mes = new MimeMessage(session);
            if (FROM_ADDRESS != null && FROM_PERSONAL_NAME != null) {
                mes.setFrom((Address)new InternetAddress(FROM_ADDRESS, FROM_PERSONAL_NAME, "iso-2022-jp"));
            } else if (FROM_ADDRESS != null && FROM_PERSONAL_NAME == null) {
                mes.setFrom((Address)new InternetAddress(FROM_ADDRESS));
            }
            if (REPLY_TO_ADDRESS != null && REPLY_TO_PERSONAL_NAME != null) {
                reply = new InternetAddress[]{new InternetAddress(REPLY_TO_ADDRESS, REPLY_TO_PERSONAL_NAME, "iso-2022-jp")};
                mes.setReplyTo((Address[])reply);
                mes.reply(true);
            } else if (REPLY_TO_ADDRESS != null && REPLY_TO_PERSONAL_NAME == null) {
                reply = new InternetAddress[]{new InternetAddress(REPLY_TO_ADDRESS)};
                mes.setReplyTo((Address[])reply);
                mes.reply(true);
            }
            if (ERRORS_TO_ADDRESS != null) {
                mes.setHeader("Errors-To", ERRORS_TO_ADDRESS);
            }
            if ((toAddress = this.getAddress(address)) == null || toAddress.length <= 0) {
                return false;
            }
            mes.setRecipients(Message.RecipientType.TO, (Address[])toAddress);
            mes.setSubject(MimeUtility.encodeText((String)this.getSubject(source), (String)"iso-2022-jp", (String)"B"));
            mes.setContent((Object)this.getText(source), "text/plain; charset=iso-2022-jp");
            mes.setSentDate(this.getSentDate(timeStamp));
            Transport.send((Message)mes);
            return true;
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (MessagingException me) {
            throw me;
        }
        catch (UnsupportedEncodingException uee) {
            throw uee;
        }
    }

    private InternetAddress[] getAddress(String[] address) {
        Object[] toAddress = null;
        Vector<InternetAddress> list = new Vector<InternetAddress>();
        if (address != null) {
            for (int index = 0; index < address.length; ++index) {
                try {
                    list.add(new InternetAddress(address[index]));
                    continue;
                }
                catch (AddressException ae) {
                    // empty catch block
                }
            }
            if (list.size() > 0) {
                toAddress = new InternetAddress[list.size()];
                list.copyInto(toAddress);
            }
        }
        return toAddress;
    }

    private String getSubject(LogOutputInfo source) {
        String subject = null;
        if (source instanceof LogOutputInfo) {
            subject = Messages.getString((String)"mail.subject", (Locale)this.m_local) + "(" + PriorityConstant.typeToString((int)source.getPriority()) + ")";
        }
        return subject;
    }

    private String getText(LogOutputInfo source) {
        StringBuffer buf = new StringBuffer();
        SimpleDateFormat sdf = new SimpleDateFormat(SUBJECT_DATE_FORMAT);
        LogOutputInfo message = source;
        buf.append(Messages.getString((String)"generation.time", (Locale)this.m_local) + " : " + sdf.format(message.getGenerationDate()) + "\n");
        buf.append(Messages.getString((String)"application", (Locale)this.m_local) + " : " + message.getApplication() + "\n");
        buf.append(Messages.getString((String)"priority", (Locale)this.m_local) + " : " + PriorityConstant.typeToString((int)message.getPriority()) + "\n");
        buf.append(Messages.getString((String)"message", (Locale)this.m_local) + " : " + message.getMessage() + "\n");
        buf.append(Messages.getString((String)"scope", (Locale)this.m_local) + " : " + message.getScopeText() + "\n");
        return buf.toString();
    }

    private Date getSentDate(Date timeStamp) {
        if (timeStamp == null) {
            timeStamp = new Date();
        }
        return timeStamp;
    }

    static {
        Properties properties = new Properties();
        try {
            String homedir = System.getProperty("jboss.server.home.dir");
            String propertyFile = homedir + File.separator + "conf" + File.separator + "mail.properties";
            properties.load(new FileInputStream(propertyFile));
            FROM_ADDRESS = properties.getProperty("from.address");
            FROM_PERSONAL_NAME = properties.getProperty("from.personal.name");
            REPLY_TO_ADDRESS = properties.getProperty("reply.to.address");
            REPLY_TO_PERSONAL_NAME = properties.getProperty("reply.personal.name");
            ERRORS_TO_ADDRESS = properties.getProperty("errors.to.address");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

