/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.util;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class ObjectNameConverter {
    public static ObjectName convert(String pObjectName) throws MalformedObjectNameException {
        int lIndex;
        if (pObjectName == null) {
            throw new MalformedObjectNameException("null name");
        }
        if (pObjectName.length() == 0) {
            pObjectName = "*:*";
        }
        if ((lIndex = pObjectName.indexOf(":")) < 0) {
            throw new MalformedObjectNameException("missing domain");
        }
        String lDomain = pObjectName.substring(0, lIndex);
        if (lIndex + 1 < pObjectName.length()) {
            return ObjectNameConverter.createObjectName(lDomain, pObjectName.substring(lIndex + 1));
        }
        throw new MalformedObjectNameException("properties missing");
    }

    public static ObjectName convert(String pDomainName, Hashtable pProperties) throws MalformedObjectNameException {
        if (pDomainName == null) {
            throw new MalformedObjectNameException("missing domain");
        }
        if (pProperties == null || pProperties.size() == 0) {
            throw new MalformedObjectNameException(" null or empty properties");
        }
        return ObjectNameConverter.createObjectName(pDomainName, pProperties, false);
    }

    public static Hashtable getProperties(ObjectName pObjectName) {
        Hashtable lReturn = ObjectNameConverter.reverseProperties(pObjectName.getKeyPropertyList());
        if (pObjectName.isPropertyPattern()) {
            lReturn.put("*", "*");
        }
        return lReturn;
    }

    public static String getString(ObjectName pObjectName) {
        String lReturn = pObjectName.getDomain() + ":" + ObjectNameConverter.reverseString(pObjectName.getKeyPropertyList());
        if (pObjectName.isPropertyPattern()) {
            lReturn = lReturn + ",*";
        }
        return lReturn;
    }

    public static String convertCharacters(String pValue, boolean pEncrypt) {
        String lReturn = pValue;
        if (pEncrypt) {
            int lIndex = lReturn.indexOf("%");
            while (lIndex >= 0) {
                lReturn = (lIndex > 0 ? lReturn.substring(0, lIndex) : "") + "%25" + (lIndex + 1 < lReturn.length() ? lReturn.substring(lIndex + 1) : "");
                lIndex = lReturn.indexOf("%", lIndex + 2);
            }
            lIndex = lReturn.indexOf("*");
            while (lIndex >= 0) {
                lReturn = (lIndex > 0 ? lReturn.substring(0, lIndex) : "") + "%2a" + (lIndex + 1 < lReturn.length() ? lReturn.substring(lIndex + 1) : "");
                lIndex = lReturn.indexOf("*");
            }
            lIndex = lReturn.indexOf(":");
            while (lIndex >= 0) {
                lReturn = (lIndex > 0 ? lReturn.substring(0, lIndex) : "") + "%3a" + (lIndex + 1 < lReturn.length() ? lReturn.substring(lIndex + 1) : "");
                lIndex = lReturn.indexOf(":");
            }
            lIndex = lReturn.indexOf("?");
            while (lIndex >= 0) {
                lReturn = (lIndex > 0 ? lReturn.substring(0, lIndex) : "") + "%3f" + (lIndex + 1 < lReturn.length() ? lReturn.substring(lIndex + 1) : "");
                lIndex = lReturn.indexOf("?");
            }
            lIndex = lReturn.indexOf("=");
            while (lIndex >= 0) {
                lReturn = (lIndex > 0 ? lReturn.substring(0, lIndex) : "") + "%3d" + (lIndex + 1 < lReturn.length() ? lReturn.substring(lIndex + 1) : "");
                lIndex = lReturn.indexOf("=");
            }
            lIndex = lReturn.indexOf(",");
            while (lIndex >= 0) {
                lReturn = (lIndex > 0 ? lReturn.substring(0, lIndex) : "") + "%2c" + (lIndex + 1 < lReturn.length() ? lReturn.substring(lIndex + 1) : "");
                lIndex = lReturn.indexOf(",");
            }
        } else {
            int lIndex = lReturn.indexOf("%2a");
            while (lIndex >= 0) {
                lReturn = (lIndex > 0 ? lReturn.substring(0, lIndex) : "") + "*" + (lIndex + 3 < lReturn.length() ? lReturn.substring(lIndex + 3) : "");
                lIndex = lReturn.indexOf("%2a");
            }
            lIndex = lReturn.indexOf("%3a");
            while (lIndex >= 0) {
                lReturn = (lIndex > 0 ? lReturn.substring(0, lIndex) : "") + ":" + (lIndex + 3 < lReturn.length() ? lReturn.substring(lIndex + 3) : "");
                lIndex = lReturn.indexOf("%3a");
            }
            lIndex = lReturn.indexOf("%3f");
            while (lIndex >= 0) {
                lReturn = (lIndex > 0 ? lReturn.substring(0, lIndex) : "") + "?" + (lIndex + 3 < lReturn.length() ? lReturn.substring(lIndex + 3) : "");
                lIndex = lReturn.indexOf("%3f");
            }
            lIndex = lReturn.indexOf("%3d");
            while (lIndex >= 0) {
                lReturn = (lIndex > 0 ? lReturn.substring(0, lIndex) : "") + "=" + (lIndex + 3 < lReturn.length() ? lReturn.substring(lIndex + 3) : "");
                lIndex = lReturn.indexOf("%3d");
            }
            lIndex = lReturn.indexOf("%2c");
            while (lIndex >= 0) {
                lReturn = (lIndex > 0 ? lReturn.substring(0, lIndex) : "") + "," + (lIndex + 3 < lReturn.length() ? lReturn.substring(lIndex + 3) : "");
                lIndex = lReturn.indexOf("%2c");
            }
            lIndex = lReturn.indexOf("%25");
            while (lIndex >= 0) {
                lReturn = (lIndex > 0 ? lReturn.substring(0, lIndex) : "") + "%" + (lIndex + 3 < lReturn.length() ? lReturn.substring(lIndex + 3) : "");
                lIndex = lReturn.indexOf("%25");
            }
        }
        return lReturn;
    }

    private static ObjectName createObjectName(String domain, String properties) throws MalformedObjectNameException {
        if (null == properties || properties.length() < 1) {
            throw new MalformedObjectNameException("null or empty properties");
        }
        if (properties.startsWith(",") || properties.endsWith(",") || properties.indexOf(",,") != -1) {
            throw new MalformedObjectNameException("empty key/value pair in properties string");
        }
        Hashtable<String, String> ptable = new Hashtable<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(properties, ",");
        boolean lPattern = false;
        while (tokenizer.hasMoreTokens()) {
            String chunk = tokenizer.nextToken();
            if (chunk.equals("*")) {
                lPattern = true;
                continue;
            }
            int keylen = chunk.length();
            int eqpos = chunk.indexOf(61);
            if (eqpos < 1 || keylen == eqpos + 1) {
                throw new MalformedObjectNameException("malformed key/value pair: " + chunk);
            }
            String key = chunk.substring(0, eqpos);
            if (ptable.containsKey(key)) {
                throw new MalformedObjectNameException("duplicate key: " + key);
            }
            ptable.put(key, chunk.substring(eqpos + 1, keylen));
        }
        return ObjectNameConverter.createObjectName(domain, ptable, lPattern);
    }

    private static ObjectName createObjectName(String domain, Hashtable properties, boolean pPattern) throws MalformedObjectNameException {
        if (null == properties || !pPattern && properties.size() < 1) {
            throw new MalformedObjectNameException("null or empty properties");
        }
        Iterator it = properties.keySet().iterator();
        Hashtable<String, String> lReturn = new Hashtable<String, String>(properties.size());
        while (it.hasNext()) {
            String key = null;
            try {
                key = (String)it.next();
            }
            catch (ClassCastException e) {
                throw new MalformedObjectNameException("key is not a string");
            }
            String val = null;
            try {
                val = (String)properties.get(key);
            }
            catch (ClassCastException e) {
                throw new MalformedObjectNameException("value is not a string");
            }
            String lKey = ObjectNameConverter.convertCharacters(key, true);
            String lValue = ObjectNameConverter.convertCharacters(val, true);
            lReturn.put(lKey, lValue);
        }
        ObjectName result = new ObjectName(domain, lReturn);
        if (pPattern) {
            return new ObjectName(result.getCanonicalName() + ",*");
        }
        return result;
    }

    private static Hashtable reverseProperties(Hashtable pProperties) {
        Hashtable<String, String> lReturn = new Hashtable<String, String>(pProperties.size());
        Iterator i = pProperties.keySet().iterator();
        while (i.hasNext()) {
            String lKey = (String)i.next();
            String lValue = (String)pProperties.get(lKey);
            lKey = ObjectNameConverter.convertCharacters(lKey, false);
            lValue = ObjectNameConverter.convertCharacters(lValue, false);
            lReturn.put(lKey, lValue);
        }
        return lReturn;
    }

    private static String reverseString(Hashtable pProperties) {
        StringBuffer lReturn = new StringBuffer();
        Iterator i = pProperties.keySet().iterator();
        while (i.hasNext()) {
            String lKey = (String)i.next();
            String lValue = (String)pProperties.get(lKey);
            lKey = ObjectNameConverter.convertCharacters(lKey, false);
            lValue = ObjectNameConverter.convertCharacters(lValue, false);
            if (lReturn.length() > 0) {
                lReturn.append(",");
            }
            lReturn.append(lKey);
            lReturn.append("=");
            lReturn.append(lValue);
        }
        return lReturn.toString();
    }
}

