/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.multiplex;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import javax.net.ServerSocketFactory;
import org.jboss.remoting.transport.multiplex.MultiPortVirtualServerSocket;
import org.jboss.remoting.transport.multiplex.MultiplexingManager;
import org.jboss.remoting.transport.multiplex.SinglePortVirtualServerSocket;

public class VirtualServerSocketFactory
extends ServerSocketFactory {
    public static ServerSocketFactory getDefault() {
        return new VirtualServerSocketFactory();
    }

    protected VirtualServerSocketFactory() {
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        if (MultiplexingManager.isOnClient()) {
            return new SinglePortVirtualServerSocket(port);
        }
        return new MultiPortVirtualServerSocket(port);
    }

    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        throw new SocketException("method not implemented");
    }

    public ServerSocket createServerSocket(int port, int backlog, InetAddress address) throws IOException {
        if (MultiplexingManager.isOnClient()) {
            throw new SocketException("method not implemented");
        }
        return new MultiPortVirtualServerSocket(port, backlog, address);
    }
}

