/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.socket;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import org.jboss.logging.Logger;
import org.jboss.remoting.transport.socket.ClientSocketWrapper;

public class ServerSocketWrapper
extends ClientSocketWrapper {
    private static final Logger log = Logger.getLogger(class$org$jboss$remoting$transport$socket$ServerSocketWrapper == null ? (class$org$jboss$remoting$transport$socket$ServerSocketWrapper = ServerSocketWrapper.class$("org.jboss.remoting.transport.socket.ServerSocketWrapper")) : class$org$jboss$remoting$transport$socket$ServerSocketWrapper);
    static /* synthetic */ Class class$org$jboss$remoting$transport$socket$ServerSocketWrapper;

    public ServerSocketWrapper(Socket socket) throws Exception {
        super(socket);
    }

    protected ObjectInputStream createInputStream(Socket socket) throws IOException {
        BufferedInputStream bin = new BufferedInputStream(socket.getInputStream());
        ObjectInputStream oin = new ObjectInputStream(bin);
        return oin;
    }

    protected ObjectOutputStream createOutputStream(Socket socket) throws IOException {
        BufferedOutputStream bout = new BufferedOutputStream(socket.getOutputStream());
        ObjectOutputStream oout = new ObjectOutputStream(bout);
        oout.flush();
        return oout;
    }

    public void checkConnection() throws IOException {
        byte ACK = 0;
        long startWait = System.currentTimeMillis();
        try {
            ACK = ((ObjectInputStream)this.getInputStream()).readByte();
        }
        catch (EOFException eof) {
            if (log.isTraceEnabled()) {
                log.trace("socket timeout is set to : " + this.getTimeout());
                log.trace("EOFException waiting on ACK in readByte(). Time waited was " + (System.currentTimeMillis() - startWait));
            }
            throw eof;
        }
        catch (IOException e) {
            log.trace("IOException when reading in ACK", e);
            throw e;
        }
        if (log.isTraceEnabled()) {
            log.trace("***acknowledge read byte" + Thread.currentThread());
        }
        ObjectOutputStream out = (ObjectOutputStream)this.getOutputStream();
        out.writeByte(ACK);
        out.flush();
        out.reset();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

