/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.proxy.container;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.ClassContainer;
import org.jboss.aop.introduction.InterfaceIntroduction;
import org.jboss.aop.proxy.container.InstanceProxyContainer;
import org.jboss.aop.proxy.container.ProxyAdvisorDomain;
import org.jboss.aop.util.ConstructorComparator;
import org.jboss.aop.util.MethodHashing;

public class ClassProxyContainer
extends ClassContainer {
    public ClassProxyContainer(String name, AspectManager manager) {
        super(name, manager);
    }

    protected void createConstructorTables() {
        Class superClass = this.clazz.getSuperclass();
        if (superClass != null) {
            this.constructors = this.clazz.getSuperclass().getDeclaredConstructors();
            for (int i = 0; i < this.constructors.length; ++i) {
                this.constructors[i].setAccessible(true);
            }
            Arrays.sort(this.constructors, ConstructorComparator.INSTANCE);
        }
    }

    protected void createMethodMap() {
        try {
            int i;
            Method[] declaredMethods = this.clazz.getMethods();
            Class superclass = this.clazz.getSuperclass();
            for (i = 0; i < declaredMethods.length; ++i) {
                Method method = declaredMethods[i];
                if (!ClassAdvisor.isAdvisable(method)) continue;
                long hash = MethodHashing.methodHash(method);
                try {
                    if (method.getDeclaringClass().getName().indexOf("AOPContainerProxy$") >= 0 && superclass != null) {
                        method = superclass.getMethod(method.getName(), method.getParameterTypes());
                    }
                }
                catch (NoSuchMethodException ignored) {
                    // empty catch block
                }
                this.advisedMethods.put(hash, (Object)method);
            }
            for (i = 0; i < this.interfaceIntroductions.size(); ++i) {
                InterfaceIntroduction ii = (InterfaceIntroduction)this.interfaceIntroductions.get(i);
                String[] intf = ii.getInterfaces();
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                for (int j = 0; j < intf.length; ++j) {
                    Class<?> iface = cl.loadClass(intf[j]);
                    Method[] ifaceMethods = iface.getMethods();
                    for (int k = 0; k < ifaceMethods.length; ++k) {
                        long hash = MethodHashing.methodHash(ifaceMethods[k]);
                        if (this.advisedMethods.get(hash) != null) continue;
                        this.advisedMethods.put(hash, (Object)ifaceMethods[k]);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public InstanceProxyContainer createInstanceProxyContainer(InterfaceIntroduction introduction) {
        ProxyAdvisorDomain domain = new ProxyAdvisorDomain(this.manager, this.clazz, false);
        domain.setInheritsBindings(true);
        domain.setInheritsDeclarations(true);
        if (introduction != null) {
            domain.addInterfaceIntroduction(introduction);
        }
        InstanceProxyContainer ia = new InstanceProxyContainer(super.getName(), domain, this);
        return ia;
    }

    public InstanceProxyContainer createInstanceProxyContainer() {
        return this.createInstanceProxyContainer(null);
    }

    public void initialise(Class proxiedClass) {
        this.setClass(proxiedClass);
        ((ProxyAdvisorDomain)this.manager).attachAdvisor();
        this.initializeInterfaceIntroductions(proxiedClass);
        super.initializeClassContainer();
    }

    public boolean chainOverridingForInheritedMethods() {
        return true;
    }
}

