/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.logagent;

import com.clustercontrol.bean.OutputNotifyGroupInfo;
import com.clustercontrol.logagent.Agent;
import java.io.Serializable;
import java.util.Properties;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.InitialContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SendQueue
implements ExceptionListener {
    private static final String QUEUE_CON_FACTORY = "ConnectionFactory";
    private static final String QUEUE_USER_NAME = "queue.user.name";
    private static final String QUEUE_USER_PASSWORD = "queue.user.password";
    private Agent m_agent;
    private Properties m_props;
    private QueueConnection m_con;
    private Queue m_queueLog;
    private Queue m_queueFacility;
    private QueueSession m_session;
    private QueueConnectionFactory m_factory;
    private boolean m_isErr = false;
    private long m_interval = 10000L;
    private static Log log = LogFactory.getLog(SendQueue.class);

    public SendQueue(Agent agent, Properties props) {
        this.m_agent = agent;
        this.m_props = props;
        String interval = this.m_props.getProperty("receivetopic.reconnection.interval");
        if (interval != null) {
            try {
                this.m_interval = Integer.parseInt(interval) * 1000;
            }
            catch (NumberFormatException e) {
                log.error((Object)"receivetopic.reconnection.interval", (Throwable)e);
            }
        }
        this.initial();
    }

    private synchronized boolean reInitial() {
        boolean ret = false;
        log.info((Object)"\u518d\u63a5\u7d9a\u51e6\u7406!");
        this.terminate();
        if (this.initial()) {
            ret = true;
            log.info((Object)"\u518d\u63a5\u7d9a\u51e6\u7406:\u6210\u529f!");
            this.m_isErr = false;
        } else {
            log.info((Object)"\u518d\u63a5\u7d9a\u51e6\u7406:\u5931\u6557!");
        }
        return ret;
    }

    public void terminate() {
        try {
            if (this.m_session != null) {
                this.m_session.close();
            }
        }
        catch (JMSException e) {
            // empty catch block
        }
        try {
            if (this.m_con != null) {
                this.m_con.close();
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean put(Object info) {
        if (this.m_isErr) {
            this.reInitial();
        }
        QueueSender sender = null;
        ObjectMessage mess = null;
        while (true) {
            boolean loginfo2;
            try {
                if (info instanceof OutputNotifyGroupInfo) {
                    sender = this.m_session.createSender(this.m_queueLog);
                    mess = this.m_session.createObjectMessage((Serializable)((OutputNotifyGroupInfo)info));
                    if (log.isDebugEnabled()) {
                        OutputNotifyGroupInfo loginfo2 = (OutputNotifyGroupInfo)info;
                        log.debug((Object)("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u30e1\u30c3\u30bb\u30fc\u30b8\u9001\u4fe1! : Facility ID : " + loginfo2.getFacilityId() + ", " + "Monitor ID : " + loginfo2.getMonitorId() + ", " + "Priority : " + loginfo2.getPriority() + ", " + "Message ID : " + loginfo2.getMessageId() + ", " + "Message : " + loginfo2.getMessage()));
                    }
                } else if (info instanceof String) {
                    sender = this.m_session.createSender(this.m_queueFacility);
                    mess = this.m_session.createTextMessage((String)info);
                    log.debug((Object)("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u30e1\u30c3\u30bb\u30fc\u30b8\u9001\u4fe1! : notify Fasility ID : " + info));
                } else {
                    boolean loginfo2 = false;
                    return loginfo2;
                }
                sender.send((Message)mess);
                loginfo2 = true;
            }
            catch (JMSException e) {
                log.error((Object)e);
                log.info((Object)"\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u30e1\u30c3\u30bb\u30fc\u30b8\u9001\u4fe1\u30ea\u30c8\u30e9\u30a4");
                try {
                    this.wait(this.m_interval);
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
                if (this.reInitial()) continue;
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (sender == null) continue;
                    sender.close();
                }
                catch (Exception e1) {}
                continue;
            }
            return loginfo2;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initial() {
        log.info((Object)"EJB\u63a5\u7d9a\u521d\u671f\u5316");
        InitialContext con = null;
        try {
            con = new InitialContext(this.m_props);
            this.m_factory = (QueueConnectionFactory)con.lookup(QUEUE_CON_FACTORY);
            this.m_con = this.m_props.getProperty(QUEUE_USER_NAME) != null ? this.m_factory.createQueueConnection(this.m_props.getProperty(QUEUE_USER_NAME), this.m_props.getProperty(QUEUE_USER_PASSWORD)) : this.m_factory.createQueueConnection();
            this.m_session = this.m_con.createQueueSession(false, 1);
            this.m_con.setExceptionListener((ExceptionListener)this);
            this.m_con.start();
            this.m_queueLog = (Queue)con.lookup("queue/clustercontrolNotifyEvent");
            this.m_queueFacility = (Queue)con.lookup("queue/clustercontrolLogtransferLogTransferFileManage");
        }
        catch (Exception e) {
            log.error((Object)"Init", (Throwable)e);
            this.m_isErr = true;
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (Exception e1) {}
        }
        return true;
    }

    public void onException(JMSException arg0) {
        log.error((Object)arg0.getMessage(), (Throwable)arg0);
        this.m_agent.reConnection();
    }

    public synchronized void reconnect() {
        this.m_isErr = true;
        this.terminate();
    }
}

