/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.performance.util;

import com.clustercontrol.bean.FacilityInfo;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorScopeRelationData;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorScopeRelationLocal;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorScopeRelationUtil;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorScopeSnapLocal;
import com.clustercontrol.performance.monitor.ejb.entity.CollectorScopeSnapUtil;
import com.clustercontrol.performance.util.Repository;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacilityTreeDB {
    public void insertFacilityTree(String collectorID, FacilityTreeItem fItem) {
        this.insertFacilityTree(collectorID, fItem, null);
    }

    private void insertFacilityTree(String collectorId, FacilityTreeItem fItem, HashSet<String> writtenSet) {
        if (writtenSet == null) {
            writtenSet = new HashSet();
        }
        FacilityInfo fInfo = fItem.getData();
        FacilityTreeItem[] fArray = fItem.getChildren();
        CollectorScopeRelationData srData = new CollectorScopeRelationData();
        srData.setCollectorId(collectorId);
        if (fItem.getParent() != null) {
            srData.setParentFacilityId(fItem.getParent().getData().getFacilityId());
        } else {
            srData.setParentFacilityId("");
        }
        srData.setFacilityId(fInfo.getFacilityId());
        try {
            if (!writtenSet.contains(fInfo.getFacilityId())) {
                int typeInt = fItem.getData().getType();
                String typeStr = null;
                String platform = null;
                if (typeInt == 1) {
                    typeStr = "node";
                    platform = Repository.getPlatformId(fItem.getData().getFacilityId());
                } else if (typeInt == 0) {
                    typeStr = "scope";
                    platform = "SCOPE";
                } else {
                    typeStr = "comp";
                    platform = "COMP";
                }
                CollectorScopeSnapUtil.getLocalHome().create(collectorId, fItem.getData().getFacilityId(), platform, fItem.getData().getFacilityName(), typeStr);
                writtenSet.add(fInfo.getFacilityId());
            }
            CollectorScopeRelationUtil.getLocalHome().create(collectorId, srData.getFacilityId(), srData.getParentFacilityId());
        }
        catch (CreateException e) {
            throw new EJBException((Exception)((Object)e));
        }
        catch (NamingException e) {
            throw new EJBException((Exception)e);
        }
        for (int i = 0; i < fArray.length; ++i) {
            this.insertFacilityTree(collectorId, fArray[i], writtenSet);
        }
    }

    public FacilityTreeItem getFacilityTree(String collectorId) {
        try {
            Hashtable<String, FacilityTreeItem> ht = new Hashtable<String, FacilityTreeItem>();
            HashMap<String, FacilityInfo> sncol = new HashMap<String, FacilityInfo>();
            Collection srcol = null;
            FacilityTreeItem currentItem = null;
            FacilityTreeItem parentItem = null;
            CollectorScopeRelationLocal srData2 = null;
            String current = null;
            String parent = null;
            Collection col = CollectorScopeSnapUtil.getLocalHome().findByCollectorId(collectorId);
            for (CollectorScopeSnapLocal bean : col) {
                FacilityInfo finfo = new FacilityInfo();
                finfo.setFacilityId(bean.getFacilityId());
                finfo.setFacilityName(bean.getFacilityName());
                finfo.setValid(true);
                String typeStr = bean.getFacilityType();
                int typeInt = 0;
                if (typeStr.equals("node")) {
                    typeInt = 1;
                } else if (typeStr.equals("scope")) {
                    typeInt = 0;
                } else if (typeStr.equals("comp")) {
                    typeInt = 2;
                }
                finfo.setType(typeInt);
                sncol.put(bean.getFacilityId(), finfo);
            }
            srcol = CollectorScopeRelationUtil.getLocalHome().findByCollectorId(collectorId);
            String topFacility = null;
            if (!sncol.isEmpty() && !srcol.isEmpty()) {
                for (CollectorScopeRelationLocal srData2 : srcol) {
                    current = srData2.getFacilityId();
                    parent = srData2.getParentFacilityId();
                    if (((FacilityInfo)sncol.get(current)).getType() != 2) {
                        if (ht.containsKey(parent)) {
                            parentItem = (FacilityTreeItem)ht.get(parent);
                        } else {
                            parentItem = new FacilityTreeItem((FacilityTreeItem)null, (FacilityInfo)sncol.get(parent));
                            ht.put(parent, parentItem);
                        }
                    } else {
                        parentItem = null;
                        topFacility = ((FacilityInfo)sncol.get(current)).getFacilityId();
                    }
                    if (ht.containsKey(current)) {
                        currentItem = (FacilityTreeItem)ht.get(current);
                        if (currentItem.getData().getType() == 1 && currentItem.getParent() != null) {
                            FacilityInfo info = new FacilityInfo();
                            info.setFacilityId(currentItem.getData().getFacilityId());
                            info.setFacilityName(currentItem.getData().getFacilityName());
                            info.setType(currentItem.getData().getType());
                            currentItem = new FacilityTreeItem(parentItem, info);
                            continue;
                        }
                        currentItem.setParent(parentItem);
                        parentItem.addChildren(currentItem);
                        continue;
                    }
                    currentItem = new FacilityTreeItem(parentItem, (FacilityInfo)sncol.get(current));
                    ht.put(current, currentItem);
                }
            }
            FacilityTreeItem top = (FacilityTreeItem)ht.get(topFacility);
            return top;
        }
        catch (NamingException e) {
        }
        catch (FinderException finderException) {
            // empty catch block
        }
        return null;
    }
}

