/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.monitor.dao;

import com.clustercontrol.commons.util.ConnectionManager;
import com.clustercontrol.notify.monitor.dao.EventLogDAO;
import com.clustercontrol.notify.monitor.ejb.entity.EventLogBean;
import com.clustercontrol.notify.monitor.ejb.entity.EventLogPK;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EventLogDAOImpl
implements EventLogDAO {
    protected static Log m_log = LogFactory.getLog(EventLogDAOImpl.class);

    public void init() {
    }

    public void load(EventLogPK pk, EventLogBean ejb) throws EJBException {
        block13: {
            m_log.debug((Object)("load() start : " + pk.toString()));
            Connection conn = null;
            Statement stmt = null;
            ResultSet res = null;
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT * FROM cc_event_log WHERE plugin_id = ? AND monitor_id = ? AND facility_id = ? AND output_date = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, pk.pluginId);
                stmt.setString(2, pk.monitorId);
                stmt.setString(3, pk.facilityId);
                stmt.setTimestamp(4, pk.outputDate);
                res = stmt.executeQuery();
                if (res.next()) {
                    ejb.setPluginId(res.getString("plugin_id"));
                    ejb.setMonitorId(res.getString("monitor_id"));
                    ejb.setFacilityId(res.getString("facility_id"));
                    ejb.setOutputDate(res.getTimestamp("output_date"));
                    ejb.setGenerationDate(res.getTimestamp("generation_date"));
                    ejb.setScopeText(res.getString("scope_text"));
                    ejb.setApplication(res.getString("application"));
                    ejb.setMessageId(res.getString("message_id"));
                    ejb.setMessage(res.getString("message"));
                    ejb.setMessageOrg(res.getString("message_org"));
                    ejb.setPriority(res.getInt("priority"));
                    ejb.setConfirmFlg(res.getInt("confirm_flg"));
                    ejb.setConfirmDate(res.getTimestamp("confirm_date"));
                    ejb.setConfirmUser(res.getString("confirm_user"));
                    ejb.setDuplicationCount(res.getInt("duplication_count"));
                    ejb.setInhibitedFlg(res.getInt("inhibited_flg"));
                    break block13;
                }
                String msg = "EventLog data is not found.";
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + msg));
                throw new EJBException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("load() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (res != null) {
                        res.close();
                    }
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e1) {
                    m_log.error((Object)("load() error : " + pk.toString() + " SQLException " + e1.getMessage()));
                    throw new EJBException(e1.getMessage());
                }
            }
        }
        m_log.debug((Object)("load() end : " + pk.toString()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void store(EventLogBean ejb) throws EJBException {
        m_log.debug((Object)("store() start : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", " + ejb.getOutputDate()));
        Connection conn = null;
        Statement stmt = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                StringBuilder sql = new StringBuilder();
                sql.append("UPDATE cc_event_log SET ");
                sql.append("generation_date = ?, ");
                sql.append("scope_text = ?, ");
                sql.append("application = ?, ");
                sql.append("message_id = ?, ");
                sql.append("message = ?, ");
                sql.append("message_org = ?, ");
                sql.append("priority = ?, ");
                sql.append("confirm_flg = ?, ");
                sql.append("confirm_date = ?, ");
                sql.append("confirm_user = ?, ");
                sql.append("duplication_count = ?, ");
                sql.append("inhibited_flg = ?");
                sql.append("WHERE plugin_id = ? AND ");
                sql.append("monitor_id = ? AND ");
                sql.append("facility_id = ? AND ");
                sql.append("output_date = ?");
                stmt = conn.prepareStatement(sql.toString());
                int count = 1;
                stmt.setTimestamp(count++, ejb.getGenerationDate());
                stmt.setString(count++, ejb.getScopeText());
                stmt.setString(count++, ejb.getApplication());
                stmt.setString(count++, ejb.getMessageId());
                stmt.setString(count++, ejb.getMessage());
                stmt.setString(count++, ejb.getMessageOrg());
                stmt.setInt(count++, ejb.getPriority());
                stmt.setInt(count++, ejb.getConfirmFlg());
                stmt.setTimestamp(count++, ejb.getConfirmDate());
                stmt.setString(count++, ejb.getConfirmUser());
                stmt.setInt(count++, ejb.getDuplicationCount());
                stmt.setInt(count++, ejb.getInhibitedFlg());
                stmt.setString(count++, ejb.getPluginId());
                stmt.setString(count++, ejb.getMonitorId());
                stmt.setString(count++, ejb.getFacilityId());
                stmt.setTimestamp(count++, ejb.getOutputDate());
                int row = stmt.executeUpdate();
                if (row != 1) {
                    String msg = "result row is not 1";
                    m_log.error((Object)("store() error : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", " + ejb.getOutputDate() + " SQLException" + msg));
                    throw new EJBException(msg);
                }
                Object var9_9 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("store() error : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", " + ejb.getOutputDate() + " SQLException"));
                e.printStackTrace();
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("store() error : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", " + ejb.getOutputDate() + " SQLException"));
                e1.printStackTrace();
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("store() error : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", " + ejb.getOutputDate() + " SQLException"));
            e1.printStackTrace();
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("store() end : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", " + ejb.getOutputDate()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(EventLogPK pk) throws RemoveException, EJBException {
        m_log.debug((Object)("remove() start : " + pk.toString()));
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "DELETE FROM cc_event_log WHERE plugin_id = ? AND monitor_id = ? AND facility_id = ? AND output_date = ?";
                stmt = conn.prepareStatement(sql);
                stmt.setString(1, pk.pluginId);
                stmt.setString(2, pk.monitorId);
                stmt.setString(3, pk.facilityId);
                stmt.setTimestamp(4, pk.outputDate);
                int row = stmt.executeUpdate();
                if (row != 1) {
                    String msg = "result row is not 1";
                    m_log.error((Object)("remove() error : " + pk.toString() + " SQLException" + msg));
                    throw new EJBException(msg);
                }
                Object var8_8 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("remove() error : " + pk.toString() + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("remove() end : " + pk.toString()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EventLogPK create(EventLogBean ejb) throws CreateException, EJBException {
        EventLogPK pk;
        m_log.debug((Object)("create() start : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", " + ejb.getOutputDate()));
        Connection conn = null;
        Statement stmt = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                StringBuilder sql = new StringBuilder();
                sql.append("INSERT INTO cc_event_log (");
                sql.append("plugin_id, ");
                sql.append("monitor_id, ");
                sql.append("facility_id, ");
                sql.append("output_date, ");
                sql.append("generation_date, ");
                sql.append("scope_text, ");
                sql.append("application, ");
                sql.append("message_id, ");
                sql.append("message, ");
                sql.append("message_org, ");
                sql.append("priority, ");
                sql.append("confirm_flg, ");
                sql.append("confirm_date, ");
                sql.append("confirm_user, ");
                sql.append("duplication_count, ");
                sql.append("inhibited_flg )");
                sql.append("values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                stmt = conn.prepareStatement(sql.toString());
                int count = 1;
                stmt.setString(count++, ejb.getPluginId());
                stmt.setString(count++, ejb.getMonitorId());
                stmt.setString(count++, ejb.getFacilityId());
                stmt.setTimestamp(count++, ejb.getOutputDate());
                stmt.setTimestamp(count++, ejb.getGenerationDate());
                stmt.setString(count++, ejb.getScopeText());
                stmt.setString(count++, ejb.getApplication());
                stmt.setString(count++, ejb.getMessageId());
                stmt.setString(count++, ejb.getMessage());
                stmt.setString(count++, ejb.getMessageOrg());
                stmt.setInt(count++, ejb.getPriority());
                stmt.setInt(count++, ejb.getConfirmFlg());
                stmt.setTimestamp(count++, ejb.getConfirmDate());
                stmt.setString(count++, ejb.getConfirmUser());
                stmt.setInt(count++, ejb.getDuplicationCount());
                stmt.setInt(count++, ejb.getInhibitedFlg());
                int row = stmt.executeUpdate();
                pk = new EventLogPK(ejb.getMonitorId(), ejb.getPluginId(), ejb.getFacilityId(), ejb.getOutputDate());
                if (row != 1) {
                    String msg = "result row is not 1";
                    m_log.error((Object)("create() error : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", " + ejb.getOutputDate() + " SQLException"));
                    throw new EJBException(msg);
                }
                Object var10_10 = null;
            }
            catch (SQLException e) {
                if (!e.getSQLState().equals("23505")) throw new CreateException(e.getMessage());
                m_log.info((Object)("create() error : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", " + ejb.getOutputDate() + " SQLException" + "DuplicateKeyException "));
                throw new DuplicateKeyException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)("create() error : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", " + ejb.getOutputDate() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)("create() error : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", " + ejb.getOutputDate() + " SQLException"));
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)("create() end : " + ejb.getPluginId() + ", " + ejb.getMonitorId() + ", " + ejb.getFacilityId() + ", " + ejb.getOutputDate()));
        return pk;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection findAll() throws FinderException {
        m_log.debug((Object)"findAll() start : ");
        ArrayList<EventLogPK> ret = new ArrayList<EventLogPK>();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                String sql = "SELECT * FROM cc_event_log";
                stmt = conn.prepareStatement(sql);
                res = stmt.executeQuery();
                while (res.next()) {
                    EventLogPK pk = new EventLogPK(res.getString("monitor_id"), res.getString("plugin_id"), res.getString("facility_id"), res.getTimestamp("output_date"));
                    ret.add(pk);
                }
                Object var8_8 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)"findAll() error :  SQLException");
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)"findAll() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)"findAll() error :  SQLException");
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (res != null) {
            res.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)"findAll() end : ");
        return ret;
    }

    public EventLogPK findByPrimaryKey(EventLogPK pk) throws FinderException {
        ResultSet res;
        PreparedStatement stmt;
        Connection conn;
        block14: {
            m_log.debug((Object)("findByPrimaryKey() start : " + pk.toString()));
            conn = null;
            stmt = null;
            res = null;
            conn = ConnectionManager.getConnectionManager().getConnection();
            String sql = "SELECT * FROM cc_event_log WHERE plugin_id = ? AND monitor_id = ? AND facility_id = ? AND output_date = ?";
            stmt = conn.prepareStatement(sql);
            stmt.setString(1, pk.pluginId);
            stmt.setString(2, pk.monitorId);
            stmt.setString(3, pk.facilityId);
            stmt.setTimestamp(4, pk.outputDate);
            res = stmt.executeQuery();
            if (!res.next()) break block14;
            EventLogPK eventLogPK = pk;
            Object var8_9 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            return eventLogPK;
        }
        try {
            try {
                String msg = "id " + pk.toString() + " not found.";
                throw new FinderException(msg);
            }
            catch (SQLException e) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e1) {
                m_log.error((Object)("find() error : " + pk.toString() + " SQLException"));
                throw new EJBException(e1.getMessage());
            }
            m_log.debug((Object)("findByPrimaryKey() end : " + pk.toString()));
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection findByGenerationDateOrder(String monitorId, String pluginId, String facilityId, Timestamp generationDate, Integer inhibitedFlg) throws FinderException {
        m_log.debug((Object)"findByGenerationDateOrder() start : ");
        ArrayList<EventLogPK> ret = new ArrayList<EventLogPK>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                StringBuilder sql = new StringBuilder();
                sql.append("SELECT * FROM cc_event_log ");
                sql.append("WHERE monitor_id = ? ");
                sql.append("AND plugin_id = ? ");
                sql.append("AND facility_id = ? ");
                sql.append("AND generation_date <= ? ");
                sql.append("AND inhibited_flg = ? ");
                sql.append("ORDER BY generation_date DESC, duplication_count LIMIT 1");
                stmt = conn.prepareStatement(sql.toString());
                stmt.setString(1, monitorId);
                stmt.setString(2, pluginId);
                stmt.setString(3, facilityId);
                stmt.setTimestamp(4, generationDate);
                stmt.setInt(5, inhibitedFlg);
                res = stmt.executeQuery();
                while (res.next()) {
                    EventLogPK pk = new EventLogPK(res.getString("monitor_id"), res.getString("plugin_id"), res.getString("facility_id"), res.getTimestamp("output_date"));
                    ret.add(pk);
                }
                Object var13_13 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)"findByGenerationDateOrder() error :  SQLException");
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)"findByGenerationDateOrder() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)"findByGenerationDateOrder() error :  SQLException");
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (res != null) {
            res.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)"findByGenerationDateOrder() end : ");
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection findByMessageOrg(String monitorId, String pluginId, String facilityId, Timestamp generationDate, String messageOrg) throws FinderException {
        m_log.debug((Object)"selectByMessageOrg() start : ");
        StringBuffer sqlWhere = new StringBuffer();
        sqlWhere.append(" plugin_id = ?");
        sqlWhere.append(" AND monitor_id = ?");
        sqlWhere.append(" AND facility_id = ?");
        sqlWhere.append(" AND generation_date = ?");
        if (messageOrg != null) {
            sqlWhere.append(" AND message_org = ?");
        } else {
            sqlWhere.append(" AND message_org is null ");
        }
        ArrayList<EventLogPK> ret = new ArrayList<EventLogPK>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT * FROM cc_event_log ");
                sql.append("WHERE " + sqlWhere.toString());
                sql.append(" ORDER BY output_date");
                stmt = conn.prepareStatement(sql.toString());
                stmt.setString(1, pluginId);
                stmt.setString(2, monitorId);
                stmt.setString(3, facilityId);
                stmt.setTimestamp(4, generationDate);
                if (messageOrg != null) {
                    stmt.setString(5, messageOrg);
                }
                res = stmt.executeQuery();
                while (res.next()) {
                    EventLogPK pk = new EventLogPK(res.getString("monitor_id"), res.getString("plugin_id"), res.getString("facility_id"), res.getTimestamp("output_date"));
                    ret.add(pk);
                }
                Object var14_14 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)"selectByMessageOrg() error :  SQLException");
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)"selectByMessageOrg() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)"selectByMessageOrg() error :  SQLException");
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (res != null) {
            res.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)"selectByMessageOrg() end : ");
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection findEvent(String[] facilityId, Integer priority, Timestamp outputFromDate, Timestamp outputToDate, Timestamp generationFromDate, Timestamp generationToDate, String application, String message, Integer confirmFlg, String confirmUser, boolean orderByFlg, Integer limit) throws FinderException {
        m_log.debug((Object)"selectEvent() start : ");
        StringBuffer sqlWhere = new StringBuffer();
        boolean whereFlg = false;
        if (facilityId != null && facilityId.length > 0) {
            sqlWhere.append("facility_id IN (");
            for (int index = 0; index < facilityId.length; ++index) {
                if (index != 0) {
                    sqlWhere.append(",");
                }
                sqlWhere.append("?");
            }
            sqlWhere.append(")");
            whereFlg = true;
        }
        if (priority != null) {
            sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " priority = ?");
            whereFlg = true;
        }
        if (outputFromDate != null) {
            sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " output_date >= ?");
            whereFlg = true;
        }
        if (outputToDate != null) {
            sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " output_date <= ?");
            whereFlg = true;
        }
        if (generationFromDate != null) {
            sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " generation_date >= ?");
            whereFlg = true;
        }
        if (generationToDate != null) {
            sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " generation_date <= ?");
            whereFlg = true;
        }
        if (application != null && !"".equals(application)) {
            sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " application like ?");
            whereFlg = true;
        }
        if (message != null && !"".equals(message)) {
            sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " message like ?");
            whereFlg = true;
        }
        if (confirmFlg != null) {
            sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " confirm_flg = ?");
            whereFlg = true;
        }
        if (confirmUser != null) {
            sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " confirm_user = ?");
            whereFlg = true;
        }
        ArrayList<EventLogPK> ret = new ArrayList<EventLogPK>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT * FROM cc_event_log ");
                if (sqlWhere.length() > 0) {
                    sql.append("WHERE " + sqlWhere.toString());
                }
                if (orderByFlg) {
                    sql.append(" ORDER BY output_date");
                } else {
                    sql.append(" ORDER BY output_date DESC");
                }
                if (limit != null) {
                    sql.append(" LIMIT " + limit.toString());
                }
                stmt = conn.prepareStatement(sql.toString());
                int count = 1;
                if (sqlWhere.length() > 0) {
                    if (facilityId != null && facilityId.length > 0) {
                        for (int index = 0; index < facilityId.length; ++count, ++index) {
                            stmt.setString(count, facilityId[index]);
                        }
                    }
                    if (priority != null) {
                        stmt.setInt(count, priority);
                        ++count;
                    }
                    if (outputFromDate != null) {
                        stmt.setTimestamp(count, outputFromDate);
                        ++count;
                    }
                    if (outputToDate != null) {
                        stmt.setTimestamp(count, outputToDate);
                        ++count;
                    }
                    if (generationFromDate != null) {
                        stmt.setTimestamp(count, generationFromDate);
                        ++count;
                    }
                    if (generationToDate != null) {
                        stmt.setTimestamp(count, generationToDate);
                        ++count;
                    }
                    if (application != null && !"".equals(application)) {
                        stmt.setString(count, "%" + application + "%");
                        ++count;
                    }
                    if (message != null && !"".equals(message)) {
                        stmt.setString(count, "%" + message + "%");
                        ++count;
                    }
                    if (confirmFlg != null) {
                        stmt.setInt(count, confirmFlg);
                        ++count;
                    }
                    if (confirmUser != null) {
                        stmt.setString(count, confirmUser);
                        ++count;
                    }
                }
                res = stmt.executeQuery();
                while (res.next()) {
                    EventLogPK pk = new EventLogPK(res.getString("monitor_id"), res.getString("plugin_id"), res.getString("facility_id"), res.getTimestamp("output_date"));
                    ret.add(pk);
                }
                Object var23_25 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)"selectEvent() error :  SQLException");
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var23_26 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)"selectEvent() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)"selectEvent() error :  SQLException");
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (res != null) {
            res.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)"selectEvent() end : ");
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int countEvent(String[] facilityId, Integer priority, Timestamp outputFromDate, Timestamp outputToDate, Timestamp generationFromDate, Timestamp generationToDate, String application, String message, Integer confirmFlg, String confirmUser) throws SQLException {
        m_log.debug((Object)"countEvent() start : ");
        StringBuffer sqlWhere = new StringBuffer();
        boolean whereFlg = false;
        int count = 0;
        if (facilityId != null && facilityId.length > 0) {
            sqlWhere.append("facility_id IN (");
            for (int index = 0; index < facilityId.length; ++index) {
                if (index != 0) {
                    sqlWhere.append(",");
                }
                sqlWhere.append("?");
            }
            sqlWhere.append(")");
            whereFlg = true;
        }
        if (priority != null) {
            sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " priority = ?");
            whereFlg = true;
        }
        if (outputFromDate != null) {
            sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " output_date >= ?");
            whereFlg = true;
        }
        if (outputToDate != null) {
            sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " output_date <= ?");
            whereFlg = true;
        }
        if (generationFromDate != null) {
            sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " generation_date >= ?");
            whereFlg = true;
        }
        if (generationToDate != null) {
            sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " generation_date <= ?");
            whereFlg = true;
        }
        if (application != null && !"".equals(application)) {
            sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " application like ?");
            whereFlg = true;
        }
        if (message != null && !"".equals(message)) {
            sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " message like ?");
            whereFlg = true;
        }
        if (confirmFlg != null) {
            sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " confirm_flg = ?");
            whereFlg = true;
        }
        if (confirmUser != null) {
            sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " confirm_user = ?");
            whereFlg = true;
        }
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT COUNT(*) FROM cc_event_log ");
                if (sqlWhere.length() > 0) {
                    sql.append("WHERE " + sqlWhere.toString());
                }
                stmt = conn.prepareStatement(sql.toString());
                int i = 1;
                if (sqlWhere.length() > 0) {
                    if (facilityId != null && facilityId.length > 0) {
                        for (int index = 0; index < facilityId.length; ++i, ++index) {
                            stmt.setString(i, facilityId[index]);
                        }
                    }
                    if (priority != null) {
                        stmt.setInt(i, priority);
                        ++i;
                    }
                    if (outputFromDate != null) {
                        stmt.setTimestamp(i, outputFromDate);
                        ++i;
                    }
                    if (outputToDate != null) {
                        stmt.setTimestamp(i, outputToDate);
                        ++i;
                    }
                    if (generationFromDate != null) {
                        stmt.setTimestamp(i, generationFromDate);
                        ++i;
                    }
                    if (generationToDate != null) {
                        stmt.setTimestamp(i, generationToDate);
                        ++i;
                    }
                    if (application != null && !"".equals(application)) {
                        stmt.setString(i, "%" + application + "%");
                        ++i;
                    }
                    if (message != null && !"".equals(message)) {
                        stmt.setString(i, "%" + message + "%");
                        ++i;
                    }
                    if (confirmFlg != null) {
                        stmt.setInt(i, confirmFlg);
                        ++i;
                    }
                    if (confirmUser != null) {
                        stmt.setString(i, confirmUser);
                        ++i;
                    }
                }
                if ((res = stmt.executeQuery()).next()) {
                    count = res.getInt(1);
                }
            }
            catch (SQLException e) {
                m_log.error((Object)"countEvent() error :  SQLException");
                throw e;
            }
            Object var21_22 = null;
        }
        catch (Throwable throwable) {
            Object var21_23 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)"countEvent() error :  SQLException");
                throw e1;
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)"countEvent() error :  SQLException");
            throw e1;
        }
        if (stmt != null) {
            stmt.close();
        }
        if (res != null) {
            res.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)"countEvent() end : ");
        return count;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int confirmEvent(String[] facilityId, Integer priority, Timestamp outputFromDate, Timestamp outputToDate, Timestamp generationFromDate, Timestamp generationToDate, String application, String message, Integer beforConfirmFlg, Integer afterConfirmFlg, String confirmUser) throws SQLException {
        int row;
        m_log.debug((Object)"confirmEvent() start : ");
        StringBuffer sqlWhere = new StringBuffer();
        boolean whereFlg = false;
        if (facilityId != null && facilityId.length > 0) {
            sqlWhere.append("facility_id IN (");
            for (int index = 0; index < facilityId.length; ++index) {
                if (index != 0) {
                    sqlWhere.append(",");
                }
                sqlWhere.append("?");
            }
            sqlWhere.append(")");
            whereFlg = true;
        }
        if (priority != null) {
            sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " priority = ?");
            whereFlg = true;
        }
        if (outputFromDate != null) {
            sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " output_date >= ?");
            whereFlg = true;
        }
        if (outputToDate != null) {
            sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " output_date <= ?");
            whereFlg = true;
        }
        if (generationFromDate != null) {
            sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " generation_date >= ?");
            whereFlg = true;
        }
        if (generationToDate != null) {
            sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " generation_date <= ?");
            whereFlg = true;
        }
        if (application != null && !"".equals(application)) {
            sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " application like ?");
            whereFlg = true;
        }
        if (message != null && !"".equals(message)) {
            sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " message like ?");
            whereFlg = true;
        }
        if (beforConfirmFlg != null) {
            sqlWhere.append(this.checkAndLogicalOperator(whereFlg) + " confirm_flg = ?");
            whereFlg = true;
        }
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("UPDATE cc_event_log SET confirm_flg = ?, confirm_date = ?, confirm_user = ? ");
                if (sqlWhere.length() > 0) {
                    sql.append("WHERE " + sqlWhere.toString());
                }
                stmt = conn.prepareStatement(sql.toString());
                int count = 1;
                stmt.setInt(count++, afterConfirmFlg);
                stmt.setTimestamp(count++, new Timestamp(System.currentTimeMillis()));
                stmt.setString(count++, confirmUser);
                if (sqlWhere.length() > 0) {
                    if (facilityId != null && facilityId.length > 0) {
                        for (int index = 0; index < facilityId.length; ++count, ++index) {
                            stmt.setString(count, facilityId[index]);
                        }
                    }
                    if (priority != null) {
                        stmt.setInt(count, priority);
                        ++count;
                    }
                    if (outputFromDate != null) {
                        stmt.setTimestamp(count, outputFromDate);
                        ++count;
                    }
                    if (outputToDate != null) {
                        stmt.setTimestamp(count, outputToDate);
                        ++count;
                    }
                    if (generationFromDate != null) {
                        stmt.setTimestamp(count, generationFromDate);
                        ++count;
                    }
                    if (generationToDate != null) {
                        stmt.setTimestamp(count, generationToDate);
                        ++count;
                    }
                    if (application != null && !"".equals(application)) {
                        stmt.setString(count, "%" + application + "%");
                        ++count;
                    }
                    if (message != null && !"".equals(message)) {
                        stmt.setString(count, "%" + message + "%");
                        ++count;
                    }
                    if (beforConfirmFlg != null) {
                        stmt.setInt(count, beforConfirmFlg);
                        ++count;
                    }
                }
                row = stmt.executeUpdate();
            }
            catch (SQLException e) {
                m_log.error((Object)"confirmEvent() error :  SQLException");
                m_log.error((Object)e.getMessage());
                throw e;
            }
            Object var22_23 = null;
        }
        catch (Throwable throwable) {
            Object var22_24 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)"confirmEvent() error :  SQLException");
                m_log.error((Object)e1.getMessage());
                throw e1;
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)"confirmEvent() error :  SQLException");
            m_log.error((Object)e1.getMessage());
            throw e1;
        }
        if (stmt != null) {
            stmt.close();
        }
        if (res != null) {
            res.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)"confirmEvent() end : ");
        return row;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection findHighPriorityEvent(String[] facilityId, Integer priority, Timestamp outputFromDate, Timestamp outputToDate, Timestamp generationFromDate, Timestamp generationToDate, String application, String message, Integer confirmFlg, String confirmUser) throws FinderException {
        m_log.debug((Object)"selectHighPriorityEvent() start : ");
        ArrayList<EventLogPK> ret = new ArrayList<EventLogPK>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet res = null;
        try {
            try {
                conn = ConnectionManager.getConnectionManager().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT * FROM cc_event_log ");
                sql.append("WHERE ");
                sql.append("facility_id IN (");
                for (int index = 0; index < facilityId.length; ++index) {
                    if (index != 0) {
                        sql.append(",");
                    }
                    sql.append("?");
                }
                sql.append(")");
                if (priority != null) {
                    sql.append(" and priority = ?");
                }
                if (outputFromDate != null) {
                    sql.append(" and output_date >= ?");
                }
                if (outputToDate != null) {
                    sql.append("and output_date <= ?");
                }
                if (generationFromDate != null) {
                    sql.append(" and generation_date >= ?");
                }
                if (generationToDate != null) {
                    sql.append(" and generation_date <= ?");
                }
                if (application != null && !"".equals(application)) {
                    sql.append(" and application like ?");
                }
                if (message != null && !"".equals(message)) {
                    sql.append(" and message like ?");
                }
                if (confirmFlg != null) {
                    sql.append(" and confirm_flg = ?");
                }
                if (confirmUser != null) {
                    sql.append(" and confirm_user = ?");
                }
                sql.append(" ORDER BY output_date DESC LIMIT 1");
                stmt = conn.prepareStatement(sql.toString());
                int count = 1;
                if (facilityId != null && facilityId.length > 0) {
                    for (int index = 0; index < facilityId.length; ++count, ++index) {
                        stmt.setString(count, facilityId[index]);
                    }
                }
                if (priority != null) {
                    stmt.setInt(count, priority);
                    ++count;
                }
                if (outputFromDate != null) {
                    stmt.setTimestamp(count, outputFromDate);
                    ++count;
                }
                if (outputToDate != null) {
                    stmt.setTimestamp(count, outputToDate);
                    ++count;
                }
                if (generationFromDate != null) {
                    stmt.setTimestamp(count, generationFromDate);
                    ++count;
                }
                if (generationToDate != null) {
                    stmt.setTimestamp(count, generationToDate);
                    ++count;
                }
                if (application != null && !"".equals(application)) {
                    stmt.setString(count, "%" + application + "%");
                    ++count;
                }
                if (message != null && !"".equals(message)) {
                    stmt.setString(count, "%" + message + "%");
                    ++count;
                }
                if (confirmFlg != null) {
                    stmt.setInt(count, confirmFlg);
                    ++count;
                }
                if (confirmUser != null) {
                    stmt.setString(count, confirmUser);
                    ++count;
                }
                res = stmt.executeQuery();
                while (res.next()) {
                    EventLogPK pk = new EventLogPK(res.getString("monitor_id"), res.getString("plugin_id"), res.getString("facility_id"), res.getTimestamp("output_date"));
                    ret.add(pk);
                }
                Object var19_20 = null;
            }
            catch (SQLException e) {
                m_log.error((Object)"selectHighPriorityEvent() error :  SQLException");
                throw new EJBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var19_21 = null;
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (res != null) {
                    res.close();
                }
                if (conn == null) throw throwable;
                conn.close();
                throw throwable;
            }
            catch (SQLException e1) {
                m_log.error((Object)"selectHighPriorityEvent() error :  SQLException");
                throw new EJBException(e1.getMessage());
            }
        }
        try {}
        catch (SQLException e1) {
            m_log.error((Object)"selectHighPriorityEvent() error :  SQLException");
            throw new EJBException(e1.getMessage());
        }
        if (stmt != null) {
            stmt.close();
        }
        if (res != null) {
            res.close();
        }
        if (conn != null) {
            conn.close();
        }
        m_log.debug((Object)"selectHighPriorityEvent() start : ");
        return ret;
    }

    private String checkAndLogicalOperator(boolean flag) {
        if (flag) {
            return " and ";
        }
        return "";
    }
}

