/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.aws.base.ui.dialogs;

import com.clustercontrol.cloud.aws.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.aws.base.resources.CloudResourceProvider;
import com.clustercontrol.cloud.aws.base.resources.Image;
import com.clustercontrol.cloud.aws.base.ui.dialogs.SelectAMIDialog;
import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.presenter.CreateCloudTemplateRequest;
import com.clustercontrol.util.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class CreateTemplateDialog
extends Dialog {
    private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
    private String strSeparator = this.messages.getString("caption.title_separator");
    private String strTemplateName = this.messages.getString("word.template_name");
    private String strLaunchJobId = this.messages.getString("word.launch_job_id");
    private String strStartJobId = this.messages.getString("word.start_job_id");
    private String strStopJobId = this.messages.getString("word.stop_job_id");
    private String strRegion = this.messages.getString("word.region");
    private String strAmi = this.messages.getString("word.ami");
    private String strRefer = this.messages.getString("word.refer");
    private String strTemplate = this.messages.getString("word.template");
    private String strCreateTemplateDialog = this.messages.getString("caption.create_template_dialog");
    private String msgMustFullyInput = this.messages.getString("message.must_fully_input");
    private Shell shell;
    private Combo region;
    private Text templateId;
    private Text templateName;
    private Text ami;
    private Combo launchJobId;
    private Combo startJobId;
    private Combo stopJobId;
    private CloudResourceProvider provider;
    private IDialogBehavior behavior = new DialogBehavior();
    private CreateCloudTemplateRequest output = new CreateCloudTemplateRequest();

    public CreateTemplateDialog(Shell parentShell) {
        super(parentShell);
        this.shell = parentShell;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 4);
        container.setBackground(SWTResourceManager.getColor((int)22));
        GridLayout gl_container = new GridLayout(3, false);
        gl_container.verticalSpacing = 15;
        container.setLayout((Layout)gl_container);
        GridData gd_container = new GridData(4, 4, true, false);
        gd_container.verticalAlignment = 4;
        gd_container.horizontalAlignment = 4;
        container.setLayoutData((Object)gd_container);
        Label lblRegion = new Label(container, 131072);
        lblRegion.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblRegion.setText(this.strRegion + this.strSeparator);
        this.region = new Combo(container, 8);
        this.region.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Label lblTemplateId = new Label(container, 131072);
        lblTemplateId.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblTemplateId.setText(this.strTemplate + this.strSeparator);
        this.templateId = new Text(container, 2048);
        this.templateId.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Label lblTemplateName = new Label(container, 131072);
        lblTemplateName.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblTemplateName.setText(this.strTemplateName + this.strSeparator);
        this.templateName = new Text(container, 2048);
        this.templateName.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Label lblAmi = new Label(container, 131072);
        lblAmi.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblAmi.setText(this.strAmi + this.strSeparator);
        this.ami = new Text(container, 2056);
        this.ami.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Button btnSelectAMI = new Button(container, 0);
        btnSelectAMI.setText(this.strRefer);
        btnSelectAMI.setLayoutData((Object)new GridData(4, 4, false, true, 1, 1));
        Label lblLaunchJobId = new Label(container, 131072);
        lblLaunchJobId.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblLaunchJobId.setText(this.strLaunchJobId + this.strSeparator);
        this.launchJobId = new Combo(container, 8);
        GridData gd_launchJobId = new GridData(4, 4, true, true, 2, 1);
        gd_launchJobId.widthHint = 100;
        this.launchJobId.setLayoutData((Object)gd_launchJobId);
        Label lblStartJobId = new Label(container, 131072);
        lblStartJobId.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblStartJobId.setText(this.strStartJobId + this.strSeparator);
        this.startJobId = new Combo(container, 8);
        GridData gd_startJobId = new GridData(4, 4, true, true, 2, 1);
        gd_startJobId.widthHint = 100;
        this.startJobId.setLayoutData((Object)gd_startJobId);
        Label lblStopJobId = new Label(container, 131072);
        lblStopJobId.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblStopJobId.setText(this.strStopJobId + this.strSeparator);
        this.stopJobId = new Combo(container, 8);
        GridData gd_stopJobId = new GridData(4, 4, true, true, 2, 1);
        gd_stopJobId.widthHint = 100;
        this.stopJobId.setLayoutData((Object)gd_stopJobId);
        this.behavior.setupRegion(this.region);
        this.behavior.setupTemplateId(this.templateId);
        this.behavior.setupTemplateName(this.templateName);
        this.behavior.setupAmi(this.ami, btnSelectAMI);
        this.behavior.setupLaunchJobId(this.launchJobId);
        this.behavior.setupStartJobId(this.startJobId);
        this.behavior.setupStopJobId(this.stopJobId);
        this.region.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateTemplateDialog.this.ami.setText("");
                CreateTemplateDialog.this.ami.setData(null);
            }
        });
        btnSelectAMI.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectAMIDialog dialog = new SelectAMIDialog(CreateTemplateDialog.this.shell);
                dialog.setCloudInfoProvider(CreateTemplateDialog.this.provider);
                dialog.setRegion((String)CreateTemplateDialog.this.region.getData(CreateTemplateDialog.this.region.getText()));
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    Image image = dialog.getOutput();
                    CreateTemplateDialog.this.ami.setText("(" + image.getImageId() + ") " + image.getName());
                    CreateTemplateDialog.this.ami.setData((Object)image);
                }
            }
        });
        ControlUtil.setRequired((Control[])new Control[]{this.templateId, this.templateName, this.ami});
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(640, 480);
    }

    protected void okPressed() {
        if (this.templateId.getText() == "" || this.templateName.getText() == "" || this.region.getText() == "" || this.ami.getText() == "") {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)this.msgMustFullyInput);
            return;
        }
        this.output.setRegion((String)this.region.getData(this.region.getText()));
        this.output.setTemplateId(this.templateId.getText());
        this.output.setTemplateName(this.templateName.getText().equals("") ? null : this.templateName.getText());
        this.output.setImageId(((Image)this.ami.getData()).getImageId());
        this.output.setLaunchJobId(this.launchJobId.getText().equals("") ? null : (String)this.launchJobId.getData(this.launchJobId.getText()));
        this.output.setStartJobId(this.startJobId.getText().equals("") ? null : (String)this.startJobId.getData(this.startJobId.getText()));
        this.output.setStopJobId(this.stopJobId.getText().equals("") ? null : (String)this.stopJobId.getData(this.stopJobId.getText()));
        this.setReturnCode(0);
        this.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.strCreateTemplateDialog);
    }

    public CreateCloudTemplateRequest getOutput() {
        return this.output;
    }

    public void setCloudInfoProvider(CloudResourceProvider provider) {
        this.provider = provider;
    }

    public void setBehavior(IDialogBehavior behavior) {
        this.behavior = behavior;
    }

    public static class DialogBehavior
    implements IDialogBehavior {
        @Override
        public void setupRegion(Combo region) {
        }

        @Override
        public void setupTemplateId(Text templateId) {
        }

        @Override
        public void setupTemplateName(Text templateName) {
        }

        @Override
        public void setupAmi(Text ami, Button selectAmi) {
        }

        @Override
        public void setupLaunchJobId(Combo launchJobId) {
        }

        @Override
        public void setupStartJobId(Combo startJobId) {
        }

        @Override
        public void setupStopJobId(Combo stopJobId) {
        }
    }

    public static interface IDialogBehavior {
        public void setupRegion(Combo var1);

        public void setupTemplateId(Text var1);

        public void setupTemplateName(Text var1);

        public void setupAmi(Text var1, Button var2);

        public void setupLaunchJobId(Combo var1);

        public void setupStartJobId(Combo var1);

        public void setupStopJobId(Combo var1);
    }
}

