/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.plugin;

import com.clustercontrol.cloud.Activator;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public final class ViewPluginUtil {
    private ViewPluginUtil() {
    }

    public static List<PluginView> getPluginViews() {
        LinkedList<PluginView> views = new LinkedList<PluginView>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(Activator.getDefault().getBundle().getSymbolicName() + ".viewPlugin");
        for (IExtension extension : point.getExtensions()) {
            for (IConfigurationElement element : extension.getConfigurationElements()) {
                Integer priority = null;
                ViewPosition position = null;
                String viewId = null;
                if (!element.getName().equals("view_plugin")) continue;
                try {
                    priority = Integer.parseInt(element.getAttribute("priority"));
                    position = ViewPosition.valueOf(element.getAttribute("position"));
                    viewId = element.getAttribute("view_id");
                    assert (priority != null) : "priority is null.";
                    assert (position != null) : "position is null.";
                    assert (viewId != null) : "viewId is null.";
                    views.add(new PluginView(priority, position, viewId));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        Collections.sort(views, new PluginViewComparator());
        return views;
    }

    public static class PluginViewComparator
    implements Comparator<PluginView> {
        @Override
        public int compare(PluginView view1, PluginView view2) {
            int result = view1.getPosition().ordinal() - view2.getPosition().ordinal();
            if (result == 0) {
                result = view1.getPriority() - view2.getPriority();
            }
            return result;
        }
    }

    public static class PluginView {
        private int priority;
        private ViewPosition position;
        private String id;

        public PluginView(int priority, ViewPosition position, String id) {
            this.priority = priority;
            this.position = position;
            this.id = id;
        }

        public int getPriority() {
            return this.priority;
        }

        public void setPriority(int priority) {
            this.priority = priority;
        }

        public ViewPosition getPosition() {
            return this.position;
        }

        public void setPosition(ViewPosition position) {
            this.position = position;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }

    public static enum ViewPosition {
        left,
        top,
        right,
        middle,
        bottom;

    }
}

