/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.presenter;

import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.annotation.Export;
import com.clustercontrol.cloud.commons.util.annotation.Import;
import com.clustercontrol.cloud.presenter.CloudModelException;
import com.clustercontrol.cloud.presenter.CloudStorageManager;
import com.clustercontrol.cloud.presenter.ICloudStorage;
import com.clustercontrol.cloud.presenter.InternalComponent;
import com.clustercontrol.cloud.presenter.StorageAttachment;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloud.InvalidRole_Exception;
import com.clustercontrol.ws.cloud.InvalidUserPass_Exception;

public class CloudStorage
extends InternalComponent<CloudStorageManager, com.clustercontrol.ws.cloud.CloudStorage>
implements ICloudStorage {
    private String storageId;
    private String storageName;
    private String facilityId;
    private String facilityName;
    private String cloudTypeId;
    private String state;
    private StorageAttachment storageAttachment;
    private String flavor;
    private Integer size;
    private String region;
    private String zone;
    private String registState;
    private Long regDate;
    private String regUser;
    private Long updateDate;
    private String updateUser;
    private Integer deviceIndex;
    private String deviceName;
    private String deviceType;
    private String snapshotId;

    public CloudStorage(CloudStorageManager container) {
        super(container);
    }

    @Override
    @Export
    public String getStorageId() {
        return this.storageId;
    }

    @Import
    public void setStorageId(String storageId) {
        this.internalSet("storageId", ICloudStorage.p2.storageId, storageId);
    }

    @Override
    @Export
    public String getStorageName() {
        return this.storageName;
    }

    @Import
    public void setStorageName(String storageName) {
        this.internalSet("storageName", ICloudStorage.p2.storageName, storageName);
    }

    @Override
    @Export
    public String getFacilityId() {
        return this.facilityId;
    }

    @Import
    public void setFacilityId(String facilityId) {
        this.internalSet("facilityId", ICloudStorage.p2.facilityId, facilityId);
    }

    @Override
    @Export
    public String getFacilityName() {
        return this.facilityName;
    }

    @Import
    public void setFacilityName(String facilityName) {
        this.internalSet("facilityName", ICloudStorage.p2.facilityName, facilityName);
    }

    @Override
    @Export
    public String getCloudTypeId() {
        return this.cloudTypeId;
    }

    @Import
    public void setCloudTypeId(String cloudTypeId) {
        this.internalSet("cloudTypeId", ICloudStorage.p2.cloudTypeId, cloudTypeId);
    }

    @Override
    @Export
    public String getFlavor() {
        return this.flavor;
    }

    @Import
    public void setFlavor(String flavor) {
        this.internalSet("flavor", ICloudStorage.p2.flavor, flavor);
    }

    @Override
    @Export
    public String getRegion() {
        return this.region;
    }

    @Import
    public void setRegion(String region) {
        this.internalSet("region", ICloudStorage.p2.region, region);
    }

    @Override
    @Export
    public String getZone() {
        return this.zone;
    }

    @Import
    public void setZone(String zone) {
        this.internalSet("zone", ICloudStorage.p2.zone, zone);
    }

    @Override
    @Export
    public String getState() {
        return this.state;
    }

    @Import
    public void setState(String state) {
        this.internalSet("state", ICloudStorage.p2.state, state);
    }

    @Override
    @Export
    public Integer getSize() {
        return this.size;
    }

    @Import
    public void setSize(Integer size) {
        this.internalSet("size", ICloudStorage.p2.size, size);
    }

    @Override
    @Export
    public String getRegistState() {
        return this.registState;
    }

    @Import
    public void setRegistState(String registState) {
        this.internalSet("registState", ICloudStorage.p2.registState, registState);
    }

    @Override
    @Export
    public StorageAttachment getStorageAttachment() {
        return this.storageAttachment;
    }

    @Import
    public void setStorageAttachment(StorageAttachment storageAttachment) {
        this.internalSet("storageAttachment", ICloudStorage.p2.storageAttachment, storageAttachment);
    }

    @Override
    @Export
    public String getSnapshotId() {
        return this.snapshotId;
    }

    @Import
    public void setSnapshotId(String snapshotId) {
        this.internalSet("snapshotId", ICloudStorage.p2.snapshotId, snapshotId);
    }

    @Override
    @Export
    public Integer getDeviceIndex() {
        return this.deviceIndex;
    }

    @Import
    public void setDeviceIndex(Integer deviceIndex) {
        this.internalSet("deviceIndex", ICloudStorage.p2.deviceIndex, deviceIndex);
    }

    @Override
    @Export
    public String getDeviceType() {
        return this.deviceType;
    }

    @Import
    public void setDeviceType(String deviceType) {
        this.internalSet("deviceType", ICloudStorage.p2.deviceType, deviceType);
    }

    @Override
    @Export
    public String getDeviceName() {
        return this.deviceName;
    }

    @Import
    public void setDeviceName(String deviceName) {
        this.internalSet("deviceName", ICloudStorage.p2.deviceName, deviceName);
    }

    @Override
    @Export
    public Long getRegDate() {
        return this.regDate;
    }

    @Import
    public void setRegDate(Long regDate) {
        this.internalSet("regDate", ICloudStorage.p2.regDate, regDate);
    }

    @Override
    @Export
    public String getRegUser() {
        return this.regUser;
    }

    @Import
    public void setRegUser(String regUser) {
        this.internalSet("regUser", ICloudStorage.p2.regUser, regUser);
    }

    @Override
    @Export
    public Long getUpdateDate() {
        return this.updateDate;
    }

    @Import
    public void setUpdateDate(Long updateDate) {
        this.internalSet("updateDate", ICloudStorage.p2.updateDate, updateDate);
    }

    @Override
    @Export
    public String getUpdateUser() {
        return this.updateUser;
    }

    @Import
    public void setUpdateUser(String updateUser) {
        this.internalSet("updateUser", ICloudStorage.p2.updateUser, updateUser);
    }

    @Override
    public CloudStorageManager getCloudStorageManager() {
        return (CloudStorageManager)this.getContainer();
    }

    @Override
    public boolean equalValues(com.clustercontrol.ws.cloud.CloudStorage source) {
        return this.getStorageId().equals(source.getStorageId());
    }

    public static CloudStorage createCloudStorage(CloudStorageManager cloudStorageManager, com.clustercontrol.ws.cloud.CloudStorage source) {
        CloudStorage cloudStorage = new CloudStorage(cloudStorageManager);
        cloudStorage.overwrite(source);
        return cloudStorage;
    }

    @Override
    public com.clustercontrol.ws.cloud.CloudStorage getSource() throws CloudModelException {
        try {
            return this.getEndpoint().getStorage(this.getRoleId(), this.getCloudStorageManager().getRegion().getRegion(), this.getStorageId());
        }
        catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    protected void overwrite(com.clustercontrol.ws.cloud.CloudStorage source) {
        ControlUtil.importObject(this, source);
        this.setRegistState(source.getRegistState().value());
        if (source.getStorageAttachment() != null) {
            StorageAttachment storageAttachment = new StorageAttachment();
            ControlUtil.importObject(storageAttachment, source.getStorageAttachment());
            this.setStorageAttachment(storageAttachment);
        }
        this.setCloudTypeId(this.internalGetCloudTypeId());
    }

    @Override
    public void attach(String instanceId, String deviceName) {
        try {
            this.getEndpoint().attachStorage(this.getRoleId(), this.getRegion(), instanceId, this.getStorageId(), deviceName);
        }
        catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    public void detach() {
        try {
            this.getEndpoint().detachStorage(this.getRoleId(), this.getRegion(), this.getStorageAttachment().getInstanceId(), this.getStorageId());
        }
        catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
            throw new CloudModelException(e);
        }
    }

    private String getRoleId() {
        return this.getCloudStorageManager().getRegion().getAccountResource().getActiveUser().getRoleId();
    }

    public CloudEndpoint getEndpoint() {
        return this.getCloudStorageManager().getEndpoint();
    }

    private String internalGetCloudTypeId() {
        String cloudServiceId = this.getCloudStorageManager().getCloudComputeService().getRegion().getAccountResource().getCloudServiceId();
        String cloudTypeId = this.getCloudStorageManager().getCloudComputeService().getRegion().getAccountResource().getAccountResourceManager().getCloudResourceManager().getCloudServiceManager().getCloudService(cloudServiceId).getCloudTypeId();
        return cloudTypeId;
    }
}

