/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.dialogs;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.commons.util.AccountControlUtil;
import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.commons.util.ValidateException;
import com.clustercontrol.cloud.commons.util.annotation.RequiredInput;
import com.clustercontrol.cloud.commons.util.annotation.RequiredSelect;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.presenter.IAccountResourceManager;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.cloud.AvailableRole;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class CreateCloudUserDialog
extends Dialog {
    private DialogOutput output = new DialogOutput();
    private MessageManager bundle_messages = MessageManager.getInstance("messages");
    private String strSeparator = this.bundle_messages.getString("caption.title_separator");
    private String strAccountResourceId = this.bundle_messages.getString("word.account_resource_id");
    private String strCloudUserId = this.bundle_messages.getString("word.cloud_user_id");
    private String strCloudUserName = this.bundle_messages.getString("word.cloud_user_name");
    private String strDescription = this.bundle_messages.getString("word.description");
    private String strAccessKey = this.bundle_messages.getString("word.access_key");
    private String strSecretKey = this.bundle_messages.getString("word.secret_key");
    private String strAssignRoleId = this.bundle_messages.getString("word.assign_role_id");
    private String strAccountResource = this.bundle_messages.getString("word.account_resource");
    private String strCloudUser = this.bundle_messages.getString("word.cloud_user");
    @RequiredSelect(value="strAccountResourceId")
    private Combo cmbAccountResourceId;
    @RequiredInput(value="strCloudUserId")
    private Text txtCloudUserId;
    @RequiredInput(value="strCloudUserName")
    private Text txtCloudUserName;
    private Text txtDescription;
    @RequiredInput(value="strAccessKey")
    private Text txtAccessKey;
    @RequiredInput(value="strSecretKey")
    private Text txtSecretKey;
    @RequiredSelect(value="strAssignRoleId")
    private Combo cmbAssignRoleId;
    private IDialogBehavior behavior = new DialogBehavior();

    public CreateCloudUserDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 4);
        container.setBackground(SWTResourceManager.getColor(22));
        GridLayout gl_container = new GridLayout(1, false);
        gl_container.verticalSpacing = 15;
        container.setLayout((Layout)gl_container);
        GridData gd_container = new GridData(4, 4, true, false);
        gd_container.verticalAlignment = 4;
        gd_container.horizontalAlignment = 4;
        container.setLayoutData((Object)gd_container);
        Group grpAccountResource = new Group(container, 0);
        GridLayout gl_accountResource = new GridLayout(2, false);
        gl_accountResource.verticalSpacing = 15;
        grpAccountResource.setLayout((Layout)gl_accountResource);
        grpAccountResource.setLayoutData((Object)new GridData(4, 4, true, false));
        grpAccountResource.setText(this.strAccountResource);
        Label lblAccountResourceId = new Label((Composite)grpAccountResource, 131072);
        lblAccountResourceId.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblAccountResourceId.setText(this.strAccountResourceId + this.strSeparator);
        this.cmbAccountResourceId = new Combo((Composite)grpAccountResource, 8);
        this.cmbAccountResourceId.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Group grpCloudUser = new Group(container, 0);
        GridLayout gl_cloudUser = new GridLayout(2, false);
        gl_cloudUser.verticalSpacing = 15;
        grpCloudUser.setLayout((Layout)gl_cloudUser);
        grpCloudUser.setLayoutData((Object)new GridData(4, 4, true, false));
        grpCloudUser.setText(this.strCloudUser);
        Label lblCloudUserId = new Label((Composite)grpCloudUser, 131072);
        lblCloudUserId.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblCloudUserId.setText(this.strCloudUserId + this.strSeparator);
        this.txtCloudUserId = new Text((Composite)grpCloudUser, 2048);
        this.txtCloudUserId.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Label lblCloudUserName = new Label((Composite)grpCloudUser, 131072);
        lblCloudUserName.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblCloudUserName.setText(this.strCloudUserName + this.strSeparator);
        this.txtCloudUserName = new Text((Composite)grpCloudUser, 2048);
        this.txtCloudUserName.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Label lblDescription = new Label((Composite)grpCloudUser, 131072);
        lblDescription.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblDescription.setText(this.strDescription + this.strSeparator);
        this.txtDescription = new Text((Composite)grpCloudUser, 2048);
        this.txtDescription.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Label lblAccessKey = new Label((Composite)grpCloudUser, 131072);
        lblAccessKey.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblAccessKey.setText(this.strAccessKey + this.strSeparator);
        this.txtAccessKey = new Text((Composite)grpCloudUser, 2048);
        this.txtAccessKey.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Label lblSecretKey = new Label((Composite)grpCloudUser, 131072);
        lblSecretKey.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblSecretKey.setText(this.strSecretKey + this.strSeparator);
        this.txtSecretKey = new Text((Composite)grpCloudUser, 0x400800);
        this.txtSecretKey.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Label lblOwnerId = new Label((Composite)grpCloudUser, 131072);
        lblOwnerId.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        lblOwnerId.setText(this.strAssignRoleId + this.strSeparator);
        Composite cmpOwnerId = new Composite((Composite)grpCloudUser, 0);
        GridLayout gl_cmpOwnerId = new GridLayout(1, false);
        gl_cmpOwnerId.marginWidth = 0;
        cmpOwnerId.setLayout((Layout)gl_cmpOwnerId);
        cmpOwnerId.setLayoutData((Object)new GridData(4, 4, true, false));
        this.cmbAssignRoleId = new Combo(cmpOwnerId, 8);
        GridData gd_ownerId = new GridData(4, 4, true, true, 1, 1);
        gd_ownerId.widthHint = 100;
        this.cmbAssignRoleId.setLayoutData((Object)gd_ownerId);
        this.behavior.setupAccountResourceId(this.cmbAccountResourceId);
        this.behavior.setupCloudUserId(this.txtCloudUserId);
        this.behavior.setupCloudUserName(this.txtCloudUserName);
        this.behavior.setupDescription(this.txtDescription);
        this.behavior.setupAccessKey(this.txtAccessKey);
        this.behavior.setupSecretKey(this.txtSecretKey);
        this.behavior.setupAssignRoleId(this.cmbAssignRoleId);
        ControlUtil.setRequired(new Control[]{this.txtCloudUserId, this.txtCloudUserName, this.txtAccessKey, this.txtSecretKey});
        container.layout();
        Control[] labels = new Control[]{lblAccountResourceId, lblDescription, lblCloudUserId, lblCloudUserName, lblAccessKey, lblSecretKey, lblOwnerId};
        int maxWidth = 0;
        for (Control l : labels) {
            Point p = l.getSize();
            maxWidth = Math.max(maxWidth, p.x);
        }
        for (Control l : labels) {
            ((GridData)l.getLayoutData()).widthHint = maxWidth;
        }
        grpAccountResource.layout(true);
        grpCloudUser.layout(true);
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(640, 480);
    }

    protected void okPressed() {
        try {
            ControlUtil.validate(this);
        }
        catch (ValidateException e) {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)e.getMessage());
            return;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.output.setAccountResourceId(this.cmbAccountResourceId.getText());
        this.output.setCloudUserId(this.txtCloudUserId.getText());
        this.output.setCloudUserName(this.txtCloudUserName.getText());
        this.output.setDescription(this.txtDescription.getText());
        this.output.setAccessKey(this.txtAccessKey.getText());
        this.output.setSecretKey(this.txtSecretKey.getText());
        this.output.setRoleId((String)this.cmbAssignRoleId.getData(this.cmbAssignRoleId.getText()));
        this.setReturnCode(0);
        this.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.bundle_messages.getString("caption.create_cloud_user_dialog"));
    }

    public DialogOutput getOutput() {
        return this.output;
    }

    public void setBehavior(IDialogBehavior behavior) {
        this.behavior = behavior;
    }

    public static class DialogOutput {
        private String accountResourceId;
        private String cloudUserId;
        private String cloudUserName;
        private String description;
        private String accessKey;
        private String secretKey;
        private String roleId;

        public String getAccountResourceId() {
            return this.accountResourceId;
        }

        public void setAccountResourceId(String accountResourceId) {
            this.accountResourceId = accountResourceId;
        }

        public String getCloudUserId() {
            return this.cloudUserId;
        }

        public void setCloudUserId(String cloudUserId) {
            this.cloudUserId = cloudUserId;
        }

        public String getCloudUserName() {
            return this.cloudUserName;
        }

        public void setCloudUserName(String cloudUserName) {
            this.cloudUserName = cloudUserName;
        }

        public String getAccessKey() {
            return this.accessKey;
        }

        public void setAccessKey(String accessKey) {
            this.accessKey = accessKey;
        }

        public String getSecretKey() {
            return this.secretKey;
        }

        public void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }

        public String getRoleId() {
            return this.roleId;
        }

        public void setRoleId(String roleId) {
            this.roleId = roleId;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }

    public static class DialogBehavior
    implements IDialogBehavior {
        private IAccountResourceManager accountResourceManager = Activator.getDefault().getCloudResourceManager().getAccountResourceManager();

        @Override
        public void setupAccountResourceId(Combo cmbAccountResourceId) {
            for (IAccountResource accountResource : this.accountResourceManager.getAccountResources()) {
                cmbAccountResourceId.add(accountResource.getAccountResourceId());
            }
            if (cmbAccountResourceId.getItemCount() > 0) {
                cmbAccountResourceId.select(0);
            }
        }

        @Override
        public void setupCloudUserId(Text txtCloudUserId) {
        }

        @Override
        public void setupCloudUserName(Text txtCloudUserName) {
        }

        @Override
        public void setupDescription(Text txtCloudUserDescription) {
        }

        @Override
        public void setupAccessKey(Text txtAccessKey) {
        }

        @Override
        public void setupSecretKey(Text txtSecretKey) {
        }

        @Override
        public void setupAssignRoleId(Combo cmbAssignRoleId) {
            for (AvailableRole role : AccountControlUtil.getAssignableRoles()) {
                String roleLabel = role.getRoleName() + "(" + role.getRoleId() + ")";
                cmbAssignRoleId.add(roleLabel);
                cmbAssignRoleId.setData(roleLabel, (Object)role.getRoleId());
            }
            if (cmbAssignRoleId.getItemCount() > 0) {
                cmbAssignRoleId.select(0);
            }
        }
    }

    public static interface IDialogBehavior {
        public void setupAccountResourceId(Combo var1);

        public void setupCloudUserId(Text var1);

        public void setupCloudUserName(Text var1);

        public void setupDescription(Text var1);

        public void setupAccessKey(Text var1);

        public void setupSecretKey(Text var1);

        public void setupAssignRoleId(Combo var1);
    }
}

