/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.dialogs;

import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.commons.util.TemplateJobUtil;
import com.clustercontrol.cloud.ui.dialogs.RegistCommandDialog;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class CreateTemplateJobDialog
extends Dialog {
    private MessageManager messages = MessageManager.getInstance("messages");
    private String strSeparator = this.messages.getString("caption.title_separator");
    private String strWindows = this.messages.getString("word.windows");
    private String strJobnetName = this.messages.getString("word.jobnet_name");
    private String strJobnetId = this.messages.getString("word.jobnet_id");
    private String strOsType = this.messages.getString("word.os_type");
    private String strLinux = this.messages.getString("word.linux");
    private String strJobId = this.messages.getString("word.job_id");
    private String strJobName = this.messages.getString("word.job_name");
    private String strOrderNo = this.messages.getString("word.order_no");
    private String strCommandType = this.messages.getString("word.command_type");
    private String strExecuteCommnad = this.messages.getString("word.execute_command");
    private String strBehaviorInFailure = this.messages.getString("caption.behavior_in_failure");
    private String strExecuteUser = this.messages.getString("word.execute_user");
    private String strArgument = this.messages.getString("word.argument");
    private String strAdd = this.messages.getString("word.add");
    private String strModify = this.messages.getString("word.modify");
    private String strRemove = this.messages.getString("word.remove");
    private String strUp = this.messages.getString("word.up");
    private String strDown = this.messages.getString("word.down");
    private String msgJobDoesNotExists = this.messages.getString("message.job_does_not_exists");
    private String msgJobIdOverlaps = this.messages.getString("message.job_id_overlaps");
    private String msgMustFullyInput = this.messages.getString("message.must_fully_input");
    private String strCreateTemplateJobDialog = this.messages.getString("caption.create_template_job_dialog");
    private Table table;
    private TableViewer tableViewer;
    private Shell shell;
    private Text txtJobnetId;
    private Text txtJobnetName;
    private Button rdoWindows;
    private Button rdoLinux;
    private List<TemplateJobUtil.TemplateJob> jobInfos = new LinkedList<TemplateJobUtil.TemplateJob>();
    private DialogOutput output;
    private String roleId = "";

    public CreateTemplateJobDialog(Shell parentShell) {
        super(parentShell);
        this.shell = parentShell;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setBackground(SWTResourceManager.getColor(22));
        GridLayout gl_container = new GridLayout(2, false);
        container.setLayout((Layout)gl_container);
        GridData gd_container = new GridData(1808);
        gd_container.widthHint = 614;
        container.setLayoutData((Object)gd_container);
        Label lblTemplateId = new Label(container, 0);
        lblTemplateId.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblTemplateId.setText(this.strJobnetId + this.strSeparator);
        this.txtJobnetId = new Text(container, 2048);
        this.txtJobnetId.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblJobnetId = new Label(container, 0);
        lblJobnetId.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblJobnetId.setText(this.strJobnetName + this.strSeparator);
        this.txtJobnetName = new Text(container, 2048);
        this.txtJobnetName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblOSType = new Label(container, 0);
        lblOSType.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblOSType.setText(this.strOsType + this.strSeparator);
        Composite commandTypeComposite = new Composite(container, 0);
        GridLayout gl_commandTypeComposite = new GridLayout(3, false);
        commandTypeComposite.setLayout((Layout)gl_commandTypeComposite);
        commandTypeComposite.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.rdoWindows = new Button(commandTypeComposite, 16);
        this.rdoWindows.setText(this.strWindows);
        this.rdoLinux = new Button(commandTypeComposite, 16);
        this.rdoLinux.setText(this.strLinux);
        new Label(commandTypeComposite, 0);
        Composite jobContainer = new Composite(container, 0);
        jobContainer.setBackground(SWTResourceManager.getColor(255, 255, 255));
        GridLayout gl_jobContainer = new GridLayout(2, false);
        jobContainer.setLayout((Layout)gl_jobContainer);
        GridData gd_jobContainer = new GridData(1808);
        gd_jobContainer.horizontalSpan = 2;
        jobContainer.setLayoutData((Object)gd_jobContainer);
        this.table = new Table(jobContainer, 67586);
        this.table.setBackground(SWTResourceManager.getColor(1));
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 6));
        TableColumn tblclmnOrderNo = new TableColumn(this.table, 0);
        tblclmnOrderNo.setWidth(60);
        tblclmnOrderNo.setText(this.strOrderNo);
        TableColumn tblclmnJobId = new TableColumn(this.table, 0);
        tblclmnJobId.setWidth(60);
        tblclmnJobId.setText(this.strJobId);
        TableColumn tblclmnJobName = new TableColumn(this.table, 0);
        tblclmnJobName.setWidth(60);
        tblclmnJobName.setText(this.strJobName);
        TableColumn tblclmnCommandType = new TableColumn(this.table, 0);
        tblclmnCommandType.setWidth(60);
        tblclmnCommandType.setText(this.strCommandType);
        TableColumn tblclmnCommand = new TableColumn(this.table, 0);
        tblclmnCommand.setWidth(60);
        tblclmnCommand.setText(this.strExecuteCommnad);
        TableColumn tblclmnUser = new TableColumn(this.table, 0);
        tblclmnUser.setWidth(60);
        tblclmnUser.setText(this.strExecuteUser);
        TableColumn tblclmnArgument = new TableColumn(this.table, 0);
        tblclmnArgument.setWidth(60);
        tblclmnArgument.setText(this.strArgument);
        TableColumn tblclmnBehaviorInFailure = new TableColumn(this.table, 0);
        tblclmnBehaviorInFailure.setWidth(60);
        tblclmnBehaviorInFailure.setText(this.strBehaviorInFailure);
        Button btnAddJob = new Button(jobContainer, 0);
        btnAddJob.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        btnAddJob.setText(this.strAdd);
        Button btnModifyJob = new Button(jobContainer, 0);
        btnModifyJob.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        btnModifyJob.setText(this.strModify);
        Button btnRemoveJob = new Button(jobContainer, 0);
        btnRemoveJob.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        btnRemoveJob.setText(this.strRemove);
        new Label(jobContainer, 0);
        Button btnUpItem = new Button(jobContainer, 0);
        btnUpItem.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        btnUpItem.setText(this.strUp);
        Button btnDownItem = new Button(jobContainer, 0);
        btnDownItem.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        btnDownItem.setText(this.strDown);
        Control[] requiredControls = new Control[]{this.txtJobnetId, this.txtJobnetName};
        ControlUtil.setRequired(requiredControls);
        this.rdoWindows.setSelection(true);
        btnAddJob.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RegistCommandDialog dialog = new RegistCommandDialog(CreateTemplateJobDialog.this.shell);
                dialog.setRoleId(CreateTemplateJobDialog.this.roleId);
                if (dialog.open() == 0) {
                    TemplateJobUtil.TemplateJob tmpJob = dialog.getOutput();
                    tmpJob.setOrderNo(CreateTemplateJobDialog.this.jobInfos.size() + 1);
                    CreateTemplateJobDialog.this.jobInfos.add(tmpJob);
                    CreateTemplateJobDialog.this.tableViewer.setInput((Object)CreateTemplateJobDialog.this.jobInfos);
                }
            }
        });
        btnModifyJob.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CreateTemplateJobDialog.this.tableViewer.getSelection().isEmpty()) {
                    return;
                }
                if (!(CreateTemplateJobDialog.this.tableViewer.getSelection() instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection selection = (IStructuredSelection)CreateTemplateJobDialog.this.tableViewer.getSelection();
                if (selection.size() > 1) {
                    return;
                }
                TemplateJobUtil.TemplateJob currentJob = (TemplateJobUtil.TemplateJob)selection.getFirstElement();
                RegistCommandDialog dialog = new RegistCommandDialog(CreateTemplateJobDialog.this.shell);
                dialog.setInput(currentJob);
                if (dialog.open() == 0) {
                    TemplateJobUtil.TemplateJob tmpJob = dialog.getOutput();
                    tmpJob.setOrderNo(currentJob.getOrderNo());
                    CreateTemplateJobDialog.this.jobInfos.remove(currentJob);
                    CreateTemplateJobDialog.this.jobInfos.add(tmpJob);
                    CreateTemplateJobDialog.this.sort();
                    CreateTemplateJobDialog.this.tableViewer.setInput((Object)CreateTemplateJobDialog.this.jobInfos);
                }
            }
        });
        btnRemoveJob.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CreateTemplateJobDialog.this.tableViewer.getSelection().isEmpty()) {
                    return;
                }
                if (!(CreateTemplateJobDialog.this.tableViewer.getSelection() instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection selection = (IStructuredSelection)CreateTemplateJobDialog.this.tableViewer.getSelection();
                for (Object object : selection.toList()) {
                    TemplateJobUtil.TemplateJob currentJob = (TemplateJobUtil.TemplateJob)object;
                    CreateTemplateJobDialog.this.jobInfos.remove(currentJob);
                    for (TemplateJobUtil.TemplateJob tmpJob : CreateTemplateJobDialog.this.jobInfos) {
                        if (currentJob.getOrderNo() >= tmpJob.getOrderNo()) continue;
                        tmpJob.setOrderNo(tmpJob.getOrderNo() - 1);
                    }
                }
                CreateTemplateJobDialog.this.sort();
                CreateTemplateJobDialog.this.tableViewer.setInput((Object)CreateTemplateJobDialog.this.jobInfos);
            }
        });
        btnUpItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CreateTemplateJobDialog.this.tableViewer.getSelection().isEmpty()) {
                    return;
                }
                if (!(CreateTemplateJobDialog.this.tableViewer.getSelection() instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection selection = (IStructuredSelection)CreateTemplateJobDialog.this.tableViewer.getSelection();
                int count = 0;
                for (Object object : selection.toList()) {
                    TemplateJobUtil.TemplateJob currentJob = (TemplateJobUtil.TemplateJob)object;
                    if (!currentJob.getOrderNo().equals(1 + count)) {
                        for (TemplateJobUtil.TemplateJob tmpJob : CreateTemplateJobDialog.this.jobInfos) {
                            if (!currentJob.getOrderNo().equals(tmpJob.getOrderNo() + 1)) continue;
                            tmpJob.setOrderNo(tmpJob.getOrderNo() + 1);
                            currentJob.setOrderNo(currentJob.getOrderNo() - 1);
                            break;
                        }
                    }
                    ++count;
                }
                CreateTemplateJobDialog.this.sort();
                CreateTemplateJobDialog.this.tableViewer.setInput((Object)CreateTemplateJobDialog.this.jobInfos);
            }
        });
        btnDownItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CreateTemplateJobDialog.this.tableViewer.getSelection().isEmpty()) {
                    return;
                }
                if (!(CreateTemplateJobDialog.this.tableViewer.getSelection() instanceof IStructuredSelection)) {
                    return;
                }
                IStructuredSelection selection = (IStructuredSelection)CreateTemplateJobDialog.this.tableViewer.getSelection();
                LinkedList<TemplateJobUtil.TemplateJob> tmpList = new LinkedList<TemplateJobUtil.TemplateJob>();
                tmpList.clear();
                for (Object object : selection.toList()) {
                    tmpList.add((TemplateJobUtil.TemplateJob)object);
                }
                Collections.reverse(tmpList);
                int count = 0;
                for (TemplateJobUtil.TemplateJob currentJob : tmpList) {
                    if (!currentJob.getOrderNo().equals(CreateTemplateJobDialog.this.jobInfos.size() - count)) {
                        for (TemplateJobUtil.TemplateJob tmpJob : CreateTemplateJobDialog.this.jobInfos) {
                            if (!currentJob.getOrderNo().equals(tmpJob.getOrderNo() - 1)) continue;
                            tmpJob.setOrderNo(tmpJob.getOrderNo() - 1);
                            currentJob.setOrderNo(currentJob.getOrderNo() + 1);
                            break;
                        }
                    }
                    ++count;
                }
                CreateTemplateJobDialog.this.sort();
                CreateTemplateJobDialog.this.tableViewer.setInput((Object)CreateTemplateJobDialog.this.jobInfos);
            }
        });
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.tableViewer.setInput(this.jobInfos);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(640, 480);
    }

    protected void okPressed() {
        if (this.txtJobnetId.getText().equals("") || this.txtJobnetName.getText().equals("") || !this.rdoWindows.getSelection() && !this.rdoLinux.getSelection()) {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)this.msgMustFullyInput);
            return;
        }
        if (this.jobInfos.size() < 1) {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)this.msgJobDoesNotExists);
            return;
        }
        ArrayList<TemplateJobUtil.TemplateJob> tmpList = new ArrayList<TemplateJobUtil.TemplateJob>();
        tmpList.clear();
        tmpList.addAll(this.jobInfos);
        for (TemplateJobUtil.TemplateJob currentJob : this.jobInfos) {
            if (currentJob.getJobId().equals(this.txtJobnetId.getText())) {
                MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)this.msgJobIdOverlaps);
                return;
            }
            for (TemplateJobUtil.TemplateJob tmpJob : tmpList) {
                if (currentJob.equals(tmpJob) || !currentJob.getJobId().equals(tmpJob.getJobId())) continue;
                MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)this.msgJobIdOverlaps);
                return;
            }
            tmpList.remove(currentJob);
        }
        this.output = new DialogOutput();
        this.output.setJobnetId(this.txtJobnetId.getText());
        this.output.setJobnetName(this.txtJobnetName.getText());
        if (this.rdoWindows.getSelection()) {
            this.output.setOsType(TemplateJobUtil.TemplateJobOSType.windows);
        } else if (this.rdoLinux.getSelection()) {
            this.output.setOsType(TemplateJobUtil.TemplateJobOSType.unix);
        }
        this.output.setTemplateJobList(this.jobInfos);
        this.setReturnCode(0);
        this.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.strCreateTemplateJobDialog);
    }

    private void sort() {
        Collections.sort(this.jobInfos, new Comparator<TemplateJobUtil.TemplateJob>(){

            @Override
            public int compare(TemplateJobUtil.TemplateJob job1, TemplateJobUtil.TemplateJob job2) {
                if (job1.getOrderNo() > job2.getOrderNo()) {
                    return 1;
                }
                if (job1.getOrderNo() < job2.getOrderNo()) {
                    return -1;
                }
                return 0;
            }
        });
    }

    public DialogOutput getOutput() {
        return this.output;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    private static class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            TemplateJobUtil.TemplateJob jobInfo = (TemplateJobUtil.TemplateJob)element;
            switch (columnIndex) {
                case 0: {
                    return jobInfo.getOrderNo().toString();
                }
                case 1: {
                    return jobInfo.getJobId();
                }
                case 2: {
                    return jobInfo.getJobName();
                }
                case 3: {
                    return jobInfo.getCommandType().name();
                }
                case 4: {
                    return jobInfo.getCommand();
                }
                case 5: {
                    return jobInfo.getExecuteUser();
                }
                case 6: {
                    return jobInfo.getArgument();
                }
                case 7: {
                    return jobInfo.getBehaviorInFailure().toString();
                }
            }
            return null;
        }
    }

    public static class DialogOutput {
        private String jobnetId;
        private String jobnetName;
        private TemplateJobUtil.TemplateJobOSType osType;
        private List<TemplateJobUtil.TemplateJob> templateJobList;

        public String getJobnetId() {
            return this.jobnetId;
        }

        public void setJobnetId(String jobnetId) {
            this.jobnetId = jobnetId;
        }

        public String getJobnetName() {
            return this.jobnetName;
        }

        public void setJobnetName(String jobnetName) {
            this.jobnetName = jobnetName;
        }

        public TemplateJobUtil.TemplateJobOSType getOsType() {
            return this.osType;
        }

        public void setOsType(TemplateJobUtil.TemplateJobOSType osType) {
            this.osType = osType;
        }

        public List<TemplateJobUtil.TemplateJob> getTemplateJobList() {
            return this.templateJobList;
        }

        public void setTemplateJobList(List<TemplateJobUtil.TemplateJob> templateJobList) {
            this.templateJobList = templateJobList;
        }
    }
}

