/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.plugin.monitor;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.plugin.monitor.BillingMonitor;
import com.clustercontrol.cloud.plugin.monitor.CommonMonitorNumericDialog;
import com.clustercontrol.cloud.plugin.monitor.MonitorBasicScopeComposite;
import com.clustercontrol.monitor.util.MonitorSettingEndpointWrapper;
import com.clustercontrol.notify.util.NotifyGroupIdGenerator;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloud.InvalidRole_Exception;
import com.clustercontrol.ws.cloud.InvalidUserPass_Exception;
import com.clustercontrol.ws.monitor.MonitorDuplicate_Exception;
import com.clustercontrol.ws.monitor.MonitorInfo;
import com.clustercontrol.ws.monitor.MonitorPluginStringInfo;
import com.clustercontrol.ws.monitor.PluginCheckInfo;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CreateBillingMonitorDialog
extends CommonMonitorNumericDialog {
    MessageManager messages = MessageManager.getInstance("messages");
    String strFee = this.messages.getString("word.fee");
    String strTarget = this.messages.getString("word.target");
    String strSeparator = this.messages.getString("caption.title_separator");
    String msgSelectTarget = this.messages.getString("message.select_subject", new Object[]{"word.target"});
    String msgSelectScope = this.messages.getString("message.select_subject", new Object[]{"word.scope"});
    Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
    private Combo cmbTarget = null;

    public CreateBillingMonitorDialog(Shell parent) {
        super(parent);
    }

    public CreateBillingMonitorDialog(Shell parent, String monitorId, boolean updateFlg) {
        super(parent);
        this.monitorId = monitorId;
        this.updateFlg = updateFlg;
    }

    @Override
    protected void customizeDialog(Composite parent) {
        this.item1 = Messages.getString((String)"select.value");
        this.item2 = Messages.getString((String)"select.value");
        super.customizeDialog(parent);
        this.shell.setText(BillingMonitor.monitorName);
        Label label = null;
        GridData gridData = null;
        Group groupCheckRule = new Group((Composite)this.groupRule, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 15;
        groupCheckRule.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        groupCheckRule.setLayoutData((Object)gridData);
        groupCheckRule.setText(Messages.getString((String)"check.rule"));
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(this.strTarget + this.strSeparator);
        this.cmbTarget = new Combo((Composite)groupCheckRule, 12);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.cmbTarget.setLayoutData((Object)gridData);
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label((Composite)groupCheckRule, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 7;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        this.itemName.setText(this.strFee);
        this.m_numericValueInfo.setRangeFlg(false);
        this.adjustDialog();
        MonitorInfo info = null;
        if (this.monitorId == null) {
            info = new MonitorInfo();
            this.setInfoInitialValue(info);
        } else {
            try {
                info = MonitorSettingEndpointWrapper.getMonitor((String)this.monitorId, (String)"MON_BILLING");
            }
            catch (com.clustercontrol.ws.monitor.InvalidRole_Exception e) {
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
            }
            catch (Exception e) {
                this.logger.warn((Object)("customizeDialog(), " + e.getMessage()), (Throwable)e);
                MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)(Messages.getString((String)"message.hinemos.failure.unexpected") + ", " + e.getMessage()));
            }
        }
        this.m_monitorBasic.addChangeFacilityIdListener(new MonitorBasicScopeComposite.IChangeFacilityIdListener(){
            private String lastFacilityId = null;

            @Override
            public void facilityIdChanged() {
                if (this.lastFacilityId == null) {
                    if (CreateBillingMonitorDialog.this.m_monitorBasic.getFacilityId() == null) {
                        return;
                    }
                    CreateBillingMonitorDialog.this.setupCmbTarget();
                } else if (CreateBillingMonitorDialog.this.m_monitorBasic.getFacilityId() == null) {
                    CreateBillingMonitorDialog.this.cmbTarget.clearSelection();
                    CreateBillingMonitorDialog.this.cmbTarget.removeAll();
                } else if (!this.lastFacilityId.equals(CreateBillingMonitorDialog.this.m_monitorBasic.getFacilityId())) {
                    CreateBillingMonitorDialog.this.setupCmbTarget();
                }
                this.lastFacilityId = CreateBillingMonitorDialog.this.m_monitorBasic.getFacilityId();
            }
        });
        this.cmbTarget.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                assert (CreateBillingMonitorDialog.this.m_monitorBasic != null);
                if (CreateBillingMonitorDialog.this.m_monitorBasic.getFacilityId() == null || CreateBillingMonitorDialog.this.m_monitorBasic.getFacilityId().isEmpty()) {
                    MessageDialog.openInformation(null, (String)Messages.getString((String)"failed"), (String)CreateBillingMonitorDialog.this.msgSelectScope);
                }
            }
        });
        this.setInputData(info);
    }

    @Override
    public void update() {
        super.update();
    }

    @Override
    protected void setInputData(MonitorInfo monitor) {
        MonitorPluginStringInfo stringInfo;
        PluginCheckInfo info;
        super.setInputData(monitor);
        this.inputData = monitor;
        if (this.inputData.getFacilityId() != null && !this.inputData.getFacilityId().isEmpty()) {
            this.setupCmbTarget();
        }
        if ((info = monitor.getPluginCheckInfo()) != null && info.getMonitorPluginStringInfoList() != null && !info.getMonitorPluginStringInfoList().isEmpty() && this.cmbTarget.indexOf((stringInfo = (MonitorPluginStringInfo)info.getMonitorPluginStringInfoList().get(0)).getValue()) != -1) {
            this.cmbTarget.select(this.cmbTarget.indexOf(stringInfo.getValue()));
        }
        this.m_numericValueInfo.setInputData(monitor);
    }

    @Override
    protected MonitorInfo createInputData() {
        super.createInputData();
        if (this.validateResult != null) {
            return null;
        }
        if (this.cmbTarget.getText() == null || this.cmbTarget.getText().isEmpty()) {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)this.msgSelectTarget);
            return null;
        }
        this.monitorInfo.setMonitorTypeId("MON_BILLING");
        PluginCheckInfo pluginInfo = new PluginCheckInfo();
        pluginInfo.setMonitorId(this.monitorInfo.getMonitorId());
        pluginInfo.setMonitorTypeId("MON_BILLING");
        MonitorPluginStringInfo stringInfo = new MonitorPluginStringInfo();
        stringInfo.setMonitorId(this.monitorInfo.getMonitorId());
        stringInfo.setKey("target");
        stringInfo.setValue((String)this.cmbTarget.getData(this.cmbTarget.getText()));
        pluginInfo.getMonitorPluginStringInfoList().add(stringInfo);
        this.monitorInfo.setPluginCheckInfo(pluginInfo);
        this.validateResult = this.m_numericValueInfo.createInputData(this.monitorInfo);
        if (this.validateResult != null) {
            return null;
        }
        this.monitorInfo.setNotifyGroupId(NotifyGroupIdGenerator.createNotifyGroupId((String)"MON_BILLING", (String)pluginInfo.getMonitorId()));
        this.validateResult = this.m_notifyInfo.createInputData(this.monitorInfo);
        if (this.validateResult != null) {
            if (this.validateResult.getID() == null) {
                if (!this.displayQuestion(this.validateResult)) {
                    this.validateResult = null;
                    return null;
                }
            } else {
                return null;
            }
        }
        return this.monitorInfo;
    }

    protected boolean action() {
        boolean result;
        block14: {
            result = false;
            MonitorInfo info = this.inputData;
            if (info != null) {
                Object[] args = new String[]{info.getMonitorId()};
                if (!this.updateFlg) {
                    try {
                        result = MonitorSettingEndpointWrapper.addMonitor((MonitorInfo)info);
                        if (result) {
                            MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.monitor.33", (Object[])args));
                            break block14;
                        }
                        MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)Messages.getString((String)"message.monitor.34", (Object[])args));
                    }
                    catch (MonitorDuplicate_Exception e) {
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.monitor.53", (Object[])args));
                    }
                    catch (Exception e) {
                        String errMessage = "";
                        if (e instanceof com.clustercontrol.ws.monitor.InvalidRole_Exception) {
                            MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                        } else {
                            errMessage = ", " + e.getMessage();
                        }
                        MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(Messages.getString((String)"message.monitor.34", (Object[])args) + errMessage));
                    }
                } else {
                    String errMessage = "";
                    try {
                        result = MonitorSettingEndpointWrapper.modifyMonitor((MonitorInfo)info);
                    }
                    catch (com.clustercontrol.ws.monitor.InvalidRole_Exception e) {
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"message"), (String)Messages.getString((String)"message.accesscontrol.16"));
                    }
                    catch (Exception e) {
                        errMessage = ", " + e.getMessage();
                    }
                    if (result) {
                        MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)Messages.getString((String)"message.monitor.35", (Object[])args));
                    } else {
                        MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)(Messages.getString((String)"message.monitor.36", (Object[])args) + errMessage));
                    }
                }
            }
        }
        return result;
    }

    @Override
    protected void setInfoInitialValue(MonitorInfo monitor) {
        super.setInfoInitialValue(monitor);
    }

    private void setupCmbTarget() {
        this.cmbTarget.removeAll();
        try {
            List billingServices = Activator.getEndpointManager().getEndpoint(CloudEndpoint.class).getCloudServicesForBilling(this.m_monitorBasic.getFacilityId());
            if (billingServices != null) {
                for (String service : billingServices) {
                    this.cmbTarget.add(service);
                    this.cmbTarget.setData(service, (Object)service);
                }
            }
        }
        catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e1) {
            e1.printStackTrace();
        }
    }
}

