/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.presenter;

import com.clustercontrol.cloud.plugin.decorator.ARDecoratorProvider;
import com.clustercontrol.cloud.presenter.AccountResourceManager;
import com.clustercontrol.cloud.presenter.CloudServiceManager;
import com.clustercontrol.cloud.presenter.Element;
import com.clustercontrol.cloud.presenter.HinemosService;
import com.clustercontrol.cloud.presenter.ICloudResourceManager;
import com.clustercontrol.cloud.presenter.IEndpointManager;

public class CloudResourceManager
extends Element
implements ICloudResourceManager {
    private IEndpointManager endpointManager;
    private HinemosService hinemosService;
    private CloudServiceManager cloudServiceManager;
    private AccountResourceManager accountResourceManager;
    private ARDecoratorProvider aRDecoratorProvider;

    public CloudResourceManager(IEndpointManager endpointManager) {
        assert (endpointManager != null);
        this.endpointManager = endpointManager;
    }

    @Override
    public CloudServiceManager getCloudServiceManager() {
        if (this.cloudServiceManager == null) {
            this.cloudServiceManager = new CloudServiceManager(this);
        }
        return this.cloudServiceManager;
    }

    @Override
    public AccountResourceManager getAccountResourceManager() {
        if (this.accountResourceManager == null) {
            this.accountResourceManager = new AccountResourceManager(this);
        }
        return this.accountResourceManager;
    }

    @Override
    public ARDecoratorProvider getARDecoratorProvider() {
        if (this.aRDecoratorProvider == null) {
            this.aRDecoratorProvider = new ARDecoratorProvider(this);
        }
        return this.aRDecoratorProvider;
    }

    @Override
    public HinemosService getHinemosService() {
        if (this.hinemosService == null) {
            this.hinemosService = new HinemosService(this);
        }
        return this.hinemosService;
    }

    public <T> T getEndpoint(Class<T> clazz) {
        return this.endpointManager.getEndpoint(clazz);
    }

    @Override
    public String getAccountName() {
        return this.endpointManager.getAccountName();
    }
}

