/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.presenter;

import com.clustercontrol.cloud.commons.util.AccountControlUtil;
import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.presenter.AccountResource;
import com.clustercontrol.cloud.presenter.CloudModelException;
import com.clustercontrol.cloud.presenter.CloudTemplate;
import com.clustercontrol.cloud.presenter.CreateCloudTemplateRequest;
import com.clustercontrol.cloud.presenter.ICloudTemplateManager;
import com.clustercontrol.cloud.presenter.InternalContainer;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloud.CreateTemplateRequest;
import com.clustercontrol.ws.cloud.InvalidRole_Exception;
import com.clustercontrol.ws.cloud.InvalidUserPass_Exception;
import java.util.List;

public class CloudTemplateManager
extends InternalContainer<CloudTemplate, com.clustercontrol.ws.cloud.CloudTemplate>
implements ICloudTemplateManager {
    private AccountResource accountResource;

    public CloudTemplateManager(AccountResource accountResource) {
        this.accountResource = accountResource;
    }

    @Override
    public CloudTemplate getCloudTemplate(String cloudTemplateId) {
        for (CloudTemplate cloudTemplate : this.getComponents()) {
            if (!cloudTemplate.getTemplateId().equals(cloudTemplateId)) continue;
            return cloudTemplate;
        }
        return null;
    }

    public CloudTemplate[] getCloudTemplates() {
        return this.getComponents().toArray(new CloudTemplate[0]);
    }

    @Override
    public CloudTemplate createCloudTemplate(CreateCloudTemplateRequest createTemplateRequest) {
        CreateTemplateRequest wsCreateCloudTemplateRequest = new CreateTemplateRequest();
        ControlUtil.exportObject(createTemplateRequest, wsCreateCloudTemplateRequest);
        try {
            com.clustercontrol.ws.cloud.CloudTemplate reWsCloudTemplate = this.getEndpoint().addTemplate(this.getRoleId(), wsCreateCloudTemplateRequest);
            CloudTemplate cloudTemplate = CloudTemplate.createCloudTemplate(this, reWsCloudTemplate);
            this.getComponents().add(cloudTemplate);
            this.fireComponentAdded(cloudTemplate);
            return cloudTemplate;
        }
        catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    public void removeCloudTemplate(String templateId) {
        try {
            this.getEndpoint().removeTemplate(this.getRoleId(), templateId);
        }
        catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
            throw new CloudModelException(e);
        }
        CloudTemplate cloudTemplate = this.getCloudTemplate(templateId);
        this.getComponents().remove(cloudTemplate);
        this.fireComponentRemoved(cloudTemplate);
    }

    @Override
    protected List<com.clustercontrol.ws.cloud.CloudTemplate> getSources() throws CloudModelException {
        try {
            return this.getEndpoint().getTemplates(this.getRoleId());
        }
        catch (Exception e) {
            throw new CloudModelException(e);
        }
    }

    @Override
    protected CloudTemplate createComponent(com.clustercontrol.ws.cloud.CloudTemplate source) throws CloudModelException {
        CloudTemplate cloudTemplate = new CloudTemplate(this);
        cloudTemplate.overwrite(source);
        return cloudTemplate;
    }

    @Override
    protected void fireComponentAdded(CloudTemplate addedValue) {
        this.fireElementAdded(ICloudTemplateManager.p2.cloudTemplates, addedValue);
    }

    @Override
    protected void fireComponentRemoved(CloudTemplate removedValue) {
        this.fireElementRemoved(ICloudTemplateManager.p2.cloudTemplates, removedValue);
    }

    private CloudEndpoint getEndpoint() {
        return this.getAccountResource().getAccountResourceManager().getCloudResourceManager().getEndpoint(CloudEndpoint.class);
    }

    private String getRoleId() {
        try {
            if (AccountControlUtil.isInitializedActiveUser(this.getAccountResource().getAccountResourceId()).booleanValue()) {
                return this.getAccountResource().getActiveUser().getRoleId();
            }
        }
        catch (AccountControlUtil.NotFoundAccountResourceException notFoundAccountResourceException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public AccountResource getAccountResource() {
        return this.accountResource;
    }
}

