/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.presenter;

import com.clustercontrol.cloud.presenter.Event;
import com.clustercontrol.cloud.presenter.EventListener;
import com.clustercontrol.cloud.presenter.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EventNotifier2 {
    private Map<Object, List<?>> listenersMap = new HashMap();
    private List<Command> commands = new ArrayList<Command>();
    protected int notifyingDepth = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <L extends EventListener> void addEventListeners(final Type<L> type, final L listener) {
        Map<Object, List<?>> map = this.listenersMap;
        synchronized (map) {
            if (this.notifyingDepth == 0) {
                this.doAdd(type, listener);
            } else {
                this.commands.add(new Command(){

                    @Override
                    public void execute() {
                        EventNotifier2.this.doAdd(type, listener);
                    }
                });
            }
        }
    }

    private <L extends EventListener> void doAdd(Type<L> type, L listener) {
        List<?> list = this.listenersMap.get(type);
        if (list == null) {
            list = new ArrayList();
            this.listenersMap.put(type, list);
        }
        list.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <L extends EventListener> void removeEventListeners(final Type<L> type, final L listener) {
        Map<Object, List<?>> map = this.listenersMap;
        synchronized (map) {
            if (this.notifyingDepth == 0) {
                this.doRemove(type, listener);
            } else {
                this.commands.add(new Command(){

                    @Override
                    public void execute() {
                        EventNotifier2.this.doRemove(type, listener);
                    }
                });
            }
        }
    }

    private <L extends EventListener> void doRemove(Type<L> type, L listener) {
        List<?> list = this.listenersMap.get(type);
        if (list != null) {
            list.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S, L extends EventListener> void fireEvent(Event<S, L> event) {
        Map<Object, List<?>> map = this.listenersMap;
        synchronized (map) {
            ++this.notifyingDepth;
            List<?> list = this.listenersMap.get(event.getAssociatedType());
            if (list != null) {
                for (EventListener listener : list) {
                    event.dispatch(listener);
                }
            }
            for (Command c : this.commands) {
                c.execute();
            }
            --this.notifyingDepth;
        }
    }

    private static interface Command {
        public void execute();
    }
}

