/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.ui.views;

import com.clustercontrol.cloud.Activator;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.commons.util.TableViewerSorter;
import com.clustercontrol.cloud.presenter.AllPropertyObserver;
import com.clustercontrol.cloud.presenter.CollectionObserver2;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.presenter.IAccountResourceManager;
import com.clustercontrol.cloud.presenter.IElement;
import com.clustercontrol.cloud.ui.views.AbstractCloudViewPart;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class AccountResourcesView
extends AbstractCloudViewPart {
    public static final String Id = "com.clustercontrol.cloud.ui.views.AccountResourcesView";
    private static MessageManager bundle_messages = MessageManager.getInstance("messages");
    private Table table;
    private TableViewer tableViewer;
    private Label lblFooter;
    private IAccountResourceManager accountResourceManager = Activator.getDefault().getCloudResourceManager().getAccountResourceManager();
    private List<IAccountResource> accountResources;
    private String footerTitle = bundle_messages.getString("word.view_item_count") + bundle_messages.getString("caption.title_separator");
    private CollectionObserver2<IAccountResource> elementObserver = new CollectionObserver2<IAccountResource>(){

        @Override
        public void elementAdded(CollectionObserver2.ElementAddedEvent<IAccountResource> event) {
            event.getAddedElement().addPropertyObserver2(IElement.allProperty, AccountResourcesView.this.propertyObserver);
            AccountResourcesView.this.accountResources.add(event.getAddedElement());
            AccountResourcesView.this.tableViewer.setInput((Object)AccountResourcesView.this.accountResources);
            AccountResourcesView.this.lblFooter.setText(AccountResourcesView.this.footerTitle + AccountResourcesView.this.accountResources.size());
            AccountResourcesView.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    AccountResourcesView.this.tableViewer.refresh(true);
                    ISelection selection = AccountResourcesView.this.tableViewer.getSelection();
                    AccountResourcesView.this.getSite().getSelectionProvider().setSelection(selection);
                }
            });
        }

        @Override
        public void elementRemoved(CollectionObserver2.ElementRemovedEvent<IAccountResource> event) {
            event.getRemovedElement().removePropertyObserver2(IElement.allProperty, AccountResourcesView.this.propertyObserver);
            AccountResourcesView.this.accountResources.remove(event.getRemovedElement());
            AccountResourcesView.this.tableViewer.setInput((Object)AccountResourcesView.this.accountResources);
            AccountResourcesView.this.lblFooter.setText(AccountResourcesView.this.footerTitle + AccountResourcesView.this.accountResources.size());
            AccountResourcesView.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    AccountResourcesView.this.tableViewer.refresh(true);
                    ISelection selection = AccountResourcesView.this.tableViewer.getSelection();
                    AccountResourcesView.this.getSite().getSelectionProvider().setSelection(selection);
                }
            });
        }
    };
    private AllPropertyObserver propertyObserver = new AllPropertyObserver(){

        @Override
        public void propertyChanged(AllPropertyObserver.ValueChangedEvent event) {
            AccountResourcesView.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    AccountResourcesView.this.tableViewer.refresh(true);
                    ISelection selection = AccountResourcesView.this.tableViewer.getSelection();
                    AccountResourcesView.this.getSite().getSelectionProvider().setSelection(selection);
                }
            });
        }

        @Override
        public void elementRemoved(AllPropertyObserver.ElementRemovedEvent event) {
            AccountResourcesView.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    AccountResourcesView.this.tableViewer.refresh(true);
                    ISelection selection = AccountResourcesView.this.tableViewer.getSelection();
                    AccountResourcesView.this.getSite().getSelectionProvider().setSelection(selection);
                }
            });
        }

        @Override
        public void elementAdded(AllPropertyObserver.ElementAddedEvent event) {
            AccountResourcesView.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    AccountResourcesView.this.tableViewer.refresh(true);
                    ISelection selection = AccountResourcesView.this.tableViewer.getSelection();
                    AccountResourcesView.this.getSite().getSelectionProvider().setSelection(selection);
                }
            });
        }
    };

    @Override
    protected void internalCreatePartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        Composite composite_1 = new Composite(composite, 0);
        TableColumnLayout tcl_composite_1 = new TableColumnLayout();
        composite_1.setLayout((Layout)tcl_composite_1);
        this.tableViewer = new TableViewer(composite_1, 67586);
        this.table = this.tableViewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        for (final ViewColumn column : ViewColumn.values()) {
            if (!Activator.getDefault().isEnterprisePlugined().booleanValue() && (column.equals((Object)ViewColumn.retention_period) || column.equals((Object)ViewColumn.collect_billing))) continue;
            TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
            TableColumn tableColumn = tableViewerColumn.getColumn();
            tcl_composite_1.setColumnData((Widget)tableColumn, (ColumnLayoutData)column.getPixelData());
            tableColumn.setText(column.getLabel());
            tableViewerColumn.setLabelProvider((CellLabelProvider)column.getProvider());
            tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AccountResourcesView.this.tableViewer.setSorter((ViewerSorter)new TableViewerSorter(AccountResourcesView.this.tableViewer, column.getProvider()));
                }
            });
        }
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
        GridLayout gl_composite = new GridLayout(1, true);
        gl_composite.horizontalSpacing = 0;
        gl_composite.marginHeight = 0;
        gl_composite.marginWidth = 0;
        gl_composite.verticalSpacing = 0;
        composite.setLayout((Layout)gl_composite);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        composite_1.setLayoutData((Object)gridData);
        this.lblFooter = new Label(composite, 0);
        this.lblFooter.setAlignment(131072);
        this.lblFooter.setSize(this.lblFooter.getSize().x, 80);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.lblFooter.setLayoutData((Object)gridData);
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        try {
            this.update();
        }
        catch (Throwable e) {
            this.lblFooter.setText(this.footerTitle + 0);
            Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
            logger.error((Object)e.getMessage(), e);
        }
    }

    private List<IAccountResource> getAccountResources() {
        if (this.accountResources == null) {
            try {
                this.accountResourceManager.addPropertyObserver2(IAccountResourceManager.p2.accountResources, this.elementObserver);
                for (IAccountResource accountResource : this.accountResourceManager.getAccountResources()) {
                    accountResource.addPropertyObserver2(IElement.allProperty, this.propertyObserver);
                }
                this.accountResources = new ArrayList<IAccountResource>();
                this.accountResources.addAll(Arrays.asList(this.accountResourceManager.getAccountResources()));
            }
            catch (Exception e) {
                Logger logger = Logger.getLogger(AccountResourcesView.class);
                logger.warn((Object)"fail to get accountResources", (Throwable)e);
                this.accountResources = new ArrayList<IAccountResource>();
            }
        }
        return this.accountResources;
    }

    public void update() {
        if (this.accountResources != null) {
            for (IAccountResource accountResource : this.accountResources) {
                accountResource.removePropertyObserver2(IElement.allProperty, this.propertyObserver);
            }
            this.accountResources = null;
        }
        if (this.accountResourceManager != null) {
            this.accountResourceManager.removePropertyObserver2(IAccountResourceManager.p2.accountResources, this.elementObserver);
            this.accountResourceManager.update();
        }
        List<IAccountResource> accountResources = this.getAccountResources();
        this.tableViewer.setInput(accountResources);
        this.lblFooter.setText(this.footerTitle + accountResources.size());
    }

    @Override
    protected StructuredViewer getViewer() {
        return this.tableViewer;
    }

    private static enum ViewColumn {
        account_resource_id(AccountResourcesView.access$500().getString("word.account_resource_id"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IAccountResource)element).getAccountResourceId();
            }
        }),
        account_resource_name(AccountResourcesView.access$500().getString("word.account_resource_name"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IAccountResource)element).getAccountResourceName();
            }
        }),
        service_id(AccountResourcesView.access$500().getString("word.cloud_service_id"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IAccountResource)element).getCloudServiceId();
            }
        }),
        collect_billing(AccountResourcesView.access$500().getString("word.billing_detail_collection"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                if (((IAccountResource)element).getBillingDetailCollectorFlg().booleanValue()) {
                    return bundle_messages.getString("word.enable");
                }
                return bundle_messages.getString("word.disable");
            }
        }),
        retention_period(AccountResourcesView.access$500().getString("word.retention_period"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                if (((IAccountResource)element).getRetentionPeriod() != null) {
                    return ((IAccountResource)element).getRetentionPeriod().toString() + bundle_messages.getString("word.days");
                }
                return null;
            }
        }),
        reg_user(AccountResourcesView.access$500().getString("word.reg_user"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IAccountResource)element).getRegUser();
            }
        }),
        reg_date(AccountResourcesView.access$500().getString("word.reg_date"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                if (((IAccountResource)element).getRegDate() != null) {
                    return format.format(((IAccountResource)element).getRegDate());
                }
                return "";
            }
        }),
        update_user(AccountResourcesView.access$500().getString("word.update_user"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((IAccountResource)element).getUpdateUser();
            }
        }),
        update_date(AccountResourcesView.access$500().getString("word.update_date"), new ColumnPixelData(100, true, true), new ColumnLabelProvider(){

            public String getText(Object element) {
                if (((IAccountResource)element).getUpdateDate() != null) {
                    return format.format(((IAccountResource)element).getUpdateDate());
                }
                return "";
            }
        });

        private String label;
        private ColumnLabelProvider provider;
        private ColumnPixelData pixelData;
        private static SimpleDateFormat format;

        private ViewColumn(String label, ColumnPixelData pixelData, ColumnLabelProvider provider) {
            this.label = label;
            this.pixelData = pixelData;
            this.provider = provider;
        }

        public String getLabel() {
            return this.label;
        }

        public ColumnPixelData getPixelData() {
            return this.pixelData;
        }

        public ColumnLabelProvider getProvider() {
            return this.provider;
        }

        static {
            format = new SimpleDateFormat("yyyy/MM/dd H:mm:ss");
        }
    }
}

