package com.clustercontrol.cloud.presenter;


import java.util.ArrayList;
import java.util.List;

import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.annotation.Export;
import com.clustercontrol.cloud.commons.util.annotation.Import;
import com.clustercontrol.cloud.resources.Tag;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloud.InvalidRole_Exception;
import com.clustercontrol.ws.cloud.InvalidUserPass_Exception;

public class CloudInstanceBackup extends InternalComponent<CloudInstanceBackupManager, com.clustercontrol.ws.cloud.CloudInstanceBackup> implements ICloudInstanceBackup {
	private String accountResourceId;
    private String cloudUserId;
    private String description;
    private String instanceBackupId;
    private String name;
    private String platform;
    private Long regDate;
    private String regUser;
    private String region;
    private String restoreStatus;
    
//    private String facilityDescription;
//    private String facilityId;
//    private String facilityName;
//    private String instanceId;
//    private String nodeName;

    private String cloudTypeId;
    
    private BackupedData backupedData;

    public CloudInstanceBackup(CloudInstanceBackupManager container) {
		super(container);
	}
	
//	@Override
//	@Export
//	public String getFacilityId() {
//		return facilityId;
//	}
//	
//	@Import
//	public void setFacilityId(String facilityId) {
//		internalSet("facilityId", p2.facilityId, facilityId);
//	}
//	
//	@Override
//	@Export
//	public String getFacilityName() {
//		return facilityName;
//	}
//	
//	@Import
//	public void setFacilityName(String facilityName) {
//		internalSet("facilityName", p2.facilityName, facilityName);
//	}
//	
//	@Override
//	@Export
//	public String getInstanceId() {
//		return instanceId;
//	}
//	
//	@Import
//	public void setInstanceId(String instanceId) {
//		internalSet("instanceId", p2.instanceId, instanceId);
//	}

	@Override
	@Export
	public String getPlatform() {
		return platform;
	}
	
	@Import
	public void setPlatform(String platform) {
		internalSet("platform", p2.platform, platform);
	}

	@Override
	@Export
	public String getRegion() {
		return region;
	}
	
	@Import
	public void setRegion(String region) {
		internalSet("region", p2.region, region);
	}

	@Override
	@Export
	public Long getRegDate() {
		return regDate;
	}
	
	@Import
	public void setRegDate(Long regDate) {
		internalSet("regDate", p2.regDate, regDate);
	}
	
	@Override
	@Export
	public String getRegUser() {
		return regUser;
	}
	
	@Import
	public void setRegUser(String regUser) {
		internalSet("regUser", p2.regUser, regUser);
	}
	

	@Override
	@Export
	public String getCloudUserId() {
		return cloudUserId;
	}

	@Import
	public void setCloudUserId(String cloudUserId) {
		internalSet("cloudUserId", p2.cloudUserId, cloudUserId);
	}

//	@Override
//	@Export
//	public String getNodeName() {
//		return nodeName;
//	}
//
//	@Import
//	public void setNodeName(String nodeName) {
//		internalSet("nodeName", p2.nodeName, nodeName);
//	}
//
//	@Override
//	@Export
//	public String getFacilityDescription() {
//		return facilityDescription;
//	}
//
//	@Import
//	public void setFacilityDescription(String facilityDescription) {
//		internalSet("facilityDescription", p2.facilityDescription, facilityDescription);
//	}

	@Override
	@Export
	public String getRestoreStatus() {
		return restoreStatus;
	}

	@Import
	public void setRestoreStatus(String restoreStatus) {
		internalSet("restoreStatus", p2.restoreStatus, restoreStatus);
	}

	@Override
	@Export
	public String getName() {
		return name;
	}

	@Import
	public void setName(String name) {
		internalSet("name", p2.name, name);
	}

	@Override
	@Export
	public String getInstanceBackupId() {
		return instanceBackupId;
	}

	@Import
	public void setInstanceBackupId(String instanceBackupId) {
		internalSet("instanceBackupId", p2.instanceBackupId, instanceBackupId);
	}

	@Override
	@Export
	public String getDescription() {
		return description;
	}

	@Import
	public void setDescription(String description) {
		internalSet("description", p2.description, description);
	}

	@Override
	@Export
	public String getAccountResourceId() {
		return accountResourceId;
	}

	@Import
	public void setAccountResourceId(String accountResourceId) {
		internalSet("accountResourceId", p2.accountResourceId, accountResourceId);
	}

	@Override
	@Export
	public String getCloudTypeId() {
		return cloudTypeId;
	}

	@Import
	public void setCloudTypeId(String cloudTypeId) {
		internalSet("cloudTypeId", p2.cloudTypeId, cloudTypeId);
	}

	@Override
	public CloudInstanceBackupManager getCloudInstanceBackupManager() {
		return getContainer();
	}
	
	@Override
	public boolean equalValues(com.clustercontrol.ws.cloud.CloudInstanceBackup source) {
		return this.instanceBackupId.equals(source.getInstanceBackupId());
	}
	
	public static CloudInstanceBackup createCloudInstanceBackup(CloudInstanceBackupManager cloudInstanceManager, com.clustercontrol.ws.cloud.CloudInstanceBackup source) {
		CloudInstanceBackup cloudInstance = new CloudInstanceBackup(cloudInstanceManager);
		cloudInstance.overwrite(source);
		return cloudInstance;
	}

	@Override
	public com.clustercontrol.ws.cloud.CloudInstanceBackup getSource() throws CloudModelException {
		try {
			return getEndpoint().getInstanceBackup(getCloudInstanceBackupManager().getRegion().getAccountResource().getActiveUser().getRoleId(), region, instanceBackupId);
		} catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
			throw new CloudModelException(e);
		}
	}

	@Override
	protected void overwrite(com.clustercontrol.ws.cloud.CloudInstanceBackup source) {
		ControlUtil.importObject(this, source);
//		if(source.getBackupedData() != null){
//			ControlUtil.importObject(this, source.getBackupedData());
//		}
		if(source.getRestoreStatus() != null){
			setRestoreStatus(source.getRestoreStatus().value());
		}
		setCloudTypeId(internalGetCloudTypeId());
		
		List<Tag> tags = new ArrayList<>();
		for (com.clustercontrol.ws.cloud.Tag t: source.getBackupedData().getTags()) {
			tags.add(new Tag(t.getKey(), t.getValue()));
		}
		
		setBackupedData(new BackupedData(
				source.getBackupedData().getFacilityId(),
				source.getBackupedData().getFacilityName(),
				source.getBackupedData().getInstanceId(),
				source.getBackupedData().getNodeName(),
				source.getBackupedData().getFlavor(),
				source.getBackupedData().getInstanceDetail(),
				tags,
				source.getBackupedData().getZone())
				);
	}

	private CloudEndpoint getEndpoint(){
		return this.getCloudInstanceBackupManager().getRegion().getAccountResource().getAccountResourceManager().getCloudResourceManager().getEndpoint(CloudEndpoint.class);
	}
	
	
//
//	private String getRoleId(){
//		return getCloudInstanceBackupManager().getRegion().getAccountResource().getActiveUser().getRoleId();
//	}
	
	private String internalGetCloudTypeId(){
		String cloudServiceId = getCloudInstanceBackupManager().getCloudComputeService().getRegion().getAccountResource().getCloudServiceId();
		String cloudTypeId = getCloudInstanceBackupManager().getCloudComputeService().getRegion().getAccountResource().getAccountResourceManager().getCloudResourceManager().getCloudServiceManager().getCloudService(cloudServiceId).getCloudTypeId();
		return cloudTypeId;
	}

	@Override
	public BackupedData getBackupedData() {
		return backupedData;
	}
	
	public void setBackupedData(BackupedData backupedData) {
		internalSet("backupedData", p2.backupedData, backupedData);
	}
}
