package com.clustercontrol.cloud.presenter;

import java.util.ArrayList;
import java.util.List;

import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloud.InvalidRole_Exception;
import com.clustercontrol.ws.cloud.InvalidUserPass_Exception;

public class CloudServiceManager extends Element implements ICloudServiceManager {
	private List<CloudService> cloudServices;
	private CloudResourceManager cloudResourceManager;

	public CloudServiceManager(CloudResourceManager cloudResourceManager){
		this.cloudResourceManager = cloudResourceManager;
	}
	
	@Override
	public CloudResourceManager getCloudResourceManager() {
		return cloudResourceManager;
	}
	
	@Override
	public CloudService[] getCloudServices() {
		if(!isInitialized()){
			update();
		}
		return cloudServices.toArray(new CloudService[0]);
	}

	@Override
	public CloudService createCloudService(CreateCloudServiceRequest Request) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void removeCloudService(String cloudServiceId) {
		// TODO Auto-generated method stub

	}

	@Override
	public CloudService getCloudService(String cloudServiceId) {
		for(CloudService cloudService: getCloudServices()){
			if(cloudService.getCloudServiceId().equals(cloudServiceId)){
				return cloudService;
			}
		}
		return null;
	}

	@Override
	public void update (){
		cloudServices = new ArrayList<CloudService>();
		List<com.clustercontrol.ws.cloud.CloudService> wsCloudServices;
		
		try {
			wsCloudServices = getCloudResourceManager().getEndpoint(CloudEndpoint.class).getAllCloudServices();
		} catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
			throw new CloudModelException(e);
		}
		
		for(com.clustercontrol.ws.cloud.CloudService wsCloudService: wsCloudServices){
			CloudService cloudService = new CloudService(this);				
			ControlUtil.importObject(cloudService, wsCloudService);
			cloudServices.add(cloudService);
		}
		
		super.update();
	}
	
	Boolean isInitialized(){
		return cloudServices != null;
	}
}
